/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hdds.protocol.StorageType;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.om.BucketManager;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmBucketArgs;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.util.Time;
import org.iq80.leveldb.DBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BucketManagerImpl
implements BucketManager {
    private static final Logger LOG = LoggerFactory.getLogger(BucketManagerImpl.class);
    private final OMMetadataManager metadataManager;

    public BucketManagerImpl(OMMetadataManager metadataManager) {
        this.metadataManager = metadataManager;
    }

    @Override
    public void createBucket(OmBucketInfo bucketInfo) throws IOException {
        Preconditions.checkNotNull((Object)bucketInfo);
        String volumeName = bucketInfo.getVolumeName();
        String bucketName = bucketInfo.getBucketName();
        this.metadataManager.getLock().acquireVolumeLock(volumeName);
        this.metadataManager.getLock().acquireBucketLock(volumeName, bucketName);
        try {
            byte[] volumeKey = this.metadataManager.getVolumeKey(volumeName);
            byte[] bucketKey = this.metadataManager.getBucketKey(volumeName, bucketName);
            if (this.metadataManager.getVolumeTable().get(volumeKey) == null) {
                LOG.debug("volume: {} not found ", (Object)volumeName);
                throw new OMException("Volume doesn't exist", OMException.ResultCodes.FAILED_VOLUME_NOT_FOUND);
            }
            if (this.metadataManager.getBucketTable().get(bucketKey) != null) {
                LOG.debug("bucket: {} already exists ", (Object)bucketName);
                throw new OMException("Bucket already exist", OMException.ResultCodes.FAILED_BUCKET_ALREADY_EXISTS);
            }
            OmBucketInfo omBucketInfo = OmBucketInfo.newBuilder().setVolumeName(bucketInfo.getVolumeName()).setBucketName(bucketInfo.getBucketName()).setAcls(bucketInfo.getAcls()).setStorageType(bucketInfo.getStorageType()).setIsVersionEnabled(Boolean.valueOf(bucketInfo.getIsVersionEnabled())).setCreationTime(Time.now()).build();
            this.metadataManager.getBucketTable().put(bucketKey, omBucketInfo.getProtobuf().toByteArray());
            LOG.debug("created bucket: {} in volume: {}", (Object)bucketName, (Object)volumeName);
        }
        catch (IOException | DBException ex) {
            if (!(ex instanceof OMException)) {
                LOG.error("Bucket creation failed for bucket:{} in volume:{}", new Object[]{bucketName, volumeName, ex});
            }
            throw ex;
        }
        finally {
            this.metadataManager.getLock().releaseBucketLock(volumeName, bucketName);
            this.metadataManager.getLock().releaseVolumeLock(volumeName);
        }
    }

    @Override
    public OmBucketInfo getBucketInfo(String volumeName, String bucketName) throws IOException {
        Preconditions.checkNotNull((Object)volumeName);
        Preconditions.checkNotNull((Object)bucketName);
        this.metadataManager.getLock().acquireBucketLock(volumeName, bucketName);
        try {
            byte[] bucketKey = this.metadataManager.getBucketKey(volumeName, bucketName);
            byte[] value = this.metadataManager.getBucketTable().get(bucketKey);
            if (value == null) {
                LOG.debug("bucket: {} not found in volume: {}.", (Object)bucketName, (Object)volumeName);
                throw new OMException("Bucket not found", OMException.ResultCodes.FAILED_BUCKET_NOT_FOUND);
            }
            OmBucketInfo omBucketInfo = OmBucketInfo.getFromProtobuf((OzoneManagerProtocolProtos.BucketInfo)OzoneManagerProtocolProtos.BucketInfo.parseFrom((byte[])value));
            return omBucketInfo;
        }
        catch (IOException | DBException ex) {
            if (!(ex instanceof OMException)) {
                LOG.error("Exception while getting bucket info for bucket: {}", (Object)bucketName, (Object)ex);
            }
            throw ex;
        }
        finally {
            this.metadataManager.getLock().releaseBucketLock(volumeName, bucketName);
        }
    }

    @Override
    public void setBucketProperty(OmBucketArgs args) throws IOException {
        Preconditions.checkNotNull((Object)args);
        String volumeName = args.getVolumeName();
        String bucketName = args.getBucketName();
        this.metadataManager.getLock().acquireBucketLock(volumeName, bucketName);
        try {
            byte[] bucketKey = this.metadataManager.getBucketKey(volumeName, bucketName);
            byte[] value = this.metadataManager.getBucketTable().get(bucketKey);
            if (value == null) {
                LOG.debug("bucket: {} not found ", (Object)bucketName);
                throw new OMException("Bucket doesn't exist", OMException.ResultCodes.FAILED_BUCKET_NOT_FOUND);
            }
            OmBucketInfo oldBucketInfo = OmBucketInfo.getFromProtobuf((OzoneManagerProtocolProtos.BucketInfo)OzoneManagerProtocolProtos.BucketInfo.parseFrom((byte[])value));
            OmBucketInfo.Builder bucketInfoBuilder = OmBucketInfo.newBuilder();
            bucketInfoBuilder.setVolumeName(oldBucketInfo.getVolumeName()).setBucketName(oldBucketInfo.getBucketName());
            if (args.getAddAcls() != null || args.getRemoveAcls() != null) {
                bucketInfoBuilder.setAcls(this.getUpdatedAclList(oldBucketInfo.getAcls(), args.getRemoveAcls(), args.getAddAcls()));
                LOG.debug("Updating ACLs for bucket: {} in volume: {}", (Object)bucketName, (Object)volumeName);
            } else {
                bucketInfoBuilder.setAcls(oldBucketInfo.getAcls());
            }
            StorageType storageType = args.getStorageType();
            if (storageType != null) {
                bucketInfoBuilder.setStorageType(storageType);
                LOG.debug("Updating bucket storage type for bucket: {} in volume: {}", (Object)bucketName, (Object)volumeName);
            } else {
                bucketInfoBuilder.setStorageType(oldBucketInfo.getStorageType());
            }
            Boolean versioning = args.getIsVersionEnabled();
            if (versioning != null) {
                bucketInfoBuilder.setIsVersionEnabled(versioning);
                LOG.debug("Updating bucket versioning for bucket: {} in volume: {}", (Object)bucketName, (Object)volumeName);
            } else {
                bucketInfoBuilder.setIsVersionEnabled(Boolean.valueOf(oldBucketInfo.getIsVersionEnabled()));
            }
            bucketInfoBuilder.setCreationTime(oldBucketInfo.getCreationTime());
            this.metadataManager.getBucketTable().put(bucketKey, bucketInfoBuilder.build().getProtobuf().toByteArray());
        }
        catch (IOException | DBException ex) {
            if (!(ex instanceof OMException)) {
                LOG.error("Setting bucket property failed for bucket:{} in volume:{}", new Object[]{bucketName, volumeName, ex});
            }
            throw ex;
        }
        finally {
            this.metadataManager.getLock().releaseBucketLock(volumeName, bucketName);
        }
    }

    private List<OzoneAcl> getUpdatedAclList(List<OzoneAcl> existingAcls, List<OzoneAcl> removeAcls, List<OzoneAcl> addAcls) {
        if (removeAcls != null && !removeAcls.isEmpty()) {
            existingAcls.removeAll(removeAcls);
        }
        if (addAcls != null && !addAcls.isEmpty()) {
            addAcls.stream().filter(acl -> !existingAcls.contains(acl)).forEach(existingAcls::add);
        }
        return existingAcls;
    }

    @Override
    public void deleteBucket(String volumeName, String bucketName) throws IOException {
        Preconditions.checkNotNull((Object)volumeName);
        Preconditions.checkNotNull((Object)bucketName);
        this.metadataManager.getLock().acquireBucketLock(volumeName, bucketName);
        try {
            byte[] bucketKey = this.metadataManager.getBucketKey(volumeName, bucketName);
            if (this.metadataManager.getBucketTable().get(bucketKey) == null) {
                LOG.debug("bucket: {} not found ", (Object)bucketName);
                throw new OMException("Bucket doesn't exist", OMException.ResultCodes.FAILED_BUCKET_NOT_FOUND);
            }
            if (!this.metadataManager.isBucketEmpty(volumeName, bucketName)) {
                LOG.debug("bucket: {} is not empty ", (Object)bucketName);
                throw new OMException("Bucket is not empty", OMException.ResultCodes.FAILED_BUCKET_NOT_EMPTY);
            }
            this.metadataManager.getBucketTable().delete(bucketKey);
        }
        catch (IOException ex) {
            if (!(ex instanceof OMException)) {
                LOG.error("Delete bucket failed for bucket:{} in volume:{}", new Object[]{bucketName, volumeName, ex});
            }
            throw ex;
        }
        finally {
            this.metadataManager.getLock().releaseBucketLock(volumeName, bucketName);
        }
    }

    @Override
    public List<OmBucketInfo> listBuckets(String volumeName, String startBucket, String bucketPrefix, int maxNumOfBuckets) throws IOException {
        Preconditions.checkNotNull((Object)volumeName);
        return this.metadataManager.listBuckets(volumeName, startBucket, bucketPrefix, maxNumOfBuckets);
    }
}

