/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.storage;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.XceiverClientManager;
import org.apache.hadoop.hdds.scm.XceiverClientSpi;
import org.apache.hadoop.hdds.scm.storage.ContainerProtocolCalls;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;

public class ChunkOutputStream
extends OutputStream {
    private final BlockID blockID;
    private final String key;
    private final String traceID;
    private final ContainerProtos.BlockData.Builder containerBlockData;
    private XceiverClientManager xceiverClientManager;
    private XceiverClientSpi xceiverClient;
    private ByteBuffer buffer;
    private final String streamId;
    private int chunkIndex;
    private int chunkSize;
    private long blockCommitSequenceId;

    public ChunkOutputStream(BlockID blockID, String key, XceiverClientManager xceiverClientManager, XceiverClientSpi xceiverClient, String traceID, int chunkSize) {
        this.blockID = blockID;
        this.key = key;
        this.traceID = traceID;
        this.chunkSize = chunkSize;
        ContainerProtos.KeyValue keyValue = ContainerProtos.KeyValue.newBuilder().setKey("TYPE").setValue("KEY").build();
        this.containerBlockData = ContainerProtos.BlockData.newBuilder().setBlockID(blockID.getDatanodeBlockIDProtobuf()).addMetadata(keyValue);
        this.xceiverClientManager = xceiverClientManager;
        this.xceiverClient = xceiverClient;
        this.buffer = ByteBuffer.allocate(chunkSize);
        this.streamId = UUID.randomUUID().toString();
        this.chunkIndex = 0;
        this.blockCommitSequenceId = 0L;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public long getBlockCommitSequenceId() {
        return this.blockCommitSequenceId;
    }

    @Override
    public void write(int b) throws IOException {
        this.checkOpen();
        int rollbackPosition = this.buffer.position();
        int rollbackLimit = this.buffer.limit();
        this.buffer.put((byte)b);
        if (this.buffer.position() == this.chunkSize) {
            this.flushBufferToChunk(rollbackPosition, rollbackLimit);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.checkOpen();
        while (len > 0) {
            int writeLen = Math.min(this.chunkSize - this.buffer.position(), len);
            int rollbackPosition = this.buffer.position();
            int rollbackLimit = this.buffer.limit();
            this.buffer.put(b, off, writeLen);
            if (this.buffer.position() == this.chunkSize) {
                this.flushBufferToChunk(rollbackPosition, rollbackLimit);
            }
            off += writeLen;
            len -= writeLen;
        }
    }

    @Override
    public void flush() throws IOException {
        this.checkOpen();
        if (this.buffer.position() > 0) {
            int rollbackPosition = this.buffer.position();
            int rollbackLimit = this.buffer.limit();
            this.flushBufferToChunk(rollbackPosition, rollbackLimit);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.xceiverClientManager != null && this.xceiverClient != null && this.buffer != null) {
            if (this.buffer.position() > 0) {
                this.writeChunkToContainer();
            }
            try {
                ContainerProtos.PutBlockResponseProto responseProto = ContainerProtocolCalls.putBlock((XceiverClientSpi)this.xceiverClient, (ContainerProtos.BlockData)this.containerBlockData.build(), (String)this.traceID);
                this.blockCommitSequenceId = responseProto.getCommittedBlockLength().getBlockCommitSequenceId();
            }
            catch (IOException e) {
                throw new IOException("Unexpected Storage Container Exception: " + e.toString(), e);
            }
            finally {
                this.cleanup();
            }
        }
    }

    public void cleanup() {
        this.xceiverClientManager.releaseClient(this.xceiverClient);
        this.xceiverClientManager = null;
        this.xceiverClient = null;
        this.buffer = null;
    }

    private void checkOpen() throws IOException {
        if (this.xceiverClient == null) {
            throw new IOException("ChunkOutputStream has been closed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushBufferToChunk(int rollbackPosition, int rollbackLimit) throws IOException {
        boolean success = false;
        try {
            this.writeChunkToContainer();
            success = true;
        }
        finally {
            if (success) {
                this.buffer.clear();
            } else {
                this.buffer.position(rollbackPosition);
                this.buffer.limit(rollbackLimit);
            }
        }
    }

    private void writeChunkToContainer() throws IOException {
        this.buffer.flip();
        ByteString data = ByteString.copyFrom((ByteBuffer)this.buffer);
        ContainerProtos.ChunkInfo chunk = ContainerProtos.ChunkInfo.newBuilder().setChunkName(DigestUtils.md5Hex((String)this.key) + "_stream_" + this.streamId + "_chunk_" + ++this.chunkIndex).setOffset(0L).setLen((long)data.size()).build();
        try {
            ContainerProtocolCalls.writeChunk((XceiverClientSpi)this.xceiverClient, (ContainerProtos.ChunkInfo)chunk, (BlockID)this.blockID, (ByteString)data, (String)this.traceID);
        }
        catch (IOException e) {
            throw new IOException("Unexpected Storage Container Exception: " + e.toString(), e);
        }
        this.containerBlockData.addChunks(chunk);
    }
}

