/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.storage;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.XceiverClientManager;
import org.apache.hadoop.hdds.scm.XceiverClientSpi;
import org.apache.hadoop.hdds.scm.storage.ContainerProtocolCalls;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;

public class ChunkInputStream
extends InputStream
implements Seekable {
    private static final int EOF = -1;
    private final BlockID blockID;
    private final String traceID;
    private XceiverClientManager xceiverClientManager;
    private XceiverClientSpi xceiverClient;
    private List<ContainerProtos.ChunkInfo> chunks;
    private int chunkIndex;
    private long[] chunkOffset;
    private List<ByteBuffer> buffers;
    private int bufferIndex;

    public ChunkInputStream(BlockID blockID, XceiverClientManager xceiverClientManager, XceiverClientSpi xceiverClient, List<ContainerProtos.ChunkInfo> chunks, String traceID) {
        this.blockID = blockID;
        this.traceID = traceID;
        this.xceiverClientManager = xceiverClientManager;
        this.xceiverClient = xceiverClient;
        this.chunks = chunks;
        this.chunkIndex = -1;
        this.chunkOffset = new long[this.chunks.size()];
        this.initializeChunkOffset();
        this.buffers = null;
        this.bufferIndex = 0;
    }

    private void initializeChunkOffset() {
        int tempOffset = 0;
        for (int i = 0; i < this.chunks.size(); ++i) {
            this.chunkOffset[i] = tempOffset;
            tempOffset = (int)((long)tempOffset + this.chunks.get(i).getLen());
        }
    }

    @Override
    public synchronized int read() throws IOException {
        this.checkOpen();
        int available = this.prepareRead(1);
        return available == -1 ? -1 : Byte.toUnsignedInt(this.buffers.get(this.bufferIndex).get());
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        this.checkOpen();
        int total = 0;
        while (len > 0) {
            int available = this.prepareRead(len);
            if (available == -1) {
                return total != 0 ? total : -1;
            }
            this.buffers.get(this.bufferIndex).get(b, off + total, available);
            len -= available;
            total += available;
        }
        return total;
    }

    @Override
    public synchronized void close() {
        if (this.xceiverClientManager != null && this.xceiverClient != null) {
            this.xceiverClientManager.releaseClient(this.xceiverClient);
            this.xceiverClientManager = null;
            this.xceiverClient = null;
        }
    }

    private synchronized void checkOpen() throws IOException {
        if (this.xceiverClient == null) {
            throw new IOException("ChunkInputStream has been closed.");
        }
    }

    private synchronized int prepareRead(int len) throws IOException {
        while (true) {
            if (this.chunks == null || this.chunks.isEmpty()) {
                return -1;
            }
            if (this.buffers == null) {
                this.readChunkFromContainer();
                continue;
            }
            if (!this.buffers.isEmpty() && this.buffers.get(this.bufferIndex).hasRemaining()) {
                ByteBuffer bb = this.buffers.get(this.bufferIndex);
                return len > bb.remaining() ? bb.remaining() : len;
            }
            if (!this.buffers.isEmpty() && !this.buffers.get(this.bufferIndex).hasRemaining() && this.bufferIndex < this.buffers.size() - 1) {
                ++this.bufferIndex;
                continue;
            }
            if (this.chunkIndex >= this.chunks.size() - 1) break;
            this.readChunkFromContainer();
        }
        return -1;
    }

    private synchronized void readChunkFromContainer() throws IOException {
        ContainerProtos.ReadChunkResponseProto readChunkResponse;
        ++this.chunkIndex;
        ContainerProtos.ChunkInfo chunkInfo = this.chunks.get(this.chunkIndex);
        try {
            readChunkResponse = ContainerProtocolCalls.readChunk((XceiverClientSpi)this.xceiverClient, (ContainerProtos.ChunkInfo)chunkInfo, (BlockID)this.blockID, (String)this.traceID);
        }
        catch (IOException e) {
            throw new IOException("Unexpected OzoneException: " + e.toString(), e);
        }
        ByteString byteString = readChunkResponse.getData();
        if ((long)byteString.size() != chunkInfo.getLen()) {
            throw new IOException(String.format("Inconsistent read for chunk=%s len=%d bytesRead=%d", chunkInfo.getChunkName(), chunkInfo.getLen(), byteString.size()));
        }
        this.buffers = byteString.asReadOnlyByteBufferList();
        this.bufferIndex = 0;
    }

    public synchronized void seek(long pos) throws IOException {
        if (pos < 0L || this.chunks.size() == 0 && pos > 0L || pos >= this.chunkOffset[this.chunks.size() - 1] + this.chunks.get(this.chunks.size() - 1).getLen()) {
            throw new EOFException("EOF encountered pos: " + pos + " container key: " + this.blockID.getLocalID());
        }
        if (this.chunkIndex == -1) {
            this.chunkIndex = Arrays.binarySearch(this.chunkOffset, pos);
        } else if (pos < this.chunkOffset[this.chunkIndex]) {
            this.chunkIndex = Arrays.binarySearch(this.chunkOffset, 0, this.chunkIndex, pos);
        } else if (pos >= this.chunkOffset[this.chunkIndex] + this.chunks.get(this.chunkIndex).getLen()) {
            this.chunkIndex = Arrays.binarySearch(this.chunkOffset, this.chunkIndex + 1, this.chunks.size(), pos);
        }
        if (this.chunkIndex < 0) {
            this.chunkIndex = -this.chunkIndex - 2;
        }
        --this.chunkIndex;
        this.readChunkFromContainer();
        this.adjustBufferIndex(pos);
    }

    private void adjustBufferIndex(long pos) {
        long tempOffest = this.chunkOffset[this.chunkIndex];
        for (int i = 0; i < this.buffers.size(); ++i) {
            if (pos - tempOffest >= (long)this.buffers.get(i).capacity()) {
                tempOffest += (long)this.buffers.get(i).capacity();
                continue;
            }
            this.bufferIndex = i;
            break;
        }
        this.buffers.get(this.bufferIndex).position((int)(pos - tempOffest));
    }

    public synchronized long getPos() throws IOException {
        return this.chunkIndex == -1 ? 0L : this.chunkOffset[this.chunkIndex] + (long)this.buffers.get(this.bufferIndex).position();
    }

    public boolean seekToNewSource(long targetPos) throws IOException {
        return false;
    }

    public BlockID getBlockID() {
        return this.blockID;
    }
}

