/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.XceiverClientSpi;
import org.apache.hadoop.hdds.scm.client.HddsClientUtils;
import org.apache.hadoop.hdds.scm.container.common.helpers.Pipeline;
import org.apache.hadoop.io.MultipleIOException;
import org.apache.ratis.RatisHelper;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.rpc.RpcType;
import org.apache.ratis.rpc.SupportedRpcType;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.ratis.util.CheckedBiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XceiverClientRatis
extends XceiverClientSpi {
    static final Logger LOG = LoggerFactory.getLogger(XceiverClientRatis.class);
    private final Pipeline pipeline;
    private final RpcType rpcType;
    private final AtomicReference<RaftClient> client = new AtomicReference();
    private final int maxOutstandingRequests;
    private final RetryPolicy retryPolicy;

    public static XceiverClientRatis newXceiverClientRatis(Pipeline pipeline, Configuration ozoneConf) {
        String rpcType = ozoneConf.get("dfs.container.ratis.rpc.type", "GRPC");
        int maxOutstandingRequests = HddsClientUtils.getMaxOutstandingRequests(ozoneConf);
        RetryPolicy retryPolicy = RatisHelper.createRetryPolicy((Configuration)ozoneConf);
        return new XceiverClientRatis(pipeline, (RpcType)SupportedRpcType.valueOfIgnoreCase((String)rpcType), maxOutstandingRequests, retryPolicy);
    }

    private XceiverClientRatis(Pipeline pipeline, RpcType rpcType, int maxOutStandingChunks, RetryPolicy retryPolicy) {
        this.pipeline = pipeline;
        this.rpcType = rpcType;
        this.maxOutstandingRequests = maxOutStandingChunks;
        this.retryPolicy = retryPolicy;
    }

    public void createPipeline() throws IOException {
        RaftGroup group = RatisHelper.newRaftGroup((Pipeline)this.pipeline);
        LOG.debug("creating pipeline:{} with {}", (Object)this.pipeline.getId(), (Object)group);
        this.callRatisRpc(this.pipeline.getMachines(), (CheckedBiConsumer<RaftClient, RaftPeer, IOException>)((CheckedBiConsumer)(raftClient, peer) -> raftClient.groupAdd(group, peer.getId())));
    }

    public void destroyPipeline() throws IOException {
        RaftGroup group = RatisHelper.newRaftGroup((Pipeline)this.pipeline);
        LOG.debug("destroying pipeline:{} with {}", (Object)this.pipeline.getId(), (Object)group);
        this.callRatisRpc(this.pipeline.getMachines(), (CheckedBiConsumer<RaftClient, RaftPeer, IOException>)((CheckedBiConsumer)(raftClient, peer) -> raftClient.groupRemove(group.getGroupId(), true, peer.getId())));
    }

    public HddsProtos.ReplicationType getPipelineType() {
        return HddsProtos.ReplicationType.RATIS;
    }

    private void callRatisRpc(List<DatanodeDetails> datanodes, CheckedBiConsumer<RaftClient, RaftPeer, IOException> rpc) throws IOException {
        if (datanodes.isEmpty()) {
            return;
        }
        List exceptions = Collections.synchronizedList(new ArrayList());
        datanodes.parallelStream().forEach(d -> {
            RaftPeer p = RatisHelper.toRaftPeer((DatanodeDetails)d);
            try (RaftClient client = RatisHelper.newRaftClient((RpcType)this.rpcType, (RaftPeer)p, (RetryPolicy)this.retryPolicy);){
                rpc.accept((Object)client, (Object)p);
            }
            catch (IOException ioe) {
                exceptions.add(new IOException("Failed invoke Ratis rpc " + rpc + " for " + d, ioe));
            }
        });
        if (!exceptions.isEmpty()) {
            throw MultipleIOException.createIOException(exceptions);
        }
    }

    public Pipeline getPipeline() {
        return this.pipeline;
    }

    public void connect() throws Exception {
        LOG.debug("Connecting to pipeline:{} leader:{}", (Object)this.getPipeline().getId(), (Object)RatisHelper.toRaftPeerId((DatanodeDetails)this.pipeline.getLeader()));
        if (!this.client.compareAndSet(null, RatisHelper.newRaftClient((RpcType)this.rpcType, (Pipeline)this.getPipeline(), (RetryPolicy)this.retryPolicy))) {
            throw new IllegalStateException("Client is already connected.");
        }
    }

    public void close() {
        RaftClient c = this.client.getAndSet(null);
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private RaftClient getClient() {
        return Objects.requireNonNull(this.client.get(), "client is null");
    }

    private CompletableFuture<RaftClientReply> sendRequestAsync(ContainerProtos.ContainerCommandRequestProto request) {
        boolean isReadOnlyRequest = HddsUtils.isReadOnly((ContainerProtos.ContainerCommandRequestProto)request);
        ByteString byteString = request.toByteString();
        LOG.debug("sendCommandAsync {} {}", (Object)isReadOnlyRequest, (Object)request);
        return isReadOnlyRequest ? this.getClient().sendReadOnlyAsync(() -> byteString) : this.getClient().sendAsync(() -> byteString);
    }

    public void watchForCommit(long index, long timeout) throws Exception {
        this.getClient().sendWatchAsync(index, RaftProtos.ReplicationLevel.ALL_COMMITTED).get(timeout, TimeUnit.MILLISECONDS);
    }

    public CompletableFuture<ContainerProtos.ContainerCommandResponseProto> sendCommandAsync(ContainerProtos.ContainerCommandRequestProto request) {
        return ((CompletableFuture)this.sendRequestAsync(request).whenComplete((reply, e) -> LOG.debug("received reply {} for request: {} exception: {}", new Object[]{request, reply, e}))).thenApply(reply -> {
            try {
                return ContainerProtos.ContainerCommandResponseProto.parseFrom((ByteString)reply.getMessage().getContent());
            }
            catch (InvalidProtocolBufferException e) {
                throw new CompletionException(e);
            }
        });
    }
}

