/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.XceiverClientGrpc;
import org.apache.hadoop.hdds.scm.XceiverClientMetrics;
import org.apache.hadoop.hdds.scm.XceiverClientRatis;
import org.apache.hadoop.hdds.scm.XceiverClientSpi;
import org.apache.hadoop.hdds.scm.container.common.helpers.Pipeline;

public class XceiverClientManager
implements Closeable {
    private final Configuration conf;
    private final Cache<String, XceiverClientSpi> clientCache;
    private final boolean useRatis;
    private static XceiverClientMetrics metrics;

    public XceiverClientManager(Configuration conf) {
        Preconditions.checkNotNull((Object)conf);
        int maxSize = conf.getInt("scm.container.client.max.size", 256);
        long staleThresholdMs = conf.getTimeDuration("scm.container.client.idle.threshold", "10s", TimeUnit.MILLISECONDS);
        this.useRatis = conf.getBoolean("dfs.container.ratis.enabled", false);
        this.conf = conf;
        this.clientCache = CacheBuilder.newBuilder().expireAfterAccess(staleThresholdMs, TimeUnit.MILLISECONDS).maximumSize((long)maxSize).removalListener((RemovalListener)new RemovalListener<String, XceiverClientSpi>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onRemoval(RemovalNotification<String, XceiverClientSpi> removalNotification) {
                Cache cache = XceiverClientManager.this.clientCache;
                synchronized (cache) {
                    XceiverClientSpi info = (XceiverClientSpi)removalNotification.getValue();
                    info.setEvicted();
                }
            }
        }).build();
    }

    @VisibleForTesting
    public Cache<String, XceiverClientSpi> getClientCache() {
        return this.clientCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XceiverClientSpi acquireClient(Pipeline pipeline) throws IOException {
        Preconditions.checkNotNull((Object)pipeline);
        Preconditions.checkArgument((pipeline.getMachines() != null ? 1 : 0) != 0);
        Preconditions.checkArgument((!pipeline.getMachines().isEmpty() ? 1 : 0) != 0);
        Cache<String, XceiverClientSpi> cache = this.clientCache;
        synchronized (cache) {
            XceiverClientSpi info = this.getClient(pipeline);
            info.incrementReference();
            return info;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseClient(XceiverClientSpi client) {
        Preconditions.checkNotNull((Object)client);
        Cache<String, XceiverClientSpi> cache = this.clientCache;
        synchronized (cache) {
            client.decrementReference();
        }
    }

    private XceiverClientSpi getClient(final Pipeline pipeline) throws IOException {
        final HddsProtos.ReplicationType type = pipeline.getType();
        try {
            return (XceiverClientSpi)this.clientCache.get((Object)(pipeline.getId().getId().toString() + type), (Callable)new Callable<XceiverClientSpi>(){

                @Override
                public XceiverClientSpi call() throws Exception {
                    XceiverClientSpi client = null;
                    switch (type) {
                        case RATIS: {
                            client = XceiverClientRatis.newXceiverClientRatis(pipeline, XceiverClientManager.this.conf);
                            break;
                        }
                        case STAND_ALONE: {
                            client = new XceiverClientGrpc(pipeline, XceiverClientManager.this.conf);
                            break;
                        }
                        default: {
                            throw new IOException("not implemented" + pipeline.getType());
                        }
                    }
                    client.connect();
                    return client;
                }
            });
        }
        catch (Exception e) {
            throw new IOException("Exception getting XceiverClient: " + e.toString(), e);
        }
    }

    @Override
    public void close() {
        this.clientCache.invalidateAll();
        this.clientCache.cleanUp();
        if (metrics != null) {
            metrics.unRegister();
        }
    }

    public boolean isUseRatis() {
        return this.useRatis;
    }

    public HddsProtos.ReplicationFactor getFactor() {
        if (this.isUseRatis()) {
            return HddsProtos.ReplicationFactor.THREE;
        }
        return HddsProtos.ReplicationFactor.ONE;
    }

    public HddsProtos.ReplicationType getType() {
        if (this.isUseRatis()) {
            return HddsProtos.ReplicationType.RATIS;
        }
        return HddsProtos.ReplicationType.STAND_ALONE;
    }

    public static synchronized XceiverClientMetrics getXceiverClientMetrics() {
        if (metrics == null) {
            metrics = XceiverClientMetrics.create();
        }
        return metrics;
    }
}

