/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.datanode.proto.XceiverClientProtocolServiceGrpc;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.XceiverClientManager;
import org.apache.hadoop.hdds.scm.XceiverClientMetrics;
import org.apache.hadoop.hdds.scm.XceiverClientSpi;
import org.apache.hadoop.hdds.scm.client.HddsClientUtils;
import org.apache.hadoop.hdds.scm.container.common.helpers.Pipeline;
import org.apache.hadoop.util.Time;
import org.apache.ratis.thirdparty.io.grpc.Channel;
import org.apache.ratis.thirdparty.io.grpc.ManagedChannel;
import org.apache.ratis.thirdparty.io.grpc.netty.NettyChannelBuilder;
import org.apache.ratis.thirdparty.io.grpc.stub.StreamObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XceiverClientGrpc
extends XceiverClientSpi {
    static final Logger LOG = LoggerFactory.getLogger(XceiverClientGrpc.class);
    private final Pipeline pipeline;
    private final Configuration config;
    private Map<UUID, XceiverClientProtocolServiceGrpc.XceiverClientProtocolServiceStub> asyncStubs;
    private XceiverClientMetrics metrics;
    private Map<UUID, ManagedChannel> channels;
    private final Semaphore semaphore;
    private boolean closed = false;

    public XceiverClientGrpc(Pipeline pipeline, Configuration config) {
        Preconditions.checkNotNull((Object)pipeline);
        Preconditions.checkNotNull((Object)config);
        this.pipeline = pipeline;
        this.config = config;
        this.semaphore = new Semaphore(HddsClientUtils.getMaxOutstandingRequests(config));
        this.metrics = XceiverClientManager.getXceiverClientMetrics();
        this.channels = new HashMap<UUID, ManagedChannel>();
        this.asyncStubs = new HashMap<UUID, XceiverClientProtocolServiceGrpc.XceiverClientProtocolServiceStub>();
    }

    public void connect() throws Exception {
        DatanodeDetails leader = (DatanodeDetails)this.pipeline.getMachines().get(0);
        this.connectToDatanode(leader);
    }

    private void connectToDatanode(DatanodeDetails dn) {
        int port = dn.getPort(DatanodeDetails.Port.Name.STANDALONE).getValue();
        if (port == 0) {
            port = this.config.getInt("dfs.container.ipc", 9859);
        }
        LOG.debug("Connecting to server Port : " + dn.getIpAddress());
        ManagedChannel channel = ((NettyChannelBuilder)NettyChannelBuilder.forAddress((String)dn.getIpAddress(), (int)port).usePlaintext().maxInboundMessageSize(0x2000000)).build();
        XceiverClientProtocolServiceGrpc.XceiverClientProtocolServiceStub asyncStub = XceiverClientProtocolServiceGrpc.newStub((Channel)channel);
        this.asyncStubs.put(dn.getUuid(), asyncStub);
        this.channels.put(dn.getUuid(), channel);
    }

    @VisibleForTesting
    public boolean isConnected(DatanodeDetails details) {
        return this.isConnected(this.channels.get(details.getUuid()));
    }

    private boolean isConnected(ManagedChannel channel) {
        return channel != null && !channel.isTerminated() && !channel.isShutdown();
    }

    public void close() {
        this.closed = true;
        for (ManagedChannel channel : this.channels.values()) {
            channel.shutdownNow();
            try {
                channel.awaitTermination(60L, TimeUnit.MINUTES);
            }
            catch (Exception e) {
                LOG.error("Unexpected exception while waiting for channel termination", (Throwable)e);
            }
        }
    }

    public Pipeline getPipeline() {
        return this.pipeline;
    }

    public ContainerProtos.ContainerCommandResponseProto sendCommand(ContainerProtos.ContainerCommandRequestProto request) throws IOException {
        return this.sendCommandWithRetry(request);
    }

    public ContainerProtos.ContainerCommandResponseProto sendCommandWithRetry(ContainerProtos.ContainerCommandRequestProto request) throws IOException {
        int size = this.pipeline.getMachines().size();
        ContainerProtos.ContainerCommandResponseProto responseProto = null;
        DatanodeDetails dn = null;
        for (int dnIndex = 0; dnIndex < size; ++dnIndex) {
            try {
                dn = (DatanodeDetails)this.pipeline.getMachines().get(dnIndex);
                LOG.debug("Executing command " + request + " on datanode " + dn);
                responseProto = this.sendCommandAsync(request, dn).get();
                if (responseProto.getResult() != ContainerProtos.Result.SUCCESS) continue;
                break;
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.warn("Failed to execute command " + request + " on datanode " + dn.getUuidString(), (Throwable)e);
            }
        }
        if (responseProto != null) {
            return responseProto;
        }
        throw new IOException("Failed to execute command " + request + " on the pipeline " + this.pipeline.getId());
    }

    public CompletableFuture<ContainerProtos.ContainerCommandResponseProto> sendCommandAsync(ContainerProtos.ContainerCommandRequestProto request) throws IOException, ExecutionException, InterruptedException {
        return this.sendCommandAsync(request, (DatanodeDetails)this.pipeline.getMachines().get(0));
    }

    private CompletableFuture<ContainerProtos.ContainerCommandResponseProto> sendCommandAsync(final ContainerProtos.ContainerCommandRequestProto request, DatanodeDetails dn) throws IOException, ExecutionException, InterruptedException {
        if (this.closed) {
            throw new IOException("This channel is not connected.");
        }
        UUID dnId = dn.getUuid();
        ManagedChannel channel = this.channels.get(dnId);
        if (!this.isConnected(channel)) {
            this.reconnect(dn);
        }
        final CompletableFuture<ContainerProtos.ContainerCommandResponseProto> replyFuture = new CompletableFuture<ContainerProtos.ContainerCommandResponseProto>();
        this.semaphore.acquire();
        final long requestTime = Time.monotonicNowNanos();
        this.metrics.incrPendingContainerOpsMetrics(request.getCmdType());
        StreamObserver requestObserver = this.asyncStubs.get(dnId).send((StreamObserver)new StreamObserver<ContainerProtos.ContainerCommandResponseProto>(){

            public void onNext(ContainerProtos.ContainerCommandResponseProto value) {
                replyFuture.complete(value);
                XceiverClientGrpc.this.metrics.decrPendingContainerOpsMetrics(request.getCmdType());
                XceiverClientGrpc.this.metrics.addContainerOpsLatency(request.getCmdType(), Time.monotonicNowNanos() - requestTime);
                XceiverClientGrpc.this.semaphore.release();
            }

            public void onError(Throwable t) {
                replyFuture.completeExceptionally(t);
                XceiverClientGrpc.this.metrics.decrPendingContainerOpsMetrics(request.getCmdType());
                XceiverClientGrpc.this.metrics.addContainerOpsLatency(request.getCmdType(), Time.monotonicNowNanos() - requestTime);
                XceiverClientGrpc.this.semaphore.release();
            }

            public void onCompleted() {
                if (!replyFuture.isDone()) {
                    replyFuture.completeExceptionally(new IOException("Stream completed but no reply for request " + request));
                }
            }
        });
        requestObserver.onNext((Object)request);
        requestObserver.onCompleted();
        return replyFuture;
    }

    private void reconnect(DatanodeDetails dn) throws IOException {
        ManagedChannel channel;
        try {
            this.connectToDatanode(dn);
            channel = this.channels.get(dn.getUuid());
        }
        catch (Exception e) {
            LOG.error("Error while connecting: ", (Throwable)e);
            throw new IOException(e);
        }
        if (channel == null || !this.isConnected(channel)) {
            throw new IOException("This channel is not connected.");
        }
    }

    public void createPipeline() {
    }

    public void destroyPipeline() {
    }

    public HddsProtos.ReplicationType getPipelineType() {
        return HddsProtos.ReplicationType.STAND_ALONE;
    }
}

