/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.userauth;

import java.io.IOException;
import java.util.List;
import javax.ws.rs.core.HttpHeaders;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.ozone.client.rest.OzoneException;
import org.apache.hadoop.ozone.web.exceptions.ErrorTable;
import org.apache.hadoop.ozone.web.handlers.UserArgs;
import org.apache.hadoop.ozone.web.interfaces.UserAuth;
import org.apache.hadoop.security.UserGroupInformation;

@InterfaceAudience.Private
public class Simple
implements UserAuth {
    @Override
    public String getOzoneUser(UserArgs userArgs) throws OzoneException {
        assert (userArgs != null) : "userArgs cannot be null";
        HttpHeaders headers = userArgs.getHeaders();
        List users = headers.getRequestHeader("x-ozone-user");
        if (users == null || users.size() == 0) {
            return null;
        }
        if (users.size() > 1) {
            throw ErrorTable.newError(ErrorTable.BAD_AUTHORIZATION, userArgs);
        }
        return ((String)users.get(0)).toLowerCase().trim();
    }

    @Override
    public String getUser(UserArgs userArgs) throws OzoneException {
        assert (userArgs != null) : "userArgs cannot be null";
        HttpHeaders headers = userArgs.getHeaders();
        List users = headers.getRequestHeader("Authorization");
        if (users == null || users.size() > 1) {
            throw ErrorTable.newError(ErrorTable.BAD_AUTHORIZATION, userArgs);
        }
        if (users.size() == 0) {
            return null;
        }
        String user = ((String)users.get(0)).trim();
        if (user.startsWith("OZONE")) {
            user = user.replace("OZONE", "");
            return user.toLowerCase().trim();
        }
        throw ErrorTable.newError(ErrorTable.BAD_AUTHORIZATION, userArgs);
    }

    @Override
    public boolean isAdmin(UserArgs userArgs) throws OzoneException {
        String currentUser;
        String user;
        assert (userArgs != null) : "userArgs cannot be null";
        try {
            user = this.getUser(userArgs);
            currentUser = UserGroupInformation.getCurrentUser().getShortUserName();
        }
        catch (IOException e) {
            throw ErrorTable.newError(ErrorTable.BAD_AUTHORIZATION, userArgs);
        }
        return user.compareToIgnoreCase("root") == 0 || user.compareToIgnoreCase("hdfs") == 0 || user.compareToIgnoreCase(currentUser) == 0;
    }

    @Override
    public boolean isAnonymous(UserArgs userArgs) throws OzoneException {
        assert (userArgs != null) : "userArgs cannot be null";
        return this.getUser(userArgs) == null;
    }

    @Override
    public boolean isUser(String userName, UserArgs userArgs) throws OzoneException {
        return userName != null;
    }

    @Override
    public String[] getGroups(UserArgs userArgs) throws OzoneException {
        return null;
    }
}

