/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.storage;

import com.google.common.base.Strings;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.client.ReplicationType;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.XceiverClientManager;
import org.apache.hadoop.hdds.scm.client.HddsClientUtils;
import org.apache.hadoop.hdds.scm.protocolPB.StorageContainerLocationProtocolClientSideTranslatorPB;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.OzoneConsts;
import org.apache.hadoop.ozone.client.OzoneClientUtils;
import org.apache.hadoop.ozone.client.io.ChunkGroupInputStream;
import org.apache.hadoop.ozone.client.io.ChunkGroupOutputStream;
import org.apache.hadoop.ozone.client.io.LengthInputStream;
import org.apache.hadoop.ozone.client.io.OzoneOutputStream;
import org.apache.hadoop.ozone.client.rest.OzoneException;
import org.apache.hadoop.ozone.om.OMConfigKeys;
import org.apache.hadoop.ozone.om.helpers.OmBucketArgs;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyArgs;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.helpers.OpenKeySession;
import org.apache.hadoop.ozone.om.protocolPB.OzoneManagerProtocolClientSideTranslatorPB;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocolPB.OMPBHelper;
import org.apache.hadoop.ozone.web.handlers.BucketArgs;
import org.apache.hadoop.ozone.web.handlers.KeyArgs;
import org.apache.hadoop.ozone.web.handlers.ListArgs;
import org.apache.hadoop.ozone.web.handlers.UserArgs;
import org.apache.hadoop.ozone.web.handlers.VolumeArgs;
import org.apache.hadoop.ozone.web.interfaces.StorageHandler;
import org.apache.hadoop.ozone.web.request.OzoneQuota;
import org.apache.hadoop.ozone.web.response.BucketInfo;
import org.apache.hadoop.ozone.web.response.KeyInfo;
import org.apache.hadoop.ozone.web.response.KeyInfoDetails;
import org.apache.hadoop.ozone.web.response.KeyLocation;
import org.apache.hadoop.ozone.web.response.ListBuckets;
import org.apache.hadoop.ozone.web.response.ListKeys;
import org.apache.hadoop.ozone.web.response.ListVolumes;
import org.apache.hadoop.ozone.web.response.VolumeInfo;
import org.apache.hadoop.ozone.web.response.VolumeOwner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DistributedStorageHandler
implements StorageHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DistributedStorageHandler.class);
    private final StorageContainerLocationProtocolClientSideTranslatorPB storageContainerLocationClient;
    private final OzoneManagerProtocolClientSideTranslatorPB ozoneManagerClient;
    private final XceiverClientManager xceiverClientManager;
    private final OzoneAcl.OzoneACLRights userRights;
    private final OzoneAcl.OzoneACLRights groupRights;
    private int chunkSize;
    private final boolean useRatis;
    private final HddsProtos.ReplicationType type;
    private final HddsProtos.ReplicationFactor factor;
    private final RetryPolicy retryPolicy;

    public DistributedStorageHandler(OzoneConfiguration conf, StorageContainerLocationProtocolClientSideTranslatorPB storageContainerLocation, OzoneManagerProtocolClientSideTranslatorPB ozoneManagerClient) {
        this.ozoneManagerClient = ozoneManagerClient;
        this.storageContainerLocationClient = storageContainerLocation;
        this.xceiverClientManager = new XceiverClientManager((Configuration)conf);
        this.useRatis = conf.getBoolean("dfs.container.ratis.enabled", false);
        if (this.useRatis) {
            this.type = HddsProtos.ReplicationType.RATIS;
            this.factor = HddsProtos.ReplicationFactor.THREE;
        } else {
            this.type = HddsProtos.ReplicationType.STAND_ALONE;
            this.factor = HddsProtos.ReplicationFactor.ONE;
        }
        this.chunkSize = conf.getInt("ozone.scm.chunk.size", 0x1000000);
        this.userRights = (OzoneAcl.OzoneACLRights)conf.getEnum("ozone.om.user.rights", (Enum)OMConfigKeys.OZONE_OM_USER_RIGHTS_DEFAULT);
        this.groupRights = (OzoneAcl.OzoneACLRights)conf.getEnum("ozone.om.group.rights", (Enum)OMConfigKeys.OZONE_OM_GROUP_RIGHTS_DEFAULT);
        this.retryPolicy = OzoneClientUtils.createRetryPolicy((Configuration)conf);
        if (this.chunkSize > 0x2000000) {
            LOG.warn("The chunk size ({}) is not allowed to be more than the maximum size ({}), resetting to the maximum size.", (Object)this.chunkSize, (Object)0x2000000);
            this.chunkSize = 0x2000000;
        }
    }

    @Override
    public void createVolume(VolumeArgs args) throws IOException, OzoneException {
        long quota = args.getQuota() == null ? 0x1000000000000000L : args.getQuota().sizeInBytes();
        OzoneAcl userAcl = new OzoneAcl(OzoneAcl.OzoneACLType.USER, args.getUserName(), this.userRights);
        OmVolumeArgs.Builder builder = OmVolumeArgs.newBuilder();
        builder.setAdminName(args.getAdminName()).setOwnerName(args.getUserName()).setVolume(args.getVolumeName()).setQuotaInBytes(quota).addOzoneAcls(OMPBHelper.convertOzoneAcl((OzoneAcl)userAcl));
        if (args.getGroups() != null) {
            for (String group : args.getGroups()) {
                OzoneAcl groupAcl = new OzoneAcl(OzoneAcl.OzoneACLType.GROUP, group, this.groupRights);
                builder.addOzoneAcls(OMPBHelper.convertOzoneAcl((OzoneAcl)groupAcl));
            }
        }
        this.ozoneManagerClient.createVolume(builder.build());
    }

    @Override
    public void setVolumeOwner(VolumeArgs args) throws IOException, OzoneException {
        this.ozoneManagerClient.setOwner(args.getVolumeName(), args.getUserName());
    }

    @Override
    public void setVolumeQuota(VolumeArgs args, boolean remove) throws IOException, OzoneException {
        long quota = remove ? 0x1000000000000000L : args.getQuota().sizeInBytes();
        this.ozoneManagerClient.setQuota(args.getVolumeName(), quota);
    }

    @Override
    public boolean checkVolumeAccess(String volume, OzoneAcl acl) throws IOException, OzoneException {
        return this.ozoneManagerClient.checkVolumeAccess(volume, OMPBHelper.convertOzoneAcl((OzoneAcl)acl));
    }

    @Override
    public ListVolumes listVolumes(ListArgs args) throws IOException, OzoneException {
        List listResult;
        int maxNumOfKeys = args.getMaxKeys();
        if (maxNumOfKeys <= 0 || maxNumOfKeys > 1024) {
            throw new IllegalArgumentException(String.format("Illegal max number of keys specified, the value must be in range (0, %d], actual : %d.", 1024, maxNumOfKeys));
        }
        if (args.isRootScan()) {
            listResult = this.ozoneManagerClient.listAllVolumes(args.getPrefix(), args.getPrevKey(), args.getMaxKeys());
        } else {
            UserArgs userArgs = args.getArgs();
            if (userArgs == null || userArgs.getUserName() == null) {
                throw new IllegalArgumentException("Illegal argument, missing user argument.");
            }
            listResult = this.ozoneManagerClient.listVolumeByUser(args.getArgs().getUserName(), args.getPrefix(), args.getPrevKey(), args.getMaxKeys());
        }
        ListVolumes result = new ListVolumes();
        for (OmVolumeArgs volumeArgs : listResult) {
            VolumeInfo info = new VolumeInfo();
            OzoneManagerProtocolProtos.VolumeInfo infoProto = volumeArgs.getProtobuf();
            info.setOwner(new VolumeOwner(infoProto.getOwnerName()));
            info.setQuota(OzoneQuota.getOzoneQuota((long)infoProto.getQuotaInBytes()));
            info.setVolumeName(infoProto.getVolume());
            info.setCreatedOn(HddsClientUtils.formatDateTime((long)infoProto.getCreationTime()));
            result.addVolume(info);
        }
        return result;
    }

    @Override
    public void deleteVolume(VolumeArgs args) throws IOException, OzoneException {
        this.ozoneManagerClient.deleteVolume(args.getVolumeName());
    }

    @Override
    public VolumeInfo getVolumeInfo(VolumeArgs args) throws IOException, OzoneException {
        OmVolumeArgs volumeArgs = this.ozoneManagerClient.getVolumeInfo(args.getVolumeName());
        VolumeInfo volInfo = new VolumeInfo(volumeArgs.getVolume(), null, volumeArgs.getAdminName());
        volInfo.setOwner(new VolumeOwner(volumeArgs.getOwnerName()));
        volInfo.setQuota(OzoneQuota.getOzoneQuota((long)volumeArgs.getQuotaInBytes()));
        volInfo.setCreatedOn(HddsClientUtils.formatDateTime((long)volumeArgs.getCreationTime()));
        return volInfo;
    }

    @Override
    public void createBucket(BucketArgs args) throws IOException, OzoneException {
        OmBucketInfo.Builder builder = OmBucketInfo.newBuilder();
        builder.setVolumeName(args.getVolumeName()).setBucketName(args.getBucketName());
        if (args.getAddAcls() != null) {
            builder.setAcls(args.getAddAcls());
        }
        if (args.getStorageType() != null) {
            builder.setStorageType(args.getStorageType());
        }
        if (args.getVersioning() != null) {
            builder.setIsVersionEnabled(Boolean.valueOf(this.getBucketVersioningProtobuf(args.getVersioning())));
        }
        this.ozoneManagerClient.createBucket(builder.build());
    }

    private boolean getBucketVersioningProtobuf(OzoneConsts.Versioning version) {
        if (version != null) {
            switch (version) {
                case ENABLED: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public void setBucketAcls(BucketArgs args) throws IOException, OzoneException {
        List removeAcls = args.getRemoveAcls();
        List addAcls = args.getAddAcls();
        if (removeAcls != null || addAcls != null) {
            OmBucketArgs.Builder builder = OmBucketArgs.newBuilder();
            builder.setVolumeName(args.getVolumeName()).setBucketName(args.getBucketName());
            if (removeAcls != null && !removeAcls.isEmpty()) {
                builder.setRemoveAcls(args.getRemoveAcls());
            }
            if (addAcls != null && !addAcls.isEmpty()) {
                builder.setAddAcls(args.getAddAcls());
            }
            this.ozoneManagerClient.setBucketProperty(builder.build());
        }
    }

    @Override
    public void setBucketVersioning(BucketArgs args) throws IOException, OzoneException {
        OmBucketArgs.Builder builder = OmBucketArgs.newBuilder();
        builder.setVolumeName(args.getVolumeName()).setBucketName(args.getBucketName()).setIsVersionEnabled(Boolean.valueOf(this.getBucketVersioningProtobuf(args.getVersioning())));
        this.ozoneManagerClient.setBucketProperty(builder.build());
    }

    @Override
    public void setBucketStorageClass(BucketArgs args) throws IOException, OzoneException {
        OmBucketArgs.Builder builder = OmBucketArgs.newBuilder();
        builder.setVolumeName(args.getVolumeName()).setBucketName(args.getBucketName()).setStorageType(args.getStorageType());
        this.ozoneManagerClient.setBucketProperty(builder.build());
    }

    @Override
    public void deleteBucket(BucketArgs args) throws IOException, OzoneException {
        this.ozoneManagerClient.deleteBucket(args.getVolumeName(), args.getBucketName());
    }

    @Override
    public void checkBucketAccess(BucketArgs args) throws IOException, OzoneException {
        throw new UnsupportedOperationException("checkBucketAccess not implemented");
    }

    @Override
    public ListBuckets listBuckets(ListArgs args) throws IOException, OzoneException {
        ListBuckets result = new ListBuckets();
        UserArgs userArgs = args.getArgs();
        if (userArgs instanceof VolumeArgs) {
            VolumeArgs va = (VolumeArgs)userArgs;
            if (Strings.isNullOrEmpty((String)va.getVolumeName())) {
                throw new IllegalArgumentException("Illegal argument, volume name cannot be null or empty.");
            }
            int maxNumOfKeys = args.getMaxKeys();
            if (maxNumOfKeys <= 0 || maxNumOfKeys > 1024) {
                throw new IllegalArgumentException(String.format("Illegal max number of keys specified, the value must be in range (0, %d], actual : %d.", 1024, maxNumOfKeys));
            }
            List buckets = this.ozoneManagerClient.listBuckets(va.getVolumeName(), args.getPrevKey(), args.getPrefix(), args.getMaxKeys());
            for (OmBucketInfo bucketInfo : buckets) {
                BucketInfo bk = new BucketInfo();
                bk.setVolumeName(bucketInfo.getVolumeName());
                bk.setBucketName(bucketInfo.getBucketName());
                bk.setStorageType(bucketInfo.getStorageType());
                bk.setAcls(bucketInfo.getAcls());
                bk.setCreatedOn(HddsClientUtils.formatDateTime((long)bucketInfo.getCreationTime()));
                result.addBucket(bk);
            }
            return result;
        }
        throw new IllegalArgumentException("Illegal argument provided, expecting VolumeArgs type but met " + userArgs.getClass().getSimpleName());
    }

    @Override
    public BucketInfo getBucketInfo(BucketArgs args) throws IOException {
        String volumeName = args.getVolumeName();
        String bucketName = args.getBucketName();
        OmBucketInfo omBucketInfo = this.ozoneManagerClient.getBucketInfo(volumeName, bucketName);
        BucketInfo bucketInfo = new BucketInfo(omBucketInfo.getVolumeName(), omBucketInfo.getBucketName());
        if (omBucketInfo.getIsVersionEnabled()) {
            bucketInfo.setVersioning(OzoneConsts.Versioning.ENABLED);
        } else {
            bucketInfo.setVersioning(OzoneConsts.Versioning.DISABLED);
        }
        bucketInfo.setStorageType(omBucketInfo.getStorageType());
        bucketInfo.setAcls(omBucketInfo.getAcls());
        bucketInfo.setCreatedOn(HddsClientUtils.formatDateTime((long)omBucketInfo.getCreationTime()));
        return bucketInfo;
    }

    @Override
    public OutputStream newKeyWriter(KeyArgs args) throws IOException, OzoneException {
        OmKeyArgs keyArgs = new OmKeyArgs.Builder().setVolumeName(args.getVolumeName()).setBucketName(args.getBucketName()).setKeyName(args.getKeyName()).setDataSize(args.getSize()).setType(this.xceiverClientManager.getType()).setFactor(this.xceiverClientManager.getFactor()).build();
        OpenKeySession openKey = this.ozoneManagerClient.openKey(keyArgs);
        ChunkGroupOutputStream groupOutputStream = new ChunkGroupOutputStream.Builder().setHandler(openKey).setXceiverClientManager(this.xceiverClientManager).setScmClient(this.storageContainerLocationClient).setOmClient(this.ozoneManagerClient).setChunkSize(this.chunkSize).setRequestID(args.getRequestID()).setType(this.xceiverClientManager.getType()).setFactor(this.xceiverClientManager.getFactor()).setRetryPolicy(this.retryPolicy).build();
        groupOutputStream.addPreallocateBlocks(openKey.getKeyInfo().getLatestVersionLocations(), openKey.getOpenVersion());
        return new OzoneOutputStream((OutputStream)groupOutputStream);
    }

    @Override
    public void commitKey(KeyArgs args, OutputStream stream) throws IOException, OzoneException {
        stream.close();
    }

    @Override
    public LengthInputStream newKeyReader(KeyArgs args) throws IOException, OzoneException {
        OmKeyArgs keyArgs = new OmKeyArgs.Builder().setVolumeName(args.getVolumeName()).setBucketName(args.getBucketName()).setKeyName(args.getKeyName()).setDataSize(args.getSize()).build();
        OmKeyInfo keyInfo = this.ozoneManagerClient.lookupKey(keyArgs);
        return ChunkGroupInputStream.getFromOmKeyInfo((OmKeyInfo)keyInfo, (XceiverClientManager)this.xceiverClientManager, (StorageContainerLocationProtocolClientSideTranslatorPB)this.storageContainerLocationClient, (String)args.getRequestID());
    }

    @Override
    public void deleteKey(KeyArgs args) throws IOException, OzoneException {
        OmKeyArgs keyArgs = new OmKeyArgs.Builder().setVolumeName(args.getVolumeName()).setBucketName(args.getBucketName()).setKeyName(args.getKeyName()).build();
        this.ozoneManagerClient.deleteKey(keyArgs);
    }

    @Override
    public void renameKey(KeyArgs args, String toKeyName) throws IOException, OzoneException {
        OmKeyArgs keyArgs = new OmKeyArgs.Builder().setVolumeName(args.getVolumeName()).setBucketName(args.getBucketName()).setKeyName(args.getKeyName()).build();
        this.ozoneManagerClient.renameKey(keyArgs, toKeyName);
    }

    @Override
    public KeyInfo getKeyInfo(KeyArgs args) throws IOException, OzoneException {
        OmKeyArgs keyArgs = new OmKeyArgs.Builder().setVolumeName(args.getVolumeName()).setBucketName(args.getBucketName()).setKeyName(args.getKeyName()).build();
        OmKeyInfo omKeyInfo = this.ozoneManagerClient.lookupKey(keyArgs);
        KeyInfo keyInfo = new KeyInfo();
        keyInfo.setVersion(0L);
        keyInfo.setKeyName(omKeyInfo.getKeyName());
        keyInfo.setSize(omKeyInfo.getDataSize());
        keyInfo.setCreatedOn(HddsClientUtils.formatDateTime((long)omKeyInfo.getCreationTime()));
        keyInfo.setModifiedOn(HddsClientUtils.formatDateTime((long)omKeyInfo.getModificationTime()));
        keyInfo.setType(ReplicationType.valueOf((String)omKeyInfo.getType().toString()));
        return keyInfo;
    }

    @Override
    public KeyInfo getKeyInfoDetails(KeyArgs args) throws IOException {
        OmKeyArgs keyArgs = new OmKeyArgs.Builder().setVolumeName(args.getVolumeName()).setBucketName(args.getBucketName()).setKeyName(args.getKeyName()).build();
        OmKeyInfo omKeyInfo = this.ozoneManagerClient.lookupKey(keyArgs);
        ArrayList keyLocations = new ArrayList();
        omKeyInfo.getLatestVersionLocations().getBlocksLatestVersionOnly().forEach(a -> keyLocations.add(new KeyLocation(a.getContainerID(), a.getLocalID(), a.getLength(), a.getOffset())));
        KeyInfoDetails keyInfoDetails = new KeyInfoDetails();
        keyInfoDetails.setVersion(0L);
        keyInfoDetails.setKeyName(omKeyInfo.getKeyName());
        keyInfoDetails.setSize(omKeyInfo.getDataSize());
        keyInfoDetails.setCreatedOn(HddsClientUtils.formatDateTime((long)omKeyInfo.getCreationTime()));
        keyInfoDetails.setModifiedOn(HddsClientUtils.formatDateTime((long)omKeyInfo.getModificationTime()));
        keyInfoDetails.setKeyLocations(keyLocations);
        keyInfoDetails.setType(ReplicationType.valueOf((String)omKeyInfo.getType().toString()));
        return keyInfoDetails;
    }

    @Override
    public ListKeys listKeys(ListArgs args) throws IOException, OzoneException {
        ListKeys result = new ListKeys();
        UserArgs userArgs = args.getArgs();
        if (userArgs instanceof BucketArgs) {
            BucketArgs bucketArgs = (BucketArgs)userArgs;
            if (Strings.isNullOrEmpty((String)bucketArgs.getVolumeName())) {
                throw new IllegalArgumentException("Illegal argument, volume name cannot be null or empty.");
            }
            if (Strings.isNullOrEmpty((String)bucketArgs.getBucketName())) {
                throw new IllegalArgumentException("Illegal argument, bucket name cannot be null or empty.");
            }
            int maxNumOfKeys = args.getMaxKeys();
            if (maxNumOfKeys <= 0 || maxNumOfKeys > 1024) {
                throw new IllegalArgumentException(String.format("Illegal max number of keys specified, the value must be in range (0, %d], actual : %d.", 1024, maxNumOfKeys));
            }
            List keys = this.ozoneManagerClient.listKeys(bucketArgs.getVolumeName(), bucketArgs.getBucketName(), args.getPrevKey(), args.getPrefix(), args.getMaxKeys());
            for (OmKeyInfo info : keys) {
                KeyInfo tempInfo = new KeyInfo();
                tempInfo.setVersion(0L);
                tempInfo.setKeyName(info.getKeyName());
                tempInfo.setSize(info.getDataSize());
                tempInfo.setCreatedOn(HddsClientUtils.formatDateTime((long)info.getCreationTime()));
                tempInfo.setModifiedOn(HddsClientUtils.formatDateTime((long)info.getModificationTime()));
                tempInfo.setType(ReplicationType.valueOf((String)info.getType().toString()));
                result.addKey(tempInfo);
            }
            return result;
        }
        throw new IllegalArgumentException("Illegal argument provided, expecting BucketArgs type but met " + userArgs.getClass().getSimpleName());
    }

    @Override
    public void close() {
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.xceiverClientManager});
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.ozoneManagerClient});
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.storageContainerLocationClient});
    }
}

