/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.netty;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.io.Closeable;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.concurrent.Future;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ozone.web.netty.ObjectStoreChannelHandler;
import org.apache.hadoop.ozone.web.netty.ObjectStoreJerseyContainer;
import org.apache.hadoop.ozone.web.netty.RequestContentObjectStoreChannelHandler;

public final class RequestDispatchObjectStoreChannelHandler
extends ObjectStoreChannelHandler<HttpRequest> {
    private final ObjectStoreJerseyContainer jerseyContainer;
    private PipedInputStream reqIn;
    private PipedOutputStream reqOut;
    private PipedInputStream respIn;
    private PipedOutputStream respOut;

    public RequestDispatchObjectStoreChannelHandler(ObjectStoreJerseyContainer jerseyContainer) {
        this.jerseyContainer = jerseyContainer;
    }

    public void channelRead0(ChannelHandlerContext ctx, HttpRequest nettyReq) throws Exception {
        LOG.trace("begin RequestDispatchObjectStoreChannelHandler channelRead0, ctx = {}, nettyReq = {}", (Object)ctx, (Object)nettyReq);
        if (!nettyReq.getDecoderResult().isSuccess()) {
            RequestDispatchObjectStoreChannelHandler.sendErrorResponse(ctx, HttpResponseStatus.BAD_REQUEST);
            return;
        }
        this.reqIn = new PipedInputStream();
        this.reqOut = new PipedOutputStream(this.reqIn);
        this.respIn = new PipedInputStream();
        this.respOut = new PipedOutputStream(this.respIn);
        if (HttpHeaders.is100ContinueExpected((HttpMessage)nettyReq)) {
            LOG.trace("Sending continue response.");
            ctx.writeAndFlush((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
        }
        Future<HttpResponse> nettyResp = this.jerseyContainer.dispatch(nettyReq, this.reqIn, this.respOut);
        ctx.pipeline().replace((ChannelHandler)this, RequestContentObjectStoreChannelHandler.class.getSimpleName(), (ChannelHandler)new RequestContentObjectStoreChannelHandler(nettyReq, nettyResp, this.reqOut, this.respIn, this.jerseyContainer));
        LOG.trace("end RequestDispatchObjectStoreChannelHandler channelRead0, ctx = {}, nettyReq = {}", (Object)ctx, (Object)nettyReq);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        super.exceptionCaught(ctx, cause);
        IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{this.reqIn, this.reqOut, this.respIn, this.respOut});
    }
}

