/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.netty;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.stream.ChunkedStream;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Future;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ozone.web.netty.CloseableCleanupListener;
import org.apache.hadoop.ozone.web.netty.ObjectStoreChannelHandler;
import org.apache.hadoop.ozone.web.netty.ObjectStoreJerseyContainer;
import org.apache.hadoop.ozone.web.netty.RequestDispatchObjectStoreChannelHandler;

public final class RequestContentObjectStoreChannelHandler
extends ObjectStoreChannelHandler<HttpContent> {
    private final HttpRequest nettyReq;
    private final Future<HttpResponse> nettyResp;
    private final OutputStream reqOut;
    private final InputStream respIn;
    private ObjectStoreJerseyContainer jerseyContainer;

    public RequestContentObjectStoreChannelHandler(HttpRequest nettyReq, Future<HttpResponse> nettyResp, OutputStream reqOut, InputStream respIn, ObjectStoreJerseyContainer jerseyContainer) {
        this.nettyReq = nettyReq;
        this.nettyResp = nettyResp;
        this.reqOut = reqOut;
        this.respIn = respIn;
        this.jerseyContainer = jerseyContainer;
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    public void channelRead0(final ChannelHandlerContext ctx, HttpContent content) throws Exception {
        LOG.trace("begin RequestContentObjectStoreChannelHandler channelRead0, ctx = {}, content = {}", (Object)ctx, (Object)content);
        content.content().readBytes(this.reqOut, content.content().readableBytes());
        if (content instanceof LastHttpContent) {
            IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{this.reqOut});
            ctx.write((Object)this.nettyResp.get());
            ChannelFuture respFuture = ctx.writeAndFlush((Object)new ChunkedStream(this.respIn));
            respFuture.addListener((GenericFutureListener)new CloseableCleanupListener(this.respIn));
            if (!HttpHeaders.isKeepAlive((HttpMessage)this.nettyReq)) {
                respFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            } else {
                respFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
                        RequestDispatchObjectStoreChannelHandler h = new RequestDispatchObjectStoreChannelHandler(RequestContentObjectStoreChannelHandler.this.jerseyContainer);
                        ctx.pipeline().replace(ctx.pipeline().last(), RequestDispatchObjectStoreChannelHandler.class.getSimpleName(), (ChannelHandler)h);
                    }
                });
            }
        }
        LOG.trace("end RequestContentObjectStoreChannelHandler channelRead0, ctx = {}, content = {}", (Object)ctx, (Object)content);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        super.exceptionCaught(ctx, cause);
        IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{this.reqOut, this.respIn});
    }
}

