/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.stream.ChunkedWriteHandler;
import java.io.Closeable;
import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.datanode.ObjectStoreHandler;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.ozone.web.netty.ObjectStoreURLDispatcher;

public class ObjectStoreRestHttpServer
implements Closeable {
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;
    private final ServerSocketChannel externalHttpChannel;
    private final ServerBootstrap httpServer;
    private final Configuration conf;
    private final Configuration confForCreate;
    private InetSocketAddress httpAddress;
    static final Log LOG = LogFactory.getLog(ObjectStoreRestHttpServer.class);
    private final ObjectStoreHandler objectStoreHandler;

    public ObjectStoreRestHttpServer(Configuration conf, ServerSocketChannel externalHttpChannel, final ObjectStoreHandler objectStoreHandler) throws IOException {
        this.conf = conf;
        this.confForCreate = new Configuration(conf);
        this.objectStoreHandler = objectStoreHandler;
        this.confForCreate.set("fs.permissions.umask-mode", "000");
        this.bossGroup = new NioEventLoopGroup();
        this.workerGroup = new NioEventLoopGroup();
        this.externalHttpChannel = externalHttpChannel;
        this.httpServer = new ServerBootstrap();
        this.httpServer.group(this.bossGroup, this.workerGroup);
        this.httpServer.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                p.addLast(new ChannelHandler[]{new HttpRequestDecoder(), new HttpResponseEncoder()});
                p.addLast(new ChannelHandler[]{new ChunkedWriteHandler(), new ObjectStoreURLDispatcher(objectStoreHandler.getObjectStoreJerseyContainer())});
            }
        });
        this.httpServer.childOption(ChannelOption.WRITE_BUFFER_HIGH_WATER_MARK, (Object)conf.getInt("hdds.rest.netty.high.watermark", 65536));
        this.httpServer.childOption(ChannelOption.WRITE_BUFFER_LOW_WATER_MARK, (Object)conf.getInt("hdds.rest.netty.low.watermark", 32768));
        if (externalHttpChannel == null) {
            this.httpServer.channel(NioServerSocketChannel.class);
        } else {
            this.httpServer.channelFactory(() -> new NioServerSocketChannel(externalHttpChannel){

                protected void doBind(SocketAddress localAddress) throws Exception {
                }
            });
        }
    }

    public InetSocketAddress getHttpAddress() {
        return this.httpAddress;
    }

    public void start() throws IOException {
        if (this.httpServer != null) {
            InetSocketAddress infoAddr = NetUtils.createSocketAddr((String)this.conf.getTrimmed("hdds.rest.http-address", "0.0.0.0:9880"));
            ChannelFuture f = this.httpServer.bind((SocketAddress)infoAddr);
            try {
                f.syncUninterruptibly();
            }
            catch (Throwable e) {
                if (e instanceof BindException) {
                    throw NetUtils.wrapException(null, (int)0, (String)infoAddr.getHostName(), (int)infoAddr.getPort(), (IOException)((SocketException)e));
                }
                throw e;
            }
            this.httpAddress = (InetSocketAddress)f.channel().localAddress();
            LOG.info((Object)("Listening HDDS REST traffic on " + this.httpAddress));
        }
    }

    @Override
    public void close() throws IOException {
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
        if (this.externalHttpChannel != null) {
            this.externalHttpChannel.close();
        }
    }

    private static final class MapBasedFilterConfig
    implements FilterConfig {
        private final String filterName;
        private final Map<String, String> parameters;

        MapBasedFilterConfig(String filterName, Map<String, String> parameters) {
            this.filterName = filterName;
            this.parameters = parameters;
        }

        public String getFilterName() {
            return this.filterName;
        }

        public String getInitParameter(String name) {
            return this.parameters.get(name);
        }

        public Enumeration<String> getInitParameterNames() {
            throw this.notImplemented();
        }

        public ServletContext getServletContext() {
            throw this.notImplemented();
        }

        private UnsupportedOperationException notImplemented() {
            return new UnsupportedOperationException(this.getClass().getSimpleName() + " does not implement this method.");
        }
    }
}

