/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.interfaces;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.ozone.client.rest.OzoneException;

@InterfaceAudience.Private
@Path(value="/{volume}")
@Api(tags={"volume"})
public interface Volume {
    @POST
    @ApiOperation(value="Creates a Volume owned by the user")
    @ApiImplicitParams(value={@ApiImplicitParam(name="x-ozone-version", example="v1", required=true, paramType="header"), @ApiImplicitParam(name="x-ozone-user", example="user", required=true, paramType="header"), @ApiImplicitParam(name="Date", example="Date: Mon, 26 Jun 2017 04:23:30 GMT", required=true, paramType="header"), @ApiImplicitParam(name="Authorization", example="OZONE", required=true, paramType="header")})
    public Response createVolume(@PathParam(value="volume") String var1, @DefaultValue(value="undefined") @QueryParam(value="quota") String var2, @Context Request var3, @Context UriInfo var4, @Context HttpHeaders var5) throws OzoneException;

    @PUT
    @ApiOperation(value="Updates a Volume owned by the user")
    @ApiImplicitParams(value={@ApiImplicitParam(name="x-ozone-version", example="v1", required=true, paramType="header"), @ApiImplicitParam(name="x-ozone-user", example="user", required=true, paramType="header"), @ApiImplicitParam(name="Date", example="Date: Mon, 26 Jun 2017 04:23:30 GMT", required=true, paramType="header"), @ApiImplicitParam(name="Authorization", example="OZONE", required=true, paramType="header")})
    public Response updateVolume(@PathParam(value="volume") String var1, @DefaultValue(value="undefined") @QueryParam(value="quota") String var2, @Context Request var3, @Context UriInfo var4, @Context HttpHeaders var5) throws OzoneException;

    @DELETE
    @ApiOperation(value="Deletes a Volume if it is empty")
    @ApiImplicitParams(value={@ApiImplicitParam(name="x-ozone-version", example="v1", required=true, paramType="header"), @ApiImplicitParam(name="x-ozone-user", example="user", required=true, paramType="header"), @ApiImplicitParam(name="Date", example="Date: Mon, 26 Jun 2017 04:23:30 GMT", required=true, paramType="header"), @ApiImplicitParam(name="Authorization", example="OZONE", required=true, paramType="header")})
    public Response deleteVolume(@PathParam(value="volume") String var1, @Context Request var2, @Context UriInfo var3, @Context HttpHeaders var4) throws OzoneException;

    @GET
    @ApiOperation(value="Returns Volume info", notes="This API can be invoked either by admin or the owner")
    @ApiImplicitParams(value={@ApiImplicitParam(name="x-ozone-version", example="v1", required=true, paramType="header"), @ApiImplicitParam(name="x-ozone-user", example="user", required=true, paramType="header"), @ApiImplicitParam(name="Date", example="Date: Mon, 26 Jun 2017 04:23:30 GMT", required=true, paramType="header"), @ApiImplicitParam(name="Authorization", example="OZONE", required=true, paramType="header")})
    public Response getVolumeInfo(@PathParam(value="volume") String var1, @DefaultValue(value="bucket") @QueryParam(value="info") String var2, @QueryParam(value="prefix") String var3, @DefaultValue(value="1000") @QueryParam(value="max-keys") int var4, @QueryParam(value="prev-key") String var5, @QueryParam(value="root-scan") boolean var6, @Context Request var7, @Context UriInfo var8, @Context HttpHeaders var9) throws OzoneException;
}

