/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.interfaces;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.client.io.LengthInputStream;
import org.apache.hadoop.ozone.client.rest.OzoneException;
import org.apache.hadoop.ozone.web.handlers.BucketArgs;
import org.apache.hadoop.ozone.web.handlers.KeyArgs;
import org.apache.hadoop.ozone.web.handlers.ListArgs;
import org.apache.hadoop.ozone.web.handlers.VolumeArgs;
import org.apache.hadoop.ozone.web.response.BucketInfo;
import org.apache.hadoop.ozone.web.response.KeyInfo;
import org.apache.hadoop.ozone.web.response.ListBuckets;
import org.apache.hadoop.ozone.web.response.ListKeys;
import org.apache.hadoop.ozone.web.response.ListVolumes;
import org.apache.hadoop.ozone.web.response.VolumeInfo;

@InterfaceAudience.Private
public interface StorageHandler
extends Closeable {
    public void createVolume(VolumeArgs var1) throws IOException, OzoneException;

    public void setVolumeOwner(VolumeArgs var1) throws IOException, OzoneException;

    public void setVolumeQuota(VolumeArgs var1, boolean var2) throws IOException, OzoneException;

    public boolean checkVolumeAccess(String var1, OzoneAcl var2) throws IOException, OzoneException;

    public ListVolumes listVolumes(ListArgs var1) throws IOException, OzoneException;

    public void deleteVolume(VolumeArgs var1) throws IOException, OzoneException;

    public VolumeInfo getVolumeInfo(VolumeArgs var1) throws IOException, OzoneException;

    public void createBucket(BucketArgs var1) throws IOException, OzoneException;

    public void setBucketAcls(BucketArgs var1) throws IOException, OzoneException;

    public void setBucketVersioning(BucketArgs var1) throws IOException, OzoneException;

    public void setBucketStorageClass(BucketArgs var1) throws IOException, OzoneException;

    public void deleteBucket(BucketArgs var1) throws IOException, OzoneException;

    public void checkBucketAccess(BucketArgs var1) throws IOException, OzoneException;

    public ListBuckets listBuckets(ListArgs var1) throws IOException, OzoneException;

    public BucketInfo getBucketInfo(BucketArgs var1) throws IOException, OzoneException;

    public OutputStream newKeyWriter(KeyArgs var1) throws IOException, OzoneException;

    public void commitKey(KeyArgs var1, OutputStream var2) throws IOException, OzoneException;

    public LengthInputStream newKeyReader(KeyArgs var1) throws IOException, OzoneException;

    public void deleteKey(KeyArgs var1) throws IOException, OzoneException;

    public void renameKey(KeyArgs var1, String var2) throws IOException, OzoneException;

    public ListKeys listKeys(ListArgs var1) throws IOException, OzoneException;

    public KeyInfo getKeyInfo(KeyArgs var1) throws IOException, OzoneException;

    public KeyInfo getKeyInfoDetails(KeyArgs var1) throws IOException, OzoneException;

    @Override
    public void close();
}

