/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.handlers;

import java.io.IOException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.NoSuchFileException;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.ozone.OzoneRestUtils;
import org.apache.hadoop.ozone.client.rest.OzoneException;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.web.exceptions.ErrorTable;
import org.apache.hadoop.ozone.web.handlers.ListArgs;
import org.apache.hadoop.ozone.web.handlers.StorageHandlerBuilder;
import org.apache.hadoop.ozone.web.handlers.UserArgs;
import org.apache.hadoop.ozone.web.handlers.UserHandlerBuilder;
import org.apache.hadoop.ozone.web.handlers.VolumeArgs;
import org.apache.hadoop.ozone.web.interfaces.StorageHandler;
import org.apache.hadoop.ozone.web.interfaces.UserAuth;
import org.apache.hadoop.ozone.web.response.ListBuckets;
import org.apache.hadoop.ozone.web.response.ListVolumes;
import org.apache.hadoop.ozone.web.response.VolumeInfo;
import org.apache.hadoop.ozone.web.utils.OzoneUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

@InterfaceAudience.Private
public abstract class VolumeProcessTemplate {
    private static final Logger LOG = LoggerFactory.getLogger(VolumeProcessTemplate.class);

    public Response handleCall(String volume, Request request, UriInfo info, HttpHeaders headers) throws OzoneException {
        String reqID = OzoneUtils.getRequestID();
        String hostName = OzoneUtils.getHostName();
        MDC.put((String)"component", (String)"ozone");
        MDC.put((String)"request", (String)reqID);
        UserArgs userArgs = null;
        try {
            userArgs = new UserArgs(reqID, hostName, request, info, headers);
            OzoneRestUtils.validate(request, headers, reqID, volume, hostName);
            OzoneUtils.verifyResourceName((String)volume);
            UserAuth auth = UserHandlerBuilder.getAuthHandler();
            userArgs.setUserName(auth.getUser(userArgs));
            MDC.put((String)"user", (String)userArgs.getUserName());
            VolumeArgs args = new VolumeArgs(volume, userArgs);
            MDC.put((String)"resource", (String)args.getResourceName());
            Response response = this.doProcess(args);
            LOG.info("Success");
            MDC.clear();
            return response;
        }
        catch (IllegalArgumentException ex) {
            LOG.error("Illegal argument.", (Throwable)ex);
            throw ErrorTable.newError(ErrorTable.INVALID_VOLUME_NAME, userArgs, ex);
        }
        catch (IOException ex) {
            this.handleIOException(volume, reqID, hostName, ex);
            return null;
        }
    }

    public abstract Response doProcess(VolumeArgs var1) throws IOException, OzoneException;

    private void handleIOException(String volume, String reqID, String hostName, IOException fsExp) throws OzoneException {
        LOG.error("IOException:", (Throwable)fsExp);
        OzoneException exp = null;
        if (fsExp != null && fsExp.getMessage().endsWith(OzoneManagerProtocolProtos.Status.VOLUME_ALREADY_EXISTS.name()) || fsExp instanceof FileAlreadyExistsException) {
            exp = ErrorTable.newError(ErrorTable.VOLUME_ALREADY_EXISTS, reqID, volume, hostName);
        }
        if (fsExp instanceof DirectoryNotEmptyException) {
            exp = ErrorTable.newError(ErrorTable.VOLUME_NOT_EMPTY, reqID, volume, hostName);
        }
        if (fsExp instanceof NoSuchFileException) {
            exp = ErrorTable.newError(ErrorTable.INVALID_VOLUME_NAME, reqID, volume, hostName);
        }
        if (fsExp != null && exp != null) {
            exp.setMessage(fsExp.getMessage());
        }
        if (exp == null) {
            exp = ErrorTable.newError(ErrorTable.SERVER_ERROR, reqID, volume, hostName);
            if (fsExp != null) {
                exp.setMessage(fsExp.getMessage());
            }
        }
        throw exp;
    }

    void setQuotaArgs(VolumeArgs args, String quota) throws OzoneException {
        try {
            args.setQuota(quota);
        }
        catch (IllegalArgumentException ex) {
            LOG.debug("Malformed Quota.", (Throwable)ex);
            throw ErrorTable.newError(ErrorTable.MALFORMED_QUOTA, (UserArgs)args, ex);
        }
    }

    Response getVolumeInfoResponse(VolumeArgs args) throws IOException, OzoneException {
        StorageHandler fs = StorageHandlerBuilder.getStorageHandler();
        VolumeInfo info = fs.getVolumeInfo(args);
        return OzoneRestUtils.getResponse((UserArgs)args, 200, info.toJsonString());
    }

    Response getVolumesByUser(UserArgs user, String prefix, int maxKeys, String prevKey, boolean rootScan) throws OzoneException, IOException {
        String validatedUser = user.getUserName();
        try {
            UserAuth auth = UserHandlerBuilder.getAuthHandler();
            if (rootScan && !auth.isAdmin(user)) {
                throw ErrorTable.newError(ErrorTable.UNAUTHORIZED, user);
            }
            if (auth.isAdmin(user) && (validatedUser = auth.getOzoneUser(user)) == null) {
                validatedUser = auth.getUser(user);
            }
            UserArgs onBehalfOf = new UserArgs(validatedUser, user.getRequestID(), user.getHostName(), user.getRequest(), user.getUri(), user.getHeaders());
            StorageHandler fs = StorageHandlerBuilder.getStorageHandler();
            ListArgs listArgs = new ListArgs(onBehalfOf, prefix, maxKeys, prevKey);
            listArgs.setRootScan(rootScan);
            ListVolumes volumes = fs.listVolumes(listArgs);
            return OzoneRestUtils.getResponse(user, 200, volumes.toJsonString());
        }
        catch (IOException ex) {
            LOG.debug("unable to get the volume list for the user.", (Throwable)ex);
            OzoneException exp = ErrorTable.newError(ErrorTable.SERVER_ERROR, user, ex);
            exp.setMessage("unable to get the volume list for the user");
            throw exp;
        }
    }

    Response getBucketsInVolume(VolumeArgs args, String prefix, int maxKeys, String prevKey) throws OzoneException {
        try {
            StorageHandler fs = StorageHandlerBuilder.getStorageHandler();
            ListArgs listArgs = new ListArgs((UserArgs)args, prefix, maxKeys, prevKey);
            ListBuckets bucketList = fs.listBuckets(listArgs);
            return OzoneRestUtils.getResponse((UserArgs)args, 200, bucketList.toJsonString());
        }
        catch (IOException ex) {
            LOG.debug("unable to get the bucket list for the specified volume.", (Throwable)ex);
            OzoneException exp = ErrorTable.newError(ErrorTable.SERVER_ERROR, (UserArgs)args, ex);
            exp.setMessage("unable to get the bucket list for the specified volume.");
            throw exp;
        }
    }
}

