/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.handlers;

import java.io.IOException;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.ozone.OzoneRestUtils;
import org.apache.hadoop.ozone.client.rest.OzoneException;
import org.apache.hadoop.ozone.web.exceptions.ErrorTable;
import org.apache.hadoop.ozone.web.handlers.StorageHandlerBuilder;
import org.apache.hadoop.ozone.web.handlers.UserArgs;
import org.apache.hadoop.ozone.web.handlers.UserHandlerBuilder;
import org.apache.hadoop.ozone.web.handlers.VolumeArgs;
import org.apache.hadoop.ozone.web.handlers.VolumeProcessTemplate;
import org.apache.hadoop.ozone.web.interfaces.StorageHandler;
import org.apache.hadoop.ozone.web.interfaces.UserAuth;
import org.apache.hadoop.ozone.web.interfaces.Volume;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

@InterfaceAudience.Private
public class VolumeHandler
implements Volume {
    private static final Logger LOG = LoggerFactory.getLogger(VolumeHandler.class);

    @Override
    public Response createVolume(String volume, final String quota, Request req, UriInfo uriInfo, HttpHeaders headers) throws OzoneException {
        MDC.put((String)"function", (String)"createVolume");
        return new VolumeProcessTemplate(){

            @Override
            public Response doProcess(VolumeArgs args) throws IOException, OzoneException {
                UserAuth auth = UserHandlerBuilder.getAuthHandler();
                if (auth.isAdmin((UserArgs)args)) {
                    args.setAdminName(args.getUserName());
                    String volumeOwner = auth.getOzoneUser((UserArgs)args);
                    if (volumeOwner == null) {
                        throw ErrorTable.newError(ErrorTable.USER_NOT_FOUND, (UserArgs)args);
                    }
                    if (!auth.isUser(volumeOwner, (UserArgs)args)) {
                        throw ErrorTable.newError(ErrorTable.USER_NOT_FOUND, (UserArgs)args);
                    }
                    args.setUserName(volumeOwner);
                    args.setGroups(auth.getGroups((UserArgs)args));
                    if (!quota.equals("undefined")) {
                        this.setQuotaArgs(args, quota);
                    }
                    StorageHandler fs = StorageHandlerBuilder.getStorageHandler();
                    fs.createVolume(args);
                    return OzoneRestUtils.getResponse((UserArgs)args, 201, "");
                }
                throw ErrorTable.newError(ErrorTable.ACCESS_DENIED, (UserArgs)args);
            }
        }.handleCall(volume, req, uriInfo, headers);
    }

    @Override
    public Response updateVolume(String volume, final String quota, Request req, UriInfo uriInfo, HttpHeaders headers) throws OzoneException {
        MDC.put((String)"function", (String)"updateVolume");
        return new VolumeProcessTemplate(){

            @Override
            public Response doProcess(VolumeArgs args) throws IOException, OzoneException {
                UserAuth auth = UserHandlerBuilder.getAuthHandler();
                if (auth.isAdmin((UserArgs)args)) {
                    StorageHandler fs = StorageHandlerBuilder.getStorageHandler();
                    args.setAdminName(args.getUserName());
                    String newVolumeOwner = auth.getOzoneUser((UserArgs)args);
                    if (newVolumeOwner != null) {
                        if (!auth.isUser(newVolumeOwner, (UserArgs)args)) {
                            throw ErrorTable.newError(ErrorTable.USER_NOT_FOUND, (UserArgs)args);
                        }
                        args.setUserName(newVolumeOwner);
                        fs.setVolumeOwner(args);
                    }
                    if (!quota.equals("undefined")) {
                        if (quota.equals("remove")) {
                            fs.setVolumeQuota(args, true);
                        } else {
                            this.setQuotaArgs(args, quota);
                            fs.setVolumeQuota(args, false);
                        }
                    }
                    return OzoneRestUtils.getResponse((UserArgs)args, 200, "");
                }
                throw ErrorTable.newError(ErrorTable.ACCESS_DENIED, (UserArgs)args);
            }
        }.handleCall(volume, req, uriInfo, headers);
    }

    @Override
    public Response deleteVolume(String volume, Request req, UriInfo uriInfo, HttpHeaders headers) throws OzoneException {
        MDC.put((String)"function", (String)"deleteVolume");
        return new VolumeProcessTemplate(){

            @Override
            public Response doProcess(VolumeArgs args) throws IOException, OzoneException {
                UserAuth auth = UserHandlerBuilder.getAuthHandler();
                if (auth.isAdmin((UserArgs)args)) {
                    StorageHandler fs = StorageHandlerBuilder.getStorageHandler();
                    fs.deleteVolume(args);
                    return OzoneRestUtils.getResponse((UserArgs)args, 200, "");
                }
                throw ErrorTable.newError(ErrorTable.ACCESS_DENIED, (UserArgs)args);
            }
        }.handleCall(volume, req, uriInfo, headers);
    }

    @Override
    public Response getVolumeInfo(String volume, final String info, final String prefix, final int maxKeys, final String prevKey, final boolean rootScan, Request req, final UriInfo uriInfo, HttpHeaders headers) throws OzoneException {
        return new VolumeProcessTemplate(){

            @Override
            public Response doProcess(VolumeArgs args) throws IOException, OzoneException {
                switch (info) {
                    case "bucket": {
                        MDC.put((String)"function", (String)"ListBucket");
                        return this.getBucketsInVolume(args, prefix, maxKeys, prevKey);
                    }
                    case "volume": {
                        MDC.put((String)"function", (String)"InfoVolume");
                        VolumeHandler.this.assertNoListParamPresent(uriInfo, args);
                        return this.getVolumeInfoResponse(args);
                    }
                    case "service": {
                        MDC.put((String)"function", (String)"ListVolume");
                        return this.getVolumesByUser((UserArgs)args, prefix, maxKeys, prevKey, rootScan);
                    }
                }
                LOG.debug("Unrecognized query param : {} ", (Object)info);
                OzoneException ozoneException = ErrorTable.newError(ErrorTable.INVALID_QUERY_PARAM, (UserArgs)args);
                ozoneException.setMessage("Unrecognized query param : " + info);
                throw ozoneException;
            }
        }.handleCall(volume, req, uriInfo, headers);
    }

    private void assertNoListParamPresent(UriInfo uriInfo, VolumeArgs args) throws OzoneException {
        String prefix = (String)uriInfo.getQueryParameters().getFirst((Object)"prefix");
        String maxKeys = (String)uriInfo.getQueryParameters().getFirst((Object)"max_keys");
        String prevKey = (String)uriInfo.getQueryParameters().getFirst((Object)"prev_key");
        if (prefix != null && !prefix.equals("") || maxKeys != null && !maxKeys.equals("1000") || prevKey != null && !prevKey.equals("")) {
            throw ErrorTable.newError(ErrorTable.INVALID_QUERY_PARAM, (UserArgs)args);
        }
    }
}

