/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.handlers;

import java.io.IOException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.NoSuchFileException;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.hadoop.hdds.protocol.StorageType;
import org.apache.hadoop.ozone.OzoneConsts;
import org.apache.hadoop.ozone.OzoneRestUtils;
import org.apache.hadoop.ozone.client.rest.OzoneException;
import org.apache.hadoop.ozone.web.exceptions.ErrorTable;
import org.apache.hadoop.ozone.web.handlers.BucketArgs;
import org.apache.hadoop.ozone.web.handlers.ListArgs;
import org.apache.hadoop.ozone.web.handlers.StorageHandlerBuilder;
import org.apache.hadoop.ozone.web.handlers.UserArgs;
import org.apache.hadoop.ozone.web.handlers.UserHandlerBuilder;
import org.apache.hadoop.ozone.web.interfaces.StorageHandler;
import org.apache.hadoop.ozone.web.interfaces.UserAuth;
import org.apache.hadoop.ozone.web.response.BucketInfo;
import org.apache.hadoop.ozone.web.response.ListKeys;
import org.apache.hadoop.ozone.web.utils.OzoneUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public abstract class BucketProcessTemplate {
    private static final Logger LOG = LoggerFactory.getLogger(BucketProcessTemplate.class);

    public Response handleCall(String volume, String bucket, Request request, UriInfo uriInfo, HttpHeaders headers) throws OzoneException {
        String reqID = OzoneUtils.getRequestID();
        String hostName = OzoneUtils.getHostName();
        MDC.put((String)"component", (String)"ozone");
        MDC.put((String)"request", (String)reqID);
        UserArgs userArgs = null;
        try {
            userArgs = new UserArgs(reqID, hostName, request, uriInfo, headers);
            OzoneRestUtils.validate(request, headers, reqID, bucket, hostName);
            OzoneUtils.verifyResourceName((String)bucket);
            UserAuth auth = UserHandlerBuilder.getAuthHandler();
            userArgs.setUserName(auth.getUser(userArgs));
            MDC.put((String)"user", (String)userArgs.getUserName());
            BucketArgs args = new BucketArgs(volume, bucket, userArgs);
            MDC.put((String)"resource", (String)args.getResourceName());
            Response response = this.doProcess(args);
            LOG.debug("Success");
            MDC.clear();
            return response;
        }
        catch (IllegalArgumentException argEx) {
            LOG.error("Invalid bucket.", (Throwable)argEx);
            throw ErrorTable.newError(ErrorTable.INVALID_BUCKET_NAME, userArgs, argEx);
        }
        catch (IOException fsExp) {
            this.handleIOException(bucket, reqID, hostName, fsExp);
            return null;
        }
    }

    void getAclsFromHeaders(BucketArgs args, boolean parseRemoveACL) throws OzoneException {
        try {
            List<String> acls = this.getAcls(args, "REMOVE");
            if (acls != null && !acls.isEmpty()) {
                args.removeAcls(acls);
            }
            if (!parseRemoveACL && args.getRemoveAcls() != null) {
                OzoneException ex = ErrorTable.newError(ErrorTable.MALFORMED_ACL, (UserArgs)args);
                ex.setMessage("Invalid Remove ACLs");
                throw ex;
            }
            acls = this.getAcls(args, "ADD");
            if (acls != null && !acls.isEmpty()) {
                args.addAcls(acls);
            }
        }
        catch (IllegalArgumentException ex) {
            throw ErrorTable.newError(ErrorTable.MALFORMED_ACL, (UserArgs)args, ex);
        }
    }

    void handleIOException(String bucket, String reqID, String hostName, IOException fsExp) throws OzoneException {
        LOG.error("IOException:", (Throwable)fsExp);
        OzoneException exp = null;
        if (fsExp instanceof FileAlreadyExistsException) {
            exp = ErrorTable.newError(ErrorTable.BUCKET_ALREADY_EXISTS, reqID, bucket, hostName);
        }
        if (fsExp instanceof DirectoryNotEmptyException) {
            exp = ErrorTable.newError(ErrorTable.BUCKET_NOT_EMPTY, reqID, bucket, hostName);
        }
        if (fsExp instanceof NoSuchFileException) {
            exp = ErrorTable.newError(ErrorTable.INVALID_BUCKET_NAME, reqID, bucket, hostName);
        }
        if (exp == null) {
            exp = ErrorTable.newError(ErrorTable.SERVER_ERROR, reqID, bucket, hostName);
            if (fsExp != null) {
                exp.setMessage(fsExp.getMessage());
            }
        }
        throw exp;
    }

    public abstract Response doProcess(BucketArgs var1) throws OzoneException, IOException;

    List<String> getAcls(BucketArgs args, String tag) {
        List aclStrings = args.getHeaders().getRequestHeader("x-ozone-acls");
        LinkedList<String> filteredSet = null;
        if (aclStrings != null) {
            filteredSet = new LinkedList<String>();
            for (String s : aclStrings) {
                if (!s.startsWith(tag)) continue;
                filteredSet.add(s.replaceFirst(tag, ""));
            }
        }
        return filteredSet;
    }

    OzoneConsts.Versioning getVersioning(BucketArgs args) throws OzoneException {
        List versionStrings = args.getHeaders().getRequestHeader("x-ozone-bucket-versioning");
        if (versionStrings == null) {
            return null;
        }
        if (versionStrings.size() > 1) {
            OzoneException ex = ErrorTable.newError(ErrorTable.MALFORMED_BUCKET_VERSION, (UserArgs)args);
            ex.setMessage("Exactly one bucket version header required");
            throw ex;
        }
        String version = (String)versionStrings.get(0);
        try {
            return OzoneConsts.Versioning.valueOf((String)version);
        }
        catch (IllegalArgumentException ex) {
            LOG.debug("Malformed Version. version: {}", (Object)version);
            throw ErrorTable.newError(ErrorTable.MALFORMED_BUCKET_VERSION, (UserArgs)args, ex);
        }
    }

    StorageType getStorageType(BucketArgs args) throws OzoneException {
        List storageClassString = null;
        try {
            storageClassString = args.getHeaders().getRequestHeader("x-ozone-storage-type");
            if (storageClassString == null) {
                return null;
            }
            if (storageClassString.size() > 1) {
                OzoneException ex = ErrorTable.newError(ErrorTable.MALFORMED_STORAGE_TYPE, (UserArgs)args);
                ex.setMessage("Exactly one storage class header required");
                throw ex;
            }
            return StorageType.valueOf((String)((String)storageClassString.get(0)).toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            if (storageClassString != null) {
                LOG.debug("Malformed storage type. Type: {}", (Object)((String)storageClassString.get(0)).toUpperCase());
            }
            throw ErrorTable.newError(ErrorTable.MALFORMED_STORAGE_TYPE, (UserArgs)args, ex);
        }
    }

    Response getBucketInfoResponse(BucketArgs args) throws IOException, OzoneException {
        StorageHandler fs = StorageHandlerBuilder.getStorageHandler();
        BucketInfo info = fs.getBucketInfo(args);
        return OzoneRestUtils.getResponse((UserArgs)args, 200, info.toJsonString());
    }

    Response getBucketKeysList(ListArgs args) throws IOException, OzoneException {
        StorageHandler fs = StorageHandlerBuilder.getStorageHandler();
        ListKeys objects = fs.listKeys(args);
        return OzoneRestUtils.getResponse(args.getArgs(), 200, objects.toJsonString());
    }
}

