/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.handlers;

import java.io.IOException;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.hadoop.ozone.OzoneConsts;
import org.apache.hadoop.ozone.OzoneRestUtils;
import org.apache.hadoop.ozone.client.rest.OzoneException;
import org.apache.hadoop.ozone.web.exceptions.ErrorTable;
import org.apache.hadoop.ozone.web.handlers.BucketArgs;
import org.apache.hadoop.ozone.web.handlers.BucketProcessTemplate;
import org.apache.hadoop.ozone.web.handlers.ListArgs;
import org.apache.hadoop.ozone.web.handlers.StorageHandlerBuilder;
import org.apache.hadoop.ozone.web.handlers.UserArgs;
import org.apache.hadoop.ozone.web.interfaces.Bucket;
import org.apache.hadoop.ozone.web.interfaces.StorageHandler;
import org.slf4j.MDC;

public class BucketHandler
implements Bucket {
    @Override
    public Response createBucket(String volume, String bucket, Request req, UriInfo info, HttpHeaders headers) throws OzoneException {
        MDC.put((String)"function", (String)"createBucket");
        return new BucketProcessTemplate(){

            @Override
            public Response doProcess(BucketArgs args) throws OzoneException, IOException {
                StorageHandler fs = StorageHandlerBuilder.getStorageHandler();
                this.getAclsFromHeaders(args, false);
                args.setVersioning(this.getVersioning(args));
                args.setStorageType(this.getStorageType(args));
                fs.createBucket(args);
                return OzoneRestUtils.getResponse((UserArgs)args, 201, "");
            }
        }.handleCall(volume, bucket, req, info, headers);
    }

    @Override
    public Response updateBucket(String volume, String bucket, Request req, UriInfo info, HttpHeaders headers) throws OzoneException {
        MDC.put((String)"function", (String)"updateBucket");
        return new BucketProcessTemplate(){

            @Override
            public Response doProcess(BucketArgs args) throws OzoneException, IOException {
                StorageHandler fs = StorageHandlerBuilder.getStorageHandler();
                this.getAclsFromHeaders(args, true);
                args.setVersioning(this.getVersioning(args));
                args.setStorageType(this.getStorageType(args));
                if (args.getAddAcls() != null || args.getRemoveAcls() != null) {
                    fs.setBucketAcls(args);
                }
                if (args.getVersioning() != OzoneConsts.Versioning.NOT_DEFINED) {
                    fs.setBucketVersioning(args);
                }
                if (args.getStorageType() != null) {
                    fs.setBucketStorageClass(args);
                }
                return OzoneRestUtils.getResponse((UserArgs)args, 200, "");
            }
        }.handleCall(volume, bucket, req, info, headers);
    }

    @Override
    public Response deleteBucket(String volume, String bucket, Request req, UriInfo info, HttpHeaders headers) throws OzoneException {
        MDC.put((String)"function", (String)"deleteBucket");
        return new BucketProcessTemplate(){

            @Override
            public Response doProcess(BucketArgs args) throws OzoneException, IOException {
                StorageHandler fs = StorageHandlerBuilder.getStorageHandler();
                fs.deleteBucket(args);
                return OzoneRestUtils.getResponse((UserArgs)args, 200, "");
            }
        }.handleCall(volume, bucket, req, info, headers);
    }

    @Override
    public Response listBucket(String volume, String bucket, final String info, final String prefix, final int maxKeys, final String startPage, Request req, UriInfo uriInfo, HttpHeaders headers) throws OzoneException {
        MDC.put((String)"function", (String)"listBucket");
        return new BucketProcessTemplate(){

            @Override
            public Response doProcess(BucketArgs args) throws OzoneException, IOException {
                switch (info) {
                    case "key": {
                        ListArgs listArgs = new ListArgs((UserArgs)args, prefix, maxKeys, startPage);
                        return this.getBucketKeysList(listArgs);
                    }
                    case "bucket": {
                        return this.getBucketInfoResponse(args);
                    }
                }
                OzoneException ozException = ErrorTable.newError(ErrorTable.INVALID_QUERY_PARAM, (UserArgs)args);
                ozException.setMessage("Unrecognized query param : " + info);
                throw ozException;
            }
        }.handleCall(volume, bucket, req, uriInfo, headers);
    }
}

