/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.exceptions;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.ozone.client.rest.OzoneException;
import org.apache.hadoop.ozone.web.handlers.UserArgs;

@InterfaceAudience.Private
public final class ErrorTable {
    public static final OzoneException MISSING_VERSION = new OzoneException(400L, "missingVersion", "x-ozone-version header is required.");
    public static final OzoneException MISSING_DATE = new OzoneException(400L, "missingDate", "Date header is required.");
    public static final OzoneException BAD_DATE = new OzoneException(400L, "badDate", "Unable to parse date format.");
    public static final OzoneException MALFORMED_QUOTA = new OzoneException(400L, "malformedQuota", "Invalid quota specified.");
    public static final OzoneException MALFORMED_ACL = new OzoneException(400L, "malformedACL", "Invalid ACL specified.");
    public static final OzoneException INVALID_VOLUME_NAME = new OzoneException(400L, "invalidVolumeName", "Invalid volume name.");
    public static final OzoneException INVALID_QUERY_PARAM = new OzoneException(400L, "invalidQueryParam", "Invalid query parameter.");
    public static final OzoneException INVALID_RESOURCE_NAME = new OzoneException(400L, "invalidResourceName", "Invalid volume, bucket or key name.");
    public static final OzoneException INVALID_BUCKET_NAME = new OzoneException(400L, "invalidBucketName", "Invalid bucket name.");
    public static final OzoneException INVALID_KEY = new OzoneException(400L, "invalidKey", "Invalid key.");
    public static final OzoneException INVALID_REQUEST = new OzoneException(400L, "invalidRequest", "Error in request.");
    public static final OzoneException MALFORMED_BUCKET_VERSION = new OzoneException(400L, "malformedBucketVersion", "Malformed bucket version or version not unique.");
    public static final OzoneException MALFORMED_STORAGE_TYPE = new OzoneException(400L, "malformedStorageType", "Invalid storage Type specified.");
    public static final OzoneException MALFORMED_STORAGE_CLASS = new OzoneException(400L, "malformedStorageClass", "Invalid storage class specified.");
    public static final OzoneException BAD_DIGEST = new OzoneException(400L, "badDigest", "Content MD5 does not match.");
    public static final OzoneException INCOMPLETE_BODY = new OzoneException(400L, "incompleteBody", "Content length does not match stream size.");
    public static final OzoneException BAD_AUTHORIZATION = new OzoneException(400L, "badAuthorization", "Missing authorization or authorization has to be unique.");
    public static final OzoneException BAD_PROPERTY = new OzoneException(400L, "unknownProperty", "This property is not supported by this server.");
    public static final OzoneException UNAUTHORIZED = new OzoneException(401L, "Unauthorized", "Access token is missing or invalid token.");
    public static final OzoneException ACCESS_DENIED = new OzoneException(403L, "accessDenied", "Access denied.");
    public static final OzoneException USER_NOT_FOUND = new OzoneException(404L, "userNotFound", "Invalid user name.");
    public static final OzoneException VOLUME_NOT_FOUND = new OzoneException(404L, "volumeNotFound", "No such volume.");
    public static final OzoneException VOLUME_ALREADY_EXISTS = new OzoneException(409L, "volumeAlreadyExists", "Duplicate volume name.");
    public static final OzoneException BUCKET_ALREADY_EXISTS = new OzoneException(409L, "bucketAlreadyExists", "Duplicate bucket name.");
    public static final OzoneException VOLUME_NOT_EMPTY = new OzoneException(409L, "volumeNotEmpty", "Volume must not have any buckets.");
    public static final OzoneException BUCKET_NOT_EMPTY = new OzoneException(409L, "bucketNotEmpty", "Bucket must not have any keys.");
    public static final OzoneException KEY_OPERATION_CONFLICT = new OzoneException(409L, "keyOperationConflict", "Conflicting operation on the specified key is going on.");
    public static final OzoneException SERVER_ERROR = new OzoneException(500L, "internalServerError", "Internal server error.");

    public static OzoneException newError(OzoneException e, String requestID, String resource, String hostID) {
        OzoneException err = new OzoneException(e.getHttpCode(), e.getShortMessage(), e.getMessage());
        err.setRequestId(requestID);
        err.setResource(resource);
        err.setHostID(hostID);
        return err;
    }

    public static OzoneException newError(OzoneException e, UserArgs args) {
        OzoneException err = new OzoneException(e.getHttpCode(), e.getShortMessage(), e.getMessage());
        if (args != null) {
            err.setRequestId(args.getRequestID());
            err.setResource(args.getResourceName());
            err.setHostID(args.getHostName());
        }
        return err;
    }

    public static OzoneException newError(OzoneException e, UserArgs args, Exception ex) {
        OzoneException err = new OzoneException(e.getHttpCode(), e.getShortMessage(), ex);
        if (args != null) {
            err.setRequestId(args.getRequestID());
            err.setResource(args.getResourceName());
            err.setHostID(args.getHostName());
        }
        err.setMessage(ex.getMessage());
        return err;
    }

    private ErrorTable() {
    }
}

