/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.client.impl;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.LongFunction;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.client.RaftClientConfigKeys;
import org.apache.ratis.client.RaftClientRpc;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.GroupInfoRequest;
import org.apache.ratis.protocol.GroupListRequest;
import org.apache.ratis.protocol.GroupManagementRequest;
import org.apache.ratis.protocol.GroupMismatchException;
import org.apache.ratis.protocol.LeaderNotReadyException;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.NotLeaderException;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.SetConfigurationRequest;
import org.apache.ratis.protocol.StateMachineException;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.util.CollectionUtils;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.SlidingWindow;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.TimeoutScheduler;

final class RaftClientImpl
implements RaftClient {
    private static final AtomicLong callIdCounter = new AtomicLong();
    private final ClientId clientId;
    private final RaftClientRpc clientRpc;
    private final Collection<RaftPeer> peers;
    private final RaftGroupId groupId;
    private final TimeDuration retryInterval;
    private final RetryPolicy retryPolicy;
    private volatile RaftPeerId leaderId;
    private final ConcurrentMap<String, SlidingWindow.Client<PendingAsyncRequest, RaftClientReply>> slidingWindows = new ConcurrentHashMap<String, SlidingWindow.Client<PendingAsyncRequest, RaftClientReply>>();
    private final TimeoutScheduler scheduler;
    private final Semaphore asyncRequestSemaphore;

    private static long nextCallId() {
        return callIdCounter.getAndIncrement() & Long.MAX_VALUE;
    }

    RaftClientImpl(ClientId clientId, RaftGroup group, RaftPeerId leaderId, RaftClientRpc clientRpc, RaftProperties properties, RetryPolicy retryPolicy) {
        this.clientId = clientId;
        this.clientRpc = clientRpc;
        this.peers = new ConcurrentLinkedQueue<RaftPeer>(group.getPeers());
        this.groupId = group.getGroupId();
        this.leaderId = leaderId != null ? leaderId : (!this.peers.isEmpty() ? this.peers.iterator().next().getId() : null);
        this.retryInterval = RaftClientConfigKeys.Rpc.retryInterval(properties);
        Preconditions.assertTrue((retryPolicy != null ? 1 : 0) != 0, (Object)"retry policy can't be null");
        this.retryPolicy = retryPolicy;
        this.asyncRequestSemaphore = new Semaphore(RaftClientConfigKeys.Async.maxOutstandingRequests(properties));
        this.scheduler = TimeoutScheduler.newInstance((int)RaftClientConfigKeys.Async.schedulerThreads(properties));
        clientRpc.addServers(this.peers);
    }

    @Override
    public ClientId getId() {
        return this.clientId;
    }

    private SlidingWindow.Client<PendingAsyncRequest, RaftClientReply> getSlidingWindow(RaftClientRequest request) {
        return this.getSlidingWindow(request.is(RaftProtos.RaftClientRequestProto.TypeCase.STALEREAD) ? request.getServerId() : null);
    }

    private SlidingWindow.Client<PendingAsyncRequest, RaftClientReply> getSlidingWindow(RaftPeerId target) {
        String id = target != null ? target.toString() : "RAFT";
        return this.slidingWindows.computeIfAbsent(id, key -> new SlidingWindow.Client((Object)(this.getId() + "->" + key)));
    }

    @Override
    public CompletableFuture<RaftClientReply> sendAsync(Message message, RaftProtos.ReplicationLevel replication) {
        return this.sendAsync(RaftClientRequest.writeRequestType((RaftProtos.ReplicationLevel)replication), message, null);
    }

    @Override
    public CompletableFuture<RaftClientReply> sendReadOnlyAsync(Message message) {
        return this.sendAsync(RaftClientRequest.readRequestType(), message, null);
    }

    @Override
    public CompletableFuture<RaftClientReply> sendStaleReadAsync(Message message, long minIndex, RaftPeerId server) {
        return this.sendAsync(RaftClientRequest.staleReadRequestType((long)minIndex), message, server);
    }

    @Override
    public CompletableFuture<RaftClientReply> sendWatchAsync(long index, RaftProtos.ReplicationLevel replication) {
        return this.sendAsync(RaftClientRequest.watchRequestType((long)index, (RaftProtos.ReplicationLevel)replication), null, null);
    }

    private CompletableFuture<RaftClientReply> sendAsync(RaftClientRequest.Type type, Message message, RaftPeerId server) {
        if (!type.is(RaftProtos.RaftClientRequestProto.TypeCase.WATCH)) {
            Objects.requireNonNull(message, "message == null");
        }
        try {
            this.asyncRequestSemaphore.acquire();
        }
        catch (InterruptedException e2) {
            throw new CompletionException(IOUtils.toInterruptedIOException((String)("Interrupted when sending " + type + ", message=" + message), (InterruptedException)e2));
        }
        long callId = RaftClientImpl.nextCallId();
        LongFunction<PendingAsyncRequest> constructor = seqNum -> new PendingAsyncRequest(seqNum, seq -> this.newRaftClientRequest(server, callId, seq, message, type));
        return ((CompletableFuture)((PendingAsyncRequest)this.getSlidingWindow(server).submitNewRequest(constructor, this::sendRequestWithRetryAsync)).getReplyFuture().thenApply(reply -> RaftClientImpl.handleStateMachineException(reply, CompletionException::new))).whenComplete((r, e) -> this.asyncRequestSemaphore.release());
    }

    private RaftClientRequest newRaftClientRequest(RaftPeerId server, long callId, long seq, Message message, RaftClientRequest.Type type) {
        return new RaftClientRequest(this.clientId, server != null ? server : this.leaderId, this.groupId, callId, seq, message, type);
    }

    @Override
    public RaftClientReply send(Message message, RaftProtos.ReplicationLevel replication) throws IOException {
        return this.send(RaftClientRequest.writeRequestType((RaftProtos.ReplicationLevel)replication), message, null);
    }

    @Override
    public RaftClientReply sendReadOnly(Message message) throws IOException {
        return this.send(RaftClientRequest.readRequestType(), message, null);
    }

    @Override
    public RaftClientReply sendStaleRead(Message message, long minIndex, RaftPeerId server) throws IOException {
        return this.send(RaftClientRequest.staleReadRequestType((long)minIndex), message, server);
    }

    @Override
    public RaftClientReply sendWatch(long index, RaftProtos.ReplicationLevel replication) throws IOException {
        return this.send(RaftClientRequest.watchRequestType((long)index, (RaftProtos.ReplicationLevel)replication), null, null);
    }

    private RaftClientReply send(RaftClientRequest.Type type, Message message, RaftPeerId server) throws IOException {
        if (!type.is(RaftProtos.RaftClientRequestProto.TypeCase.WATCH)) {
            Objects.requireNonNull(message, "message == null");
        }
        long callId = RaftClientImpl.nextCallId();
        return this.sendRequestWithRetry(() -> this.newRaftClientRequest(server, callId, 0L, message, type));
    }

    @Override
    public RaftClientReply setConfiguration(RaftPeer[] peersInNewConf) throws IOException {
        Objects.requireNonNull(peersInNewConf, "peersInNewConf == null");
        long callId = RaftClientImpl.nextCallId();
        this.addServers(Arrays.stream(peersInNewConf));
        return this.sendRequestWithRetry(() -> new SetConfigurationRequest(this.clientId, this.leaderId, this.groupId, callId, peersInNewConf));
    }

    @Override
    public RaftClientReply groupAdd(RaftGroup newGroup, RaftPeerId server) throws IOException {
        Objects.requireNonNull(newGroup, "newGroup == null");
        Objects.requireNonNull(server, "server == null");
        long callId = RaftClientImpl.nextCallId();
        this.addServers(newGroup.getPeers().stream());
        return this.sendRequest((RaftClientRequest)GroupManagementRequest.newAdd((ClientId)this.clientId, (RaftPeerId)server, (long)callId, (RaftGroup)newGroup));
    }

    @Override
    public RaftClientReply groupRemove(RaftGroupId groupId, boolean deleteDirectory, RaftPeerId server) throws IOException {
        Objects.requireNonNull(groupId, "groupId == null");
        Objects.requireNonNull(server, "server == null");
        long callId = RaftClientImpl.nextCallId();
        return this.sendRequest((RaftClientRequest)GroupManagementRequest.newRemove((ClientId)this.clientId, (RaftPeerId)server, (long)callId, (RaftGroupId)groupId, (boolean)deleteDirectory));
    }

    @Override
    public RaftClientReply getGroups(RaftPeerId server) throws IOException {
        Objects.requireNonNull(server, "server == null");
        return this.sendRequest((RaftClientRequest)new GroupListRequest(this.clientId, server, this.groupId, RaftClientImpl.nextCallId()));
    }

    @Override
    public RaftClientReply getGroupInfo(RaftGroupId raftGroupId, RaftPeerId server) throws IOException {
        Objects.requireNonNull(server, "server == null");
        RaftGroupId rgi = raftGroupId == null ? this.groupId : raftGroupId;
        return this.sendRequest((RaftClientRequest)new GroupInfoRequest(this.clientId, server, rgi, RaftClientImpl.nextCallId()));
    }

    private void addServers(Stream<RaftPeer> peersInNewConf) {
        this.clientRpc.addServers(peersInNewConf.filter(p -> !this.peers.contains(p))::iterator);
    }

    private CompletableFuture<RaftClientReply> sendRequestWithRetryAsync(PendingAsyncRequest pending) {
        RaftClientRequest request = pending.newRequest();
        CompletableFuture<RaftClientReply> f = pending.getReplyFuture();
        return this.sendRequestAsync(request).thenCompose(reply -> {
            if (reply == null) {
                LOG.debug("schedule a retry in {} for {}", (Object)this.retryInterval, (Object)request);
                this.scheduler.onTimeout(this.retryInterval, () -> this.getSlidingWindow(request).retry((SlidingWindow.Request)pending, this::sendRequestWithRetryAsync), LOG, () -> "Failed to retry " + request);
            } else {
                f.complete((RaftClientReply)reply);
            }
            return f;
        });
    }

    private RaftClientReply sendRequestWithRetry(Supplier<RaftClientRequest> supplier) throws InterruptedIOException, StateMachineException, GroupMismatchException {
        int retryCount = 0;
        RaftClientRequest request;
        RaftClientReply reply;
        while ((reply = this.sendRequest(request = supplier.get())) == null) {
            if (!this.retryPolicy.shouldRetry(retryCount)) {
                return null;
            }
            try {
                this.retryPolicy.getSleepTime().sleep();
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException("retry policy=" + this.retryPolicy);
            }
            ++retryCount;
        }
        return reply;
    }

    private CompletableFuture<RaftClientReply> sendRequestAsync(RaftClientRequest request) {
        LOG.debug("{}: send* {}", (Object)this.clientId, (Object)request);
        return ((CompletableFuture)this.clientRpc.sendRequestAsync(request).thenApply(reply -> {
            LOG.debug("{}: receive* {}", (Object)this.clientId, reply);
            reply = this.handleNotLeaderException(request, (RaftClientReply)reply);
            if (reply != null) {
                this.getSlidingWindow(request).receiveReply(request.getSeqNum(), reply, this::sendRequestWithRetryAsync);
            }
            return reply;
        })).exceptionally(e -> {
            if (LOG.isTraceEnabled()) {
                LOG.trace(this.clientId + ": Failed " + request, e);
            } else {
                LOG.debug("{}: Failed {} with {}", new Object[]{this.clientId, request, e});
            }
            e = JavaUtils.unwrapCompletionException((Throwable)e);
            if (e instanceof GroupMismatchException) {
                throw new CompletionException((Throwable)e);
            }
            if (!(e instanceof IOException)) {
                throw new CompletionException((Throwable)e);
            }
            this.handleIOException(request, (IOException)e, null);
            return null;
        });
    }

    private RaftClientReply sendRequest(RaftClientRequest request) throws StateMachineException, GroupMismatchException {
        LOG.debug("{}: send {}", (Object)this.clientId, (Object)request);
        RaftClientReply reply = null;
        try {
            reply = this.clientRpc.sendRequest(request);
        }
        catch (GroupMismatchException gme) {
            throw gme;
        }
        catch (IOException ioe) {
            this.handleIOException(request, ioe, null);
        }
        LOG.debug("{}: receive {}", (Object)this.clientId, (Object)reply);
        reply = this.handleNotLeaderException(request, reply);
        reply = RaftClientImpl.handleStateMachineException(reply, Function.identity());
        return reply;
    }

    static <E extends Throwable> RaftClientReply handleStateMachineException(RaftClientReply reply, Function<StateMachineException, E> converter) throws E {
        StateMachineException sme;
        if (reply != null && (sme = reply.getStateMachineException()) != null) {
            throw (Throwable)converter.apply(sme);
        }
        return reply;
    }

    private RaftClientReply handleNotLeaderException(RaftClientRequest request, RaftClientReply reply) {
        if (reply == null) {
            return null;
        }
        NotLeaderException nle = reply.getNotLeaderException();
        if (nle == null) {
            return reply;
        }
        this.refreshPeers(Arrays.asList(nle.getPeers()));
        RaftPeerId newLeader = nle.getSuggestedLeader() == null ? null : nle.getSuggestedLeader().getId();
        this.handleIOException(request, (IOException)nle, newLeader);
        return null;
    }

    private void refreshPeers(Collection<RaftPeer> newPeers) {
        if (newPeers != null && newPeers.size() > 0) {
            this.peers.clear();
            this.peers.addAll(newPeers);
            this.clientRpc.addServers(newPeers);
        }
    }

    private void handleIOException(RaftClientRequest request, IOException ioe, RaftPeerId newLeader) {
        boolean changeLeader;
        LOG.debug("{}: suggested new leader: {}. Failed {} with {}", new Object[]{this.clientId, newLeader, request, ioe});
        if (LOG.isTraceEnabled()) {
            LOG.trace("Stack trace", new Throwable("TRACE"));
        }
        this.getSlidingWindow(request).resetFirstSeqNum();
        if (ioe instanceof LeaderNotReadyException) {
            return;
        }
        RaftPeerId oldLeader = request.getServerId();
        boolean stillLeader = oldLeader.equals((Object)this.leaderId);
        if (newLeader == null && stillLeader) {
            newLeader = (RaftPeerId)CollectionUtils.random((Object)oldLeader, (Iterable)CollectionUtils.as(this.peers, RaftPeer::getId));
        }
        boolean bl = changeLeader = newLeader != null && stillLeader;
        if (changeLeader) {
            LOG.debug("{}: change Leader from {} to {}", new Object[]{this.clientId, oldLeader, newLeader});
            this.leaderId = newLeader;
        }
        this.clientRpc.handleException(oldLeader, ioe, changeLeader);
    }

    void assertAsyncRequestSemaphore(int expectedAvailablePermits, int expectedQueueLength) {
        Preconditions.assertTrue((this.asyncRequestSemaphore.availablePermits() == expectedAvailablePermits ? 1 : 0) != 0);
        Preconditions.assertTrue((this.asyncRequestSemaphore.getQueueLength() == expectedQueueLength ? 1 : 0) != 0);
    }

    void assertScheduler(int numThreads) {
        Preconditions.assertTrue((this.scheduler.getNumThreads() == numThreads ? 1 : 0) != 0);
    }

    long getCallId() {
        return callIdCounter.get();
    }

    @Override
    public RaftClientRpc getClientRpc() {
        return this.clientRpc;
    }

    @Override
    public void close() throws IOException {
        this.clientRpc.close();
    }

    static class PendingAsyncRequest
    implements SlidingWindow.Request<RaftClientReply> {
        private final long seqNum;
        private final LongFunction<RaftClientRequest> requestConstructor;
        private final CompletableFuture<RaftClientReply> replyFuture = new CompletableFuture();

        PendingAsyncRequest(long seqNum, LongFunction<RaftClientRequest> requestConstructor) {
            this.seqNum = seqNum;
            this.requestConstructor = requestConstructor;
        }

        RaftClientRequest newRequest() {
            return this.requestConstructor.apply(this.seqNum);
        }

        public long getSeqNum() {
            return this.seqNum;
        }

        public boolean hasReply() {
            return this.replyFuture.isDone();
        }

        public void setReply(RaftClientReply reply) {
            this.replyFuture.complete(reply);
        }

        CompletableFuture<RaftClientReply> getReplyFuture() {
            return this.replyFuture;
        }

        public String toString() {
            return "[seq=" + this.getSeqNum() + "]";
        }
    }
}

