/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.ratis.RaftConfigKeys;
import org.apache.ratis.client.ClientFactory;
import org.apache.ratis.client.RaftClientRpc;
import org.apache.ratis.client.impl.ClientImplUtils;
import org.apache.ratis.conf.Parameters;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.retry.RetryPolicies;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.rpc.RpcType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface RaftClient
extends Closeable {
    public static final Logger LOG = LoggerFactory.getLogger(RaftClient.class);

    public ClientId getId();

    public RaftClientRpc getClientRpc();

    public CompletableFuture<RaftClientReply> sendAsync(Message var1, RaftProtos.ReplicationLevel var2);

    default public CompletableFuture<RaftClientReply> sendAsync(Message message) {
        return this.sendAsync(message, RaftProtos.ReplicationLevel.MAJORITY);
    }

    public CompletableFuture<RaftClientReply> sendReadOnlyAsync(Message var1);

    public CompletableFuture<RaftClientReply> sendStaleReadAsync(Message var1, long var2, RaftPeerId var4);

    public CompletableFuture<RaftClientReply> sendWatchAsync(long var1, RaftProtos.ReplicationLevel var3);

    public RaftClientReply send(Message var1, RaftProtos.ReplicationLevel var2) throws IOException;

    default public RaftClientReply send(Message message) throws IOException {
        return this.send(message, RaftProtos.ReplicationLevel.MAJORITY);
    }

    public RaftClientReply sendReadOnly(Message var1) throws IOException;

    public RaftClientReply sendStaleRead(Message var1, long var2, RaftPeerId var4) throws IOException;

    public RaftClientReply sendWatch(long var1, RaftProtos.ReplicationLevel var3) throws IOException;

    public RaftClientReply setConfiguration(RaftPeer[] var1) throws IOException;

    public RaftClientReply groupAdd(RaftGroup var1, RaftPeerId var2) throws IOException;

    public RaftClientReply groupRemove(RaftGroupId var1, boolean var2, RaftPeerId var3) throws IOException;

    public RaftClientReply getGroups(RaftPeerId var1) throws IOException;

    public RaftClientReply getGroupInfo(RaftGroupId var1, RaftPeerId var2) throws IOException;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private ClientId clientId;
        private RaftClientRpc clientRpc;
        private RaftGroup group;
        private RaftPeerId leaderId;
        private RaftProperties properties;
        private Parameters parameters;
        private RetryPolicy retryPolicy = RetryPolicies.retryForeverNoSleep();

        private Builder() {
        }

        public RaftClient build() {
            if (this.clientId == null) {
                this.clientId = ClientId.randomId();
            }
            if (this.properties != null && this.clientRpc == null) {
                RpcType rpcType = RaftConfigKeys.Rpc.type((RaftProperties)this.properties, arg_0 -> ((Logger)LOG).debug(arg_0));
                ClientFactory factory = ClientFactory.cast(rpcType.newFactory(this.parameters));
                this.clientRpc = factory.newRaftClientRpc(this.clientId, this.properties);
            }
            return ClientImplUtils.newRaftClient(this.clientId, Objects.requireNonNull(this.group, "The 'group' field is not initialized."), this.leaderId, Objects.requireNonNull(this.clientRpc, "The 'clientRpc' field is not initialized."), this.properties, this.retryPolicy);
        }

        public Builder setClientId(ClientId clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder setRaftGroup(RaftGroup group) {
            this.group = group;
            return this;
        }

        public Builder setLeaderId(RaftPeerId leaderId) {
            this.leaderId = leaderId;
            return this;
        }

        public Builder setClientRpc(RaftClientRpc clientRpc) {
            this.clientRpc = clientRpc;
            return this;
        }

        public Builder setProperties(RaftProperties properties) {
            this.properties = properties;
            return this;
        }

        public Builder setParameters(Parameters parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder setRetryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = retryPolicy;
            return this;
        }
    }
}

