/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.ratis.thirdparty.com.google.common.collect.Interner;
import org.apache.ratis.thirdparty.com.google.common.collect.Interners;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;

public class StringUtils {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Interner<String> WEAK_INTERNER = Interners.newWeakInterner();

    public static String weakIntern(String sample) {
        return sample == null ? null : (String)WEAK_INTERNER.intern((Object)sample);
    }

    public static String[] getTrimmedStrings(String s) {
        return s == null ? EMPTY_STRING_ARRAY : ((s = s.trim()).isEmpty() ? EMPTY_STRING_ARRAY : s.split("\\s*,\\s*"));
    }

    public static String format(String format, Object ... objects) {
        return String.format(Locale.ENGLISH, format, objects);
    }

    public static String bytes2HexShortString(ByteString bytes) {
        int size = bytes.size();
        if (size == 0) {
            return "<EMPTY>";
        }
        if (size > 10) {
            return StringUtils.bytes2HexString(bytes.substring(0, 10)) + "...(size=" + size + ")";
        }
        return StringUtils.bytes2HexString(bytes);
    }

    public static String bytes2HexString(ByteString bytes) {
        Objects.requireNonNull(bytes, "bytes == null");
        return StringUtils.bytes2HexString(bytes.asReadOnlyByteBuffer());
    }

    public static String bytes2HexString(byte[] bytes) {
        Objects.requireNonNull(bytes, "bytes == null");
        return StringUtils.bytes2HexString(ByteBuffer.wrap(bytes));
    }

    public static String bytes2HexString(byte[] bytes, int offset, int length) {
        Objects.requireNonNull(bytes, "bytes == null");
        return StringUtils.bytes2HexString(ByteBuffer.wrap(bytes, offset, length));
    }

    public static String bytes2HexString(ByteBuffer bytes) {
        Objects.requireNonNull(bytes, "bytes == null");
        StringBuilder s = new StringBuilder(2 * bytes.remaining());
        while (bytes.remaining() > 0) {
            s.append(StringUtils.format("%02x", bytes.get()));
        }
        bytes.flip();
        return s.toString();
    }

    public static boolean string2boolean(String s, boolean defaultValue) {
        if (s == null || s.isEmpty()) {
            return defaultValue;
        }
        if ("true".equalsIgnoreCase(s)) {
            return true;
        }
        if ("false".equalsIgnoreCase(s)) {
            return false;
        }
        return defaultValue;
    }

    public static String stringifyException(Throwable e) {
        StringWriter stm = new StringWriter();
        PrintWriter wrt = new PrintWriter(stm);
        e.printStackTrace(wrt);
        wrt.close();
        return stm.toString();
    }

    public static Object stringSupplierAsObject(final Supplier<String> supplier) {
        return new Object(){

            public String toString() {
                return (String)supplier.get();
            }
        };
    }

    public static <K, V> String map2String(Map<K, V> map) {
        if (map == null) {
            return null;
        }
        if (map.isEmpty()) {
            return "<EMPTY_MAP>";
        }
        StringBuilder b = new StringBuilder("{");
        map.entrySet().stream().forEach(e -> b.append("\n  ").append(e.getKey()).append(" -> ").append(e.getValue()));
        return b.append("\n}").toString();
    }
}

