/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.io.Closeable;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.LongFunction;
import org.apache.ratis.util.CollectionUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface SlidingWindow {
    public static final Logger LOG = LoggerFactory.getLogger(SlidingWindow.class);

    public static class Server<REQUEST extends Request<REPLY>, REPLY>
    implements Closeable {
        private final RequestMap<REQUEST, REPLY> requests;
        private final REQUEST end;
        private long nextToProcess = -1L;

        public Server(Object name, REQUEST end) {
            this.requests = new RequestMap(name);
            this.end = end;
            Preconditions.assertTrue(end.getSeqNum() == Long.MAX_VALUE);
        }

        public synchronized String toString() {
            return this.requests + ", nextToProcess=" + this.nextToProcess;
        }

        public synchronized void receivedRequest(REQUEST request, Consumer<REQUEST> processingMethod) {
            long seqNum = request.getSeqNum();
            if (this.nextToProcess == -1L) {
                this.nextToProcess = seqNum;
                LOG.debug("{}: got seq={} (first request), set nextToProcess in {}", new Object[]{this.requests.getName(), seqNum, this});
            } else {
                LOG.debug("{}: got seq={} in {}", new Object[]{this.requests.getName(), seqNum, this});
            }
            this.requests.putNewRequest(request);
            this.processRequestsFromHead(processingMethod);
        }

        private void processRequestsFromHead(Consumer<REQUEST> processingMethod) {
            for (Request r : this.requests) {
                if (r.getSeqNum() != this.nextToProcess) {
                    return;
                }
                processingMethod.accept(r);
                ++this.nextToProcess;
            }
        }

        public synchronized void receiveReply(long seqNum, REPLY reply, Consumer<REQUEST> replyMethod, Consumer<REQUEST> processingMethod) {
            if (!this.requests.setReply(seqNum, reply, "receiveReply")) {
                return;
            }
            this.sendRepliesFromHead(replyMethod);
            this.processRequestsFromHead(processingMethod);
        }

        private void sendRepliesFromHead(Consumer<REQUEST> replyMethod) {
            Iterator<REQUEST> i = this.requests.iterator();
            while (i.hasNext()) {
                Request r = (Request)i.next();
                if (!r.hasReply()) {
                    return;
                }
                replyMethod.accept(r);
                if (r == this.end) {
                    return;
                }
                i.remove();
            }
        }

        public synchronized boolean endOfRequests() {
            if (this.requests.isEmpty()) {
                return true;
            }
            LOG.debug("{}: put end-of-request in {}", this.requests.getName(), (Object)this);
            this.requests.putNewRequest(this.end);
            return false;
        }

        @Override
        public void close() {
            this.requests.clear();
        }
    }

    public static class Client<REQUEST extends Request<REPLY>, REPLY> {
        private final RequestMap<REQUEST, REPLY> requests;
        private final SortedMap<Long, Long> delayedRequests = new TreeMap<Long, Long>();
        private long nextSeqNum = 0L;
        private long firstSeqNum = -1L;
        private boolean firstReplied;

        public Client(Object name) {
            this.requests = new RequestMap<REQUEST, REPLY>(name){

                @Override
                synchronized void log() {
                    LOG.debug(this.toString());
                    for (Request r : requests) {
                        LOG.debug("  {}: {}", (Object)r.getSeqNum(), (Object)(r.hasReply() ? "replied" : (delayedRequests.containsKey(r.getSeqNum()) ? "delayed" : "submitted")));
                    }
                }
            };
        }

        public synchronized String toString() {
            return this.requests + ", nextSeqNum=" + this.nextSeqNum + ", firstSubmitted=" + this.firstSeqNum + ", replied? " + this.firstReplied + ", delayed=" + this.delayedRequests.keySet();
        }

        public synchronized REQUEST submitNewRequest(LongFunction<REQUEST> requestConstructor, Consumer<REQUEST> sendMethod) {
            if (!this.requests.isEmpty()) {
                Preconditions.assertTrue(this.nextSeqNum == this.requests.lastSeqNum() + 1L, () -> "nextSeqNum=" + this.nextSeqNum + " but " + this);
            }
            long seqNum = this.nextSeqNum++;
            Request r = (Request)requestConstructor.apply(seqNum);
            this.requests.putNewRequest(r);
            boolean submitted = this.sendOrDelayRequest(r, sendMethod);
            LOG.debug("{}: submitting a new request {} in {}? {}", new Object[]{this.requests.getName(), r, this, submitted ? "submitted" : "delayed"});
            return (REQUEST)r;
        }

        private boolean sendOrDelayRequest(REQUEST request, Consumer<REQUEST> sendMethod) {
            long seqNum = request.getSeqNum();
            Preconditions.assertTrue(this.requests.getNonRepliedRequest(seqNum, "sendOrDelayRequest") == request);
            if (this.firstReplied) {
                sendMethod.accept(request);
                return true;
            }
            if (this.firstSeqNum == -1L && seqNum == this.requests.firstSeqNum()) {
                LOG.debug("{}: detect firstSubmitted {} in {}", new Object[]{this.requests.getName(), request, this});
                this.firstSeqNum = seqNum;
                sendMethod.accept(request);
                return true;
            }
            CollectionUtils.putNew(seqNum, seqNum, this.delayedRequests, () -> this.requests.getName() + ":delayedRequests");
            return false;
        }

        public synchronized void retry(REQUEST request, Consumer<REQUEST> sendMethod) {
            if (this.requests.getNonRepliedRequest(request.getSeqNum(), "retry") != request) {
                LOG.debug("{}: Ignore retry {} in {}", new Object[]{this.requests.getName(), request, this});
                return;
            }
            boolean submitted = this.sendOrDelayRequest(request, sendMethod);
            LOG.debug("{}: submitting a retry {} in {}? {}", new Object[]{this.requests.getName(), request, this, submitted ? "submitted" : "delayed"});
        }

        private void removeRepliedFromHead() {
            Iterator<REQUEST> i = this.requests.iterator();
            while (i.hasNext()) {
                Request r = (Request)i.next();
                if (!r.hasReply()) {
                    return;
                }
                i.remove();
            }
        }

        public synchronized void receiveReply(long seqNum, REPLY reply, Consumer<REQUEST> sendMethod) {
            if (!this.requests.setReply(seqNum, reply, "receiveReply")) {
                return;
            }
            if (seqNum == this.firstSeqNum) {
                this.firstReplied = true;
            }
            this.removeRepliedFromHead();
            this.trySendDelayed(sendMethod);
        }

        private void trySendDelayed(Consumer<REQUEST> sendMethod) {
            if (this.firstReplied) {
                if (!this.delayedRequests.isEmpty()) {
                    for (Long seqNum : this.delayedRequests.keySet()) {
                        sendMethod.accept(this.requests.getNonRepliedRequest(seqNum, "trySendDelayed"));
                    }
                    this.delayedRequests.clear();
                }
            } else {
                Request r;
                Long delayed;
                Iterator<REQUEST> i = this.requests.iterator();
                if (i.hasNext() && (delayed = (Long)this.delayedRequests.remove((r = (Request)i.next()).getSeqNum())) != null) {
                    this.sendOrDelayRequest(r, sendMethod);
                }
            }
        }

        public synchronized void resetFirstSeqNum() {
            this.firstSeqNum = -1L;
            this.firstReplied = false;
            LOG.debug("After resetFirstSeqNum: {}", (Object)this);
        }
    }

    public static class RequestMap<REQUEST extends Request<REPLY>, REPLY>
    implements Iterable<REQUEST> {
        static boolean LOG_REPEATEDLY = false;
        private final Object name;
        private final SortedMap<Long, REQUEST> requests = new TreeMap<Long, REQUEST>();

        RequestMap(Object name) {
            this.name = name;
            if (LOG_REPEATEDLY && LOG.isDebugEnabled()) {
                JavaUtils.runRepeatedly(() -> this.log(), 5L, 10L, TimeUnit.SECONDS);
            }
        }

        Object getName() {
            return this.name;
        }

        boolean isEmpty() {
            return this.requests.isEmpty();
        }

        REQUEST getNonRepliedRequest(long seqNum, String op) {
            Request request = (Request)this.requests.get(seqNum);
            if (request == null) {
                LOG.debug("{}: {}, seq={} not found in {}", new Object[]{this.getName(), op, seqNum, this});
                return null;
            }
            if (request.hasReply()) {
                LOG.debug("{}: {}, seq={} already has replied in {}", new Object[]{this.getName(), op, seqNum, this});
                return null;
            }
            return (REQUEST)request;
        }

        long firstSeqNum() {
            return this.requests.firstKey();
        }

        long lastSeqNum() {
            return this.requests.lastKey();
        }

        @Override
        public Iterator<REQUEST> iterator() {
            return this.requests.values().iterator();
        }

        void putNewRequest(REQUEST request) {
            long seqNum = request.getSeqNum();
            CollectionUtils.putNew(seqNum, request, this.requests, () -> this.getName() + ":requests");
        }

        boolean setReply(long seqNum, REPLY reply, String op) {
            REQUEST request = this.getNonRepliedRequest(seqNum, op);
            if (request == null) {
                LOG.debug("{}: DUPLICATED reply {} for seq={} in {}", new Object[]{this.getName(), reply, seqNum, this});
                return false;
            }
            LOG.debug("{}: set reply {} for seq={} in {}", new Object[]{this.getName(), reply, seqNum, this});
            request.setReply(reply);
            return true;
        }

        synchronized void clear() {
            LOG.debug("close {}", (Object)this);
            this.requests.clear();
        }

        synchronized void log() {
            LOG.debug(this.toString());
            for (Request r : this.requests.values()) {
                LOG.debug("  {}: hasReply? {}", (Object)r.getSeqNum(), (Object)r.hasReply());
            }
        }

        public String toString() {
            return this.getName() + ": requests" + RequestMap.asString(this.requests);
        }

        private static String asString(SortedMap<Long, ?> map) {
            return map.isEmpty() ? "[]" : "[" + map.firstKey() + ".." + map.lastKey() + "]";
        }
    }

    public static interface Request<REPLY> {
        public long getSeqNum();

        public void setReply(REPLY var1);

        public boolean hasReply();
    }
}

