/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ratis.util.CheckedRunnable;
import org.apache.ratis.util.CheckedSupplier;
import org.apache.ratis.util.MemoizedSupplier;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface JavaUtils {
    public static final Logger LOG = LoggerFactory.getLogger(JavaUtils.class);
    public static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss,SSS");
    public static final CompletableFuture[] EMPTY_COMPLETABLE_FUTURE_ARRAY = new CompletableFuture[0];
    public static final Supplier<ThreadGroup> ROOT_THREAD_GROUP = JavaUtils.memoize(() -> {
        ThreadGroup g = Thread.currentThread().getThreadGroup();
        ThreadGroup p;
        while ((p = g.getParent()) != null) {
            g = p;
        }
        return g;
    });

    public static String date() {
        return DATE_FORMAT.format(new Date());
    }

    public static <T> T cast(Object obj, Class<T> clazz) {
        return clazz.isInstance(obj) ? (T)clazz.cast(obj) : null;
    }

    public static <T> T cast(Object obj) {
        Object t = obj;
        return (T)t;
    }

    public static <T> T callAsUnchecked(Callable<T> callable) {
        return (T)JavaUtils.callAsUnchecked(callable::call, RuntimeException::new);
    }

    public static <OUTPUT, THROWABLE extends Throwable> OUTPUT callAsUnchecked(CheckedSupplier<OUTPUT, THROWABLE> checkedSupplier, Function<THROWABLE, ? extends RuntimeException> converter) {
        try {
            return checkedSupplier.get();
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            Throwable casted = t;
            throw converter.apply(casted);
        }
    }

    public static <T> MemoizedSupplier<T> memoize(Supplier<T> initializer) {
        return MemoizedSupplier.valueOf(initializer);
    }

    public static ThreadGroup getRootThreadGroup() {
        return ROOT_THREAD_GROUP.get();
    }

    @Deprecated
    public static <RETURN, THROWABLE extends Throwable> RETURN attempt(CheckedSupplier<RETURN, THROWABLE> supplier, int numAttempts, long sleepMs, String name, Logger log) throws THROWABLE, InterruptedException {
        return JavaUtils.attempt(supplier, numAttempts, TimeDuration.valueOf(sleepMs, TimeUnit.MILLISECONDS), name, log);
    }

    public static <RETURN, THROWABLE extends Throwable> RETURN attempt(CheckedSupplier<RETURN, THROWABLE> supplier, int numAttempts, TimeDuration sleepTime, String name, Logger log) throws THROWABLE, InterruptedException {
        Objects.requireNonNull(supplier, "supplier == null");
        Preconditions.assertTrue(numAttempts > 0, () -> "numAttempts = " + numAttempts + " <= 0");
        Preconditions.assertTrue(!sleepTime.isNegative(), () -> "sleepTime = " + sleepTime + " < 0");
        for (int i = 1; i <= numAttempts; ++i) {
            try {
                return supplier.get();
            }
            catch (Throwable t) {
                if (i == numAttempts) {
                    throw t;
                }
                if (log != null && log.isWarnEnabled()) {
                    log.warn("FAILED \"" + name + "\", attempt #" + i + "/" + numAttempts + ": " + t + ", sleep " + sleepTime + " and then retry.", t);
                }
                sleepTime.sleep();
                continue;
            }
        }
        throw new IllegalStateException("BUG: this line should be unreachable.");
    }

    @Deprecated
    public static <THROWABLE extends Throwable> void attempt(CheckedRunnable<THROWABLE> op, int numAttempts, long sleepMs, String name, Logger log) throws THROWABLE, InterruptedException {
        JavaUtils.attempt(op, numAttempts, TimeDuration.valueOf(sleepMs, TimeUnit.MILLISECONDS), name, log);
    }

    public static <THROWABLE extends Throwable> void attempt(CheckedRunnable<THROWABLE> runnable, int numAttempts, TimeDuration sleepTime, String name, Logger log) throws THROWABLE, InterruptedException {
        JavaUtils.attempt(CheckedRunnable.asCheckedSupplier(runnable), numAttempts, sleepTime, name, log);
    }

    @Deprecated
    public static void attempt(BooleanSupplier condition, int numAttempts, long sleepMs, String name, Logger log) throws InterruptedException {
        JavaUtils.attempt(condition, numAttempts, TimeDuration.valueOf(sleepMs, TimeUnit.MILLISECONDS), name, log);
    }

    public static void attempt(BooleanSupplier condition, int numAttempts, TimeDuration sleepTime, String name, Logger log) throws InterruptedException {
        Objects.requireNonNull(condition, "condition == null");
        Preconditions.assertTrue(numAttempts > 0, () -> "numAttempts = " + numAttempts + " <= 0");
        Preconditions.assertTrue(!sleepTime.isNegative(), () -> "sleepTime = " + sleepTime + " < 0");
        for (int i = 1; i <= numAttempts; ++i) {
            if (condition.getAsBoolean()) {
                return;
            }
            if (log != null && log.isWarnEnabled()) {
                log.warn("FAILED " + name + " attempt #" + i + "/" + numAttempts + ": sleep " + sleepTime + " and then retry.");
            }
            sleepTime.sleep();
        }
        if (!condition.getAsBoolean()) {
            throw new IllegalStateException("Failed " + name + " for " + numAttempts + " attempts.");
        }
    }

    public static Timer runRepeatedly(final Runnable runnable, long delay, long period, TimeUnit unit) {
        Timer timer = new Timer(true);
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                runnable.run();
            }
        }, unit.toMillis(delay), unit.toMillis(period));
        return timer;
    }

    public static void dumpAllThreads(Consumer<String> println) {
        ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
        for (ThreadInfo ti : threadMxBean.dumpAllThreads(true, true)) {
            println.accept(ti.toString());
        }
    }

    public static <E> CompletableFuture<E> completeExceptionally(Throwable t) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(t);
        return future;
    }

    public static Throwable unwrapCompletionException(Throwable t) {
        Objects.requireNonNull(t, "t == null");
        return t instanceof CompletionException && t.getCause() != null ? t.getCause() : t;
    }

    public static <T> CompletableFuture<Void> allOf(List<CompletableFuture<T>> futures) {
        return CompletableFuture.allOf(futures.toArray(EMPTY_COMPLETABLE_FUTURE_ARRAY));
    }

    public static <OUTPUT, THROWABLE extends Throwable> OUTPUT supplyAndWrapAsCompletionException(CheckedSupplier<OUTPUT, THROWABLE> supplier) {
        try {
            return supplier.get();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new CompletionException(t);
        }
    }
}

