/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import org.apache.ratis.util.LogUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface FileUtils {
    public static final Logger LOG = LoggerFactory.getLogger(FileUtils.class);

    public static void truncateFile(File f, long target) throws IOException {
        long original = f.length();
        LogUtils.runAndLog(LOG, () -> {
            try (FileOutputStream out = new FileOutputStream(f, true);){
                out.getChannel().truncate(target);
            }
        }, () -> "FileOutputStream.getChannel().truncate " + f + " length: " + original + " -> " + target);
    }

    public static OutputStream createNewFile(Path p) throws IOException {
        return LogUtils.supplyAndLog(LOG, () -> Files.newOutputStream(p, StandardOpenOption.CREATE_NEW), () -> "Files.newOutputStream " + StandardOpenOption.CREATE_NEW + " " + p);
    }

    public static void createDirectories(File dir) throws IOException {
        FileUtils.createDirectories(dir.toPath());
    }

    public static void createDirectories(Path dir) throws IOException {
        LogUtils.runAndLog(LOG, () -> Files.createDirectories(dir, new FileAttribute[0]), () -> "Files.createDirectories " + dir);
    }

    public static void move(File src, File dst) throws IOException {
        FileUtils.move(src.toPath(), dst.toPath());
    }

    public static void move(Path src, Path dst) throws IOException {
        LogUtils.runAndLog(LOG, () -> Files.move(src, dst, new CopyOption[0]), () -> "Files.move " + src + " to " + dst);
    }

    public static void deleteFile(File f) throws IOException {
        FileUtils.delete(f.toPath());
    }

    public static void delete(Path p) throws IOException {
        LogUtils.runAndLog(LOG, () -> Files.delete(p), () -> "Files.delete " + p);
    }

    public static void deleteFully(File f) throws IOException {
        LOG.trace("deleteFully {}", (Object)f);
        FileUtils.deleteFully(f.toPath());
    }

    public static void deleteFully(Path p) throws IOException {
        if (!Files.exists(p, LinkOption.NOFOLLOW_LINKS)) {
            LOG.trace("deleteFully: {} does not exist.", (Object)p);
            return;
        }
        Files.walkFileTree(p, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                FileUtils.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                if (e != null) {
                    throw e;
                }
                FileUtils.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

