/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;

public class AutoCloseableLock
implements AutoCloseable {
    private final Lock underlying;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public static AutoCloseableLock acquire(Lock lock) {
        lock.lock();
        return new AutoCloseableLock(lock);
    }

    private AutoCloseableLock(Lock underlying) {
        this.underlying = underlying;
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.underlying.unlock();
        }
    }
}

