/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.retry;

import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.util.TimeDuration;

public interface RetryPolicies {
    public static RetryPolicy retryForeverNoSleep() {
        return Constants.RETRY_FOREVER_NO_SLEEP;
    }

    public static RetryPolicy noRetry() {
        return Constants.NO_RETRY;
    }

    public static RetryPolicy retryUpToMaximumCountWithFixedSleep(int maxRetries, TimeDuration sleepTime) {
        return new RetryLimited(maxRetries, sleepTime);
    }

    public static class RetryLimited
    implements RetryPolicy {
        private final int maxRetries;
        private final TimeDuration sleepTime;
        private String myString;

        RetryLimited(int maxRetries, TimeDuration sleepTime) {
            if (maxRetries < 0) {
                throw new IllegalArgumentException("maxRetries = " + maxRetries + " < 0");
            }
            if (sleepTime.isNegative()) {
                throw new IllegalArgumentException("sleepTime = " + sleepTime.getDuration() + " < 0");
            }
            this.maxRetries = maxRetries;
            this.sleepTime = sleepTime;
        }

        @Override
        public TimeDuration getSleepTime() {
            return this.sleepTime;
        }

        public int getMaxRetries() {
            return this.maxRetries;
        }

        @Override
        public boolean shouldRetry(int retryCount) {
            return retryCount < this.maxRetries;
        }

        public String toString() {
            if (this.myString == null) {
                this.myString = this.getClass().getSimpleName() + "(maxRetries=" + this.maxRetries + ", sleepTime=" + this.sleepTime + ")";
            }
            return this.myString;
        }
    }

    public static class NoRetry
    implements RetryPolicy {
        private NoRetry() {
        }

        @Override
        public boolean shouldRetry(int retryCount) {
            return false;
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    public static class RetryForeverNoSleep
    implements RetryPolicy {
        private RetryForeverNoSleep() {
        }

        @Override
        public boolean shouldRetry(int retryCount) {
            return true;
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    public static class Constants {
        private static final RetryForeverNoSleep RETRY_FOREVER_NO_SLEEP = new RetryForeverNoSleep();
        private static final NoRetry NO_RETRY = new NoRetry();
    }
}

