/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.conf;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.ratis.util.ReflectionUtils;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.StringUtils;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class RaftProperties {
    private static final Logger LOG = LoggerFactory.getLogger(RaftProperties.class);
    private ArrayList<Resource> resources = new ArrayList();
    static final String UNKNOWN_RESOURCE = "Unknown";
    private Set<String> finalParameters = Collections.newSetFromMap(new ConcurrentHashMap());
    private boolean loadDefaults = true;
    private static final WeakHashMap<RaftProperties, Object> REGISTRY = new WeakHashMap();
    private static final CopyOnWriteArrayList<String> defaultResources = new CopyOnWriteArrayList();
    private Map<String, String[]> updatingResource;
    private Properties properties;
    private Properties overlay;
    private static final int MAX_SUBST = 20;
    private static final int SUB_START_IDX = 0;
    private static final int SUB_END_IDX = 1;

    public RaftProperties() {
        this(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RaftProperties(boolean loadDefaults) {
        this.loadDefaults = loadDefaults;
        this.updatingResource = new ConcurrentHashMap<String, String[]>();
        Class<RaftProperties> clazz = RaftProperties.class;
        synchronized (RaftProperties.class) {
            REGISTRY.put(this, null);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RaftProperties(RaftProperties other) {
        this.resources = (ArrayList)other.resources.clone();
        Object object = other;
        synchronized (object) {
            if (other.properties != null) {
                this.properties = (Properties)other.properties.clone();
            }
            if (other.overlay != null) {
                this.overlay = (Properties)other.overlay.clone();
            }
            this.updatingResource = new ConcurrentHashMap<String, String[]>(other.updatingResource);
            this.finalParameters = Collections.newSetFromMap(new ConcurrentHashMap());
            this.finalParameters.addAll(other.finalParameters);
        }
        object = RaftProperties.class;
        synchronized (RaftProperties.class) {
            REGISTRY.put(this, null);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.loadDefaults = other.loadDefaults;
            return;
        }
    }

    public static synchronized void addDefaultResource(String name) {
        if (!defaultResources.contains(name)) {
            defaultResources.add(name);
            REGISTRY.keySet().stream().filter(conf -> conf.loadDefaults).forEach(RaftProperties::reloadConfiguration);
        }
    }

    public void addResource(String name) {
        this.addResourceObject(new Resource(name));
    }

    public void addResource(InputStream in) {
        this.addResourceObject(new Resource(in));
    }

    public void addResource(InputStream in, String name) {
        this.addResourceObject(new Resource(in, name));
    }

    public void addResource(RaftProperties conf) {
        this.addResourceObject(new Resource(conf.getProps()));
    }

    public synchronized void reloadConfiguration() {
        this.properties = null;
        this.finalParameters.clear();
    }

    private synchronized void addResourceObject(Resource resource) {
        this.resources.add(resource);
        this.reloadConfiguration();
    }

    private static int[] findSubVariable(String eval) {
        int[] result = new int[]{-1, -1};
        int matchStart = 1;
        int leftBrace = eval.indexOf(123, matchStart);
        block4: while (leftBrace > 0 && leftBrace + "{c".length() < eval.length()) {
            block8: {
                int matchedLen = 0;
                if (eval.charAt(leftBrace - 1) == '$') {
                    int subStart;
                    int i = subStart = leftBrace + 1;
                    while (i < eval.length()) {
                        switch (eval.charAt(i)) {
                            case '}': {
                                if (matchedLen > 0) {
                                    result[0] = subStart;
                                    result[1] = subStart + matchedLen;
                                    break block4;
                                }
                            }
                            case ' ': 
                            case '$': {
                                matchStart = i + 1;
                                break block8;
                            }
                            default: {
                                ++matchedLen;
                                ++i;
                                break;
                            }
                        }
                    }
                    break;
                }
                matchStart = leftBrace + 1;
            }
            leftBrace = eval.indexOf(123, matchStart);
        }
        return result;
    }

    private String substituteVars(String expr) {
        if (expr == null) {
            return null;
        }
        String eval = expr;
        HashSet<String> evalSet = null;
        for (int s = 0; s < 20; ++s) {
            int[] varBounds = RaftProperties.findSubVariable(eval);
            if (varBounds[0] == -1) {
                return eval;
            }
            String var = eval.substring(varBounds[0], varBounds[1]);
            String val = null;
            try {
                if (var.startsWith("env.") && 4 < var.length()) {
                    int i;
                    String v = var.substring(4);
                    for (i = 0; i < v.length(); ++i) {
                        char c = v.charAt(i);
                        if (c == ':' && i < v.length() - 1 && v.charAt(i + 1) == '-') {
                            val = this.getenv(v.substring(0, i));
                            if (val != null && val.length() != 0) break;
                            val = v.substring(i + 2);
                            break;
                        }
                        if (c != '-') continue;
                        val = this.getenv(v.substring(0, i));
                        if (val != null) break;
                        val = v.substring(i + 1);
                        break;
                    }
                    if (i == v.length()) {
                        val = this.getenv(v);
                    }
                } else {
                    val = this.getProperty(var);
                }
            }
            catch (SecurityException se) {
                LOG.warn("Unexpected SecurityException in Configuration", (Throwable)se);
            }
            if (val == null) {
                val = this.getRaw(var);
            }
            if (val == null) {
                return eval;
            }
            int dollar = varBounds[0] - "${".length();
            int afterRightBrace = varBounds[1] + "}".length();
            String refVar = eval.substring(dollar, afterRightBrace);
            if (evalSet == null) {
                evalSet = new HashSet<String>();
            }
            if (!evalSet.add(refVar)) {
                return expr;
            }
            eval = eval.substring(0, dollar) + val + eval.substring(afterRightBrace);
        }
        throw new IllegalStateException("Variable substitution depth too large: 20 " + expr);
    }

    String getenv(String name) {
        return System.getenv(name);
    }

    String getProperty(String key) {
        return System.getProperty(key);
    }

    public String get(String name) {
        return this.substituteVars(this.getRaw(name));
    }

    public String getTrimmed(String name) {
        String value = this.get(name);
        if (null == value) {
            return null;
        }
        return value.trim();
    }

    public String getTrimmed(String name, String defaultValue) {
        String ret = this.getTrimmed(name);
        return ret == null ? defaultValue : ret;
    }

    public String getRaw(String name) {
        return this.getProps().getProperty(name.trim());
    }

    public void set(String name, String value) {
        String trimmed = Objects.requireNonNull(name, "Property name must be non-null.");
        Objects.requireNonNull(value, () -> "The value of property " + trimmed + " must be non-null.");
        name = trimmed;
        this.getProps();
        this.getOverlay().setProperty(name, value);
        this.getProps().setProperty(name, value);
    }

    public synchronized void unset(String name) {
        this.getOverlay().remove(name);
        this.getProps().remove(name);
    }

    public synchronized void setIfUnset(String name, String value) {
        if (this.get(name) == null) {
            this.set(name, value);
        }
    }

    private synchronized Properties getOverlay() {
        if (this.overlay == null) {
            this.overlay = new Properties();
        }
        return this.overlay;
    }

    public String get(String name, String defaultValue) {
        return this.substituteVars(this.getProps().getProperty(name, defaultValue));
    }

    public int getInt(String name, int defaultValue) {
        String valueString = this.getTrimmed(name);
        if (valueString == null) {
            return defaultValue;
        }
        String hexString = this.getHexDigits(valueString);
        if (hexString != null) {
            return Integer.parseInt(hexString, 16);
        }
        return Integer.parseInt(valueString);
    }

    public int[] getInts(String name) {
        String[] strings = this.getTrimmedStrings(name);
        int[] ints = new int[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            ints[i] = Integer.parseInt(strings[i]);
        }
        return ints;
    }

    public void setInt(String name, int value) {
        this.set(name, Integer.toString(value));
    }

    public long getLong(String name, long defaultValue) {
        String valueString = this.getTrimmed(name);
        if (valueString == null) {
            return defaultValue;
        }
        String hexString = this.getHexDigits(valueString);
        if (hexString != null) {
            return Long.parseLong(hexString, 16);
        }
        return Long.parseLong(valueString);
    }

    public File getFile(String name, File defaultValue) {
        String valueString = this.getTrimmed(name);
        return valueString == null ? defaultValue : new File(valueString);
    }

    public List<File> getFiles(String name, List<File> defaultValue) {
        String valueString = this.getRaw(name);
        if (null == valueString) {
            return defaultValue;
        }
        String[] paths = this.getTrimmedStrings(name);
        return Arrays.stream(paths).map(File::new).collect(Collectors.toList());
    }

    public void setFile(String name, File value) {
        try {
            this.set(name, value.getCanonicalPath());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to get canonical path from file " + value + " for " + name, e);
        }
    }

    public void setFiles(String name, List<File> value) {
        String paths = value.stream().map(File::getAbsolutePath).collect(Collectors.joining(","));
        this.set(name, paths);
    }

    public SizeInBytes getSizeInBytes(String name, SizeInBytes defaultValue) {
        String valueString = this.getTrimmed(name);
        return valueString == null ? defaultValue : SizeInBytes.valueOf(valueString);
    }

    private String getHexDigits(String value) {
        boolean negative = false;
        String str = value;
        if (value.startsWith("-")) {
            negative = true;
            str = value.substring(1);
        }
        if (str.startsWith("0x") || str.startsWith("0X")) {
            String hexString = str.substring(2);
            if (negative) {
                hexString = "-" + hexString;
            }
            return hexString;
        }
        return null;
    }

    public void setLong(String name, long value) {
        this.set(name, Long.toString(value));
    }

    public float getFloat(String name, float defaultValue) {
        String valueString = this.getTrimmed(name);
        if (valueString == null) {
            return defaultValue;
        }
        return Float.parseFloat(valueString);
    }

    public void setFloat(String name, float value) {
        this.set(name, Float.toString(value));
    }

    public double getDouble(String name, double defaultValue) {
        String valueString = this.getTrimmed(name);
        if (valueString == null) {
            return defaultValue;
        }
        return Double.parseDouble(valueString);
    }

    public void setDouble(String name, double value) {
        this.set(name, Double.toString(value));
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        String valueString = this.getTrimmed(name);
        return StringUtils.string2boolean(valueString, defaultValue);
    }

    public void setBoolean(String name, boolean value) {
        this.set(name, Boolean.toString(value));
    }

    public void setBooleanIfUnset(String name, boolean value) {
        this.setIfUnset(name, Boolean.toString(value));
    }

    public <T extends Enum<T>> void setEnum(String name, T value) {
        this.set(name, value.toString());
    }

    public <T extends Enum<T>> T getEnum(String name, T defaultValue) {
        String val = this.getTrimmed(name);
        return null == val ? defaultValue : Enum.valueOf(defaultValue.getDeclaringClass(), val);
    }

    public void setTimeDuration(String name, TimeDuration value) {
        this.set(name, value.toString());
    }

    public TimeDuration getTimeDuration(String name, TimeDuration defaultValue, TimeUnit defaultUnit) {
        String value = this.getTrimmed(name);
        if (null == value) {
            return defaultValue;
        }
        try {
            return TimeDuration.valueOf(value, defaultUnit);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Failed to parse " + name + " = " + value, e);
        }
    }

    public BiFunction<String, TimeDuration, TimeDuration> getTimeDuration(TimeUnit defaultUnit) {
        return (key, defaultValue) -> this.getTimeDuration((String)key, (TimeDuration)defaultValue, defaultUnit);
    }

    public Pattern getPattern(String name, Pattern defaultValue) {
        String valString = this.get(name);
        if (null == valString || valString.isEmpty()) {
            return defaultValue;
        }
        try {
            return Pattern.compile(valString);
        }
        catch (PatternSyntaxException pse) {
            LOG.warn("Regular expression '" + valString + "' for property '" + name + "' not valid. Using default", (Throwable)pse);
            return defaultValue;
        }
    }

    public void setPattern(String name, Pattern pattern) {
        assert (pattern != null) : "Pattern cannot be null";
        this.set(name, pattern.pattern());
    }

    public IntegerRanges getRange(String name, String defaultValue) {
        return new IntegerRanges(this.get(name, defaultValue));
    }

    public String[] getTrimmedStrings(String name) {
        String valueString = this.get(name);
        return StringUtils.getTrimmedStrings(valueString);
    }

    public Class<?>[] getClasses(String name, Class<?> ... defaultValue) {
        String valueString = this.getRaw(name);
        if (null == valueString) {
            return defaultValue;
        }
        String[] classnames = this.getTrimmedStrings(name);
        try {
            Class[] classes = new Class[classnames.length];
            for (int i = 0; i < classnames.length; ++i) {
                classes[i] = ReflectionUtils.getClassByName(classnames[i]);
            }
            return classes;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public Class<?> getClass(String name, Class<?> defaultValue) {
        String valueString = this.getTrimmed(name);
        if (valueString == null) {
            return defaultValue;
        }
        try {
            return ReflectionUtils.getClassByName(valueString);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public <BASE> Class<? extends BASE> getClass(String name, Class<? extends BASE> defaultValue, Class<BASE> xface) {
        try {
            Class<?> theClass = this.getClass(name, defaultValue);
            if (theClass != null && !xface.isAssignableFrom(theClass)) {
                throw new RuntimeException(theClass + " not " + xface.getName());
            }
            if (theClass != null) {
                return theClass.asSubclass(xface);
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setClass(String name, Class<?> theClass, Class<?> xface) {
        if (!xface.isAssignableFrom(theClass)) {
            throw new RuntimeException(theClass + " not " + xface.getName());
        }
        this.set(name, theClass.getName());
    }

    protected synchronized Properties getProps() {
        if (this.properties == null) {
            this.properties = new Properties();
            ConcurrentHashMap<String, String[]> backup = new ConcurrentHashMap<String, String[]>(this.updatingResource);
            this.loadResources(this.properties, this.resources);
            if (this.overlay != null) {
                this.properties.putAll((Map<?, ?>)this.overlay);
                for (Map.Entry<Object, Object> item : this.overlay.entrySet()) {
                    String key = (String)item.getKey();
                    String[] source = (String[])backup.get(key);
                    if (source == null) continue;
                    this.updatingResource.put(key, source);
                }
            }
        }
        return this.properties;
    }

    public int size() {
        return this.getProps().size();
    }

    public void clear() {
        this.getProps().clear();
        this.getOverlay().clear();
    }

    private Document parse(DocumentBuilder builder, URL url) throws IOException, SAXException {
        LOG.debug("parsing URL " + url);
        if (url == null) {
            return null;
        }
        URLConnection connection = url.openConnection();
        if (connection instanceof JarURLConnection) {
            connection.setUseCaches(false);
        }
        return this.parse(builder, connection.getInputStream(), url.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document parse(DocumentBuilder builder, InputStream is, String systemId) throws IOException, SAXException {
        LOG.debug("parsing input stream " + is);
        if (is == null) {
            return null;
        }
        try {
            Document document = systemId == null ? builder.parse(is) : builder.parse(is, systemId);
            return document;
        }
        finally {
            is.close();
        }
    }

    private void loadResources(Properties properties, ArrayList<Resource> resources) {
        if (this.loadDefaults) {
            for (String resource : defaultResources) {
                this.loadResource(properties, new Resource(resource));
            }
        }
        for (int i = 0; i < resources.size(); ++i) {
            Resource ret = this.loadResource(properties, resources.get(i));
            if (ret == null) continue;
            resources.set(i, ret);
        }
    }

    private Resource loadResource(Properties properties, Resource wrapper) {
        String name = UNKNOWN_RESOURCE;
        try {
            Object resource = wrapper.getResource();
            name = wrapper.getName();
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setIgnoringComments(true);
            docBuilderFactory.setNamespaceAware(true);
            try {
                docBuilderFactory.setXIncludeAware(true);
            }
            catch (UnsupportedOperationException e) {
                LOG.error("Failed to set setXIncludeAware(true) for parser " + docBuilderFactory + ":" + e, (Throwable)e);
            }
            DocumentBuilder builder = docBuilderFactory.newDocumentBuilder();
            Document doc = null;
            Element root = null;
            boolean returnCachedProperties = false;
            if (resource instanceof URL) {
                doc = this.parse(builder, (URL)resource);
            } else if (resource instanceof String) {
                URL url = ReflectionUtils.getClassLoader().getResource((String)resource);
                doc = this.parse(builder, url);
            } else if (resource instanceof InputStream) {
                doc = this.parse(builder, (InputStream)resource, null);
                returnCachedProperties = true;
            } else if (resource instanceof Properties) {
                this.overlay(properties, (Properties)resource);
            } else if (resource instanceof Element) {
                root = (Element)resource;
            }
            if (root == null) {
                if (doc == null) {
                    return null;
                }
                root = doc.getDocumentElement();
            }
            Properties toAddTo = properties;
            if (returnCachedProperties) {
                toAddTo = new Properties();
            }
            if (!"configuration".equals(root.getTagName())) {
                LOG.error("bad conf file: top-level element not <configuration>");
            }
            NodeList props = root.getChildNodes();
            for (int i = 0; i < props.getLength(); ++i) {
                Node propNode = props.item(i);
                if (!(propNode instanceof Element)) continue;
                Element prop = (Element)propNode;
                if ("configuration".equals(prop.getTagName())) {
                    this.loadResource(toAddTo, new Resource(prop, name));
                    continue;
                }
                if (!"property".equals(prop.getTagName())) {
                    LOG.warn("bad conf file: element not <property>");
                }
                String attr = null;
                String value = null;
                boolean finalParameter = false;
                LinkedList<String> source = new LinkedList<String>();
                Attr propAttr = prop.getAttributeNode("name");
                if (propAttr != null) {
                    attr = StringUtils.weakIntern(propAttr.getValue());
                }
                if ((propAttr = prop.getAttributeNode("value")) != null) {
                    value = StringUtils.weakIntern(propAttr.getValue());
                }
                if ((propAttr = prop.getAttributeNode("final")) != null) {
                    finalParameter = "true".equals(propAttr.getValue());
                }
                if ((propAttr = prop.getAttributeNode("source")) != null) {
                    source.add(StringUtils.weakIntern(propAttr.getValue()));
                }
                NodeList fields = prop.getChildNodes();
                for (int j = 0; j < fields.getLength(); ++j) {
                    Node fieldNode = fields.item(j);
                    if (!(fieldNode instanceof Element)) continue;
                    Element field = (Element)fieldNode;
                    if ("name".equals(field.getTagName()) && field.hasChildNodes()) {
                        attr = StringUtils.weakIntern(((Text)field.getFirstChild()).getData().trim());
                    }
                    if ("value".equals(field.getTagName()) && field.hasChildNodes()) {
                        value = StringUtils.weakIntern(((Text)field.getFirstChild()).getData());
                    }
                    if ("final".equals(field.getTagName()) && field.hasChildNodes()) {
                        finalParameter = "true".equals(((Text)field.getFirstChild()).getData());
                    }
                    if (!"source".equals(field.getTagName()) || !field.hasChildNodes()) continue;
                    source.add(StringUtils.weakIntern(((Text)field.getFirstChild()).getData()));
                }
                source.add(name);
                if (attr == null) continue;
                this.loadProperty(toAddTo, name, attr, value, finalParameter, source.toArray(new String[source.size()]));
            }
            if (returnCachedProperties) {
                this.overlay(properties, toAddTo);
                return new Resource(toAddTo, name);
            }
            return null;
        }
        catch (IOException | ParserConfigurationException | DOMException | SAXException e) {
            LOG.error("error parsing conf " + name, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void overlay(Properties to, Properties from) {
        for (Map.Entry<Object, Object> entry : from.entrySet()) {
            to.put(entry.getKey(), entry.getValue());
        }
    }

    private void loadProperty(Properties properties, String name, String attr, String value, boolean finalParameter, String[] source) {
        if (value != null) {
            if (!this.finalParameters.contains(attr)) {
                properties.setProperty(attr, value);
                if (source != null) {
                    this.updatingResource.put(attr, source);
                }
            } else if (!value.equals(properties.getProperty(attr))) {
                LOG.warn(name + ":an attempt to override final parameter: " + attr + ";  Ignoring.");
            }
        }
        if (finalParameter && attr != null) {
            this.finalParameters.add(attr);
        }
    }

    public void writeXml(OutputStream out) throws IOException {
        this.writeXml(new OutputStreamWriter(out, "UTF-8"));
    }

    public void writeXml(Writer out) throws IOException {
        Document doc = this.asXmlDocument();
        try {
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(out);
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            transformer.transform(source, result);
        }
        catch (TransformerException te) {
            throw new IOException(te);
        }
    }

    private synchronized Document asXmlDocument() throws IOException {
        Document doc;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException pe) {
            throw new IOException(pe);
        }
        Element conf = doc.createElement("configuration");
        doc.appendChild(conf);
        conf.appendChild(doc.createTextNode("\n"));
        Enumeration<Object> e = this.properties.keys();
        while (e.hasMoreElements()) {
            String[] sources;
            String name = (String)e.nextElement();
            Object object = this.properties.get(name);
            if (!(object instanceof String)) continue;
            String value = (String)object;
            Element propNode = doc.createElement("property");
            conf.appendChild(propNode);
            Element nameNode = doc.createElement("name");
            nameNode.appendChild(doc.createTextNode(name));
            propNode.appendChild(nameNode);
            Element valueNode = doc.createElement("value");
            valueNode.appendChild(doc.createTextNode(value));
            propNode.appendChild(valueNode);
            if (this.updatingResource != null && (sources = this.updatingResource.get(name)) != null) {
                for (String s : sources) {
                    Element sourceNode = doc.createElement("source");
                    sourceNode.appendChild(doc.createTextNode(s));
                    propNode.appendChild(sourceNode);
                }
            }
            conf.appendChild(doc.createTextNode("\n"));
        }
        return doc;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Configuration: ");
        if (this.loadDefaults) {
            this.toString(defaultResources, sb);
            if (this.resources.size() > 0) {
                sb.append(", ");
            }
        }
        this.toString(this.resources, sb);
        return sb.toString();
    }

    private <T> void toString(List<T> resources, StringBuilder sb) {
        ListIterator<T> i = resources.listIterator();
        while (i.hasNext()) {
            if (i.nextIndex() != 0) {
                sb.append(", ");
            }
            sb.append(i.next());
        }
    }

    public Map<String, String> getValByRegex(String regex) {
        Pattern p = Pattern.compile(regex);
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<Object, Object> item : this.getProps().entrySet()) {
            Matcher m;
            if (!(item.getKey() instanceof String) || !(item.getValue() instanceof String) || !(m = p.matcher((String)item.getKey())).find()) continue;
            result.put((String)item.getKey(), this.substituteVars(this.getProps().getProperty((String)item.getKey())));
        }
        return result;
    }

    public static class IntegerRanges
    implements Iterable<Integer> {
        List<Range> ranges = new ArrayList<Range>();

        public IntegerRanges() {
        }

        public IntegerRanges(String newValue) {
            StringTokenizer itr = new StringTokenizer(newValue, ",");
            while (itr.hasMoreTokens()) {
                String rng = itr.nextToken().trim();
                String[] parts = rng.split("-", 3);
                if (parts.length < 1 || parts.length > 2) {
                    throw new IllegalArgumentException("integer range badly formed: " + rng);
                }
                Range r = new Range();
                r.start = IntegerRanges.convertToInt(parts[0], 0);
                r.end = parts.length == 2 ? IntegerRanges.convertToInt(parts[1], Integer.MAX_VALUE) : r.start;
                if (r.start > r.end) {
                    throw new IllegalArgumentException("IntegerRange from " + r.start + " to " + r.end + " is invalid");
                }
                this.ranges.add(r);
            }
        }

        private static int convertToInt(String value, int defaultValue) {
            String trim = value.trim();
            if (trim.length() == 0) {
                return defaultValue;
            }
            return Integer.parseInt(trim);
        }

        public boolean isIncluded(int value) {
            for (Range r : this.ranges) {
                if (r.start > value || value > r.end) continue;
                return true;
            }
            return false;
        }

        public boolean isEmpty() {
            return this.ranges == null || this.ranges.isEmpty();
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            boolean first = true;
            for (Range r : this.ranges) {
                if (first) {
                    first = false;
                } else {
                    result.append(',');
                }
                result.append(r.start);
                result.append('-');
                result.append(r.end);
            }
            return result.toString();
        }

        @Override
        public Iterator<Integer> iterator() {
            return new RangeNumberIterator(this.ranges);
        }

        private static class RangeNumberIterator
        implements Iterator<Integer> {
            Iterator<Range> internal;
            int at;
            int end;

            public RangeNumberIterator(List<Range> ranges) {
                if (ranges != null) {
                    this.internal = ranges.iterator();
                }
                this.at = -1;
                this.end = -2;
            }

            @Override
            public boolean hasNext() {
                if (this.at <= this.end) {
                    return true;
                }
                if (this.internal != null) {
                    return this.internal.hasNext();
                }
                return false;
            }

            @Override
            public Integer next() {
                Range found;
                if (this.at <= this.end) {
                    ++this.at;
                    return this.at - 1;
                }
                if (this.internal != null && (found = this.internal.next()) != null) {
                    this.at = found.start;
                    this.end = found.end;
                    ++this.at;
                    return this.at - 1;
                }
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }

        private static class Range {
            int start;
            int end;

            private Range() {
            }
        }
    }

    private static class Resource {
        private final Object resource;
        private final String name;

        public Resource(Object resource) {
            this(resource, resource.toString());
        }

        public Resource(Object resource, String name) {
            this.resource = resource;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public Object getResource() {
            return this.resource;
        }

        public String toString() {
            return this.name;
        }
    }
}

