/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.response;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.ozone.web.handlers.BucketArgs;
import org.apache.hadoop.ozone.web.handlers.ListArgs;
import org.apache.hadoop.ozone.web.response.KeyInfo;
import org.apache.hadoop.ozone.web.utils.JsonUtils;

public class ListKeys {
    static final String OBJECT_LIST = "OBJECT_LIST_FILTER";
    private static final ObjectReader READER = new ObjectMapper().readerFor(ListKeys.class);
    private static final ObjectWriter WRITER;
    private String name;
    private String prefix;
    private long maxKeys;
    private boolean truncated;
    private List<KeyInfo> keyList;

    public ListKeys() {
        this.keyList = new LinkedList<KeyInfo>();
    }

    public ListKeys(ListArgs args, boolean truncated) {
        Preconditions.checkState((boolean)(args.getArgs() instanceof BucketArgs));
        this.name = ((BucketArgs)args.getArgs()).getBucketName();
        this.prefix = args.getPrefix();
        this.maxKeys = args.getMaxKeys();
        this.truncated = truncated;
    }

    public static ListKeys parse(String jsonString) throws IOException {
        return (ListKeys)READER.readValue(jsonString);
    }

    public List<KeyInfo> getKeyList() {
        return this.keyList;
    }

    public void setKeyList(List<KeyInfo> objectList) {
        this.keyList = objectList;
    }

    public long getMaxKeys() {
        return this.maxKeys;
    }

    public String getName() {
        return this.name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean isTruncated() {
        return this.truncated;
    }

    public void setTruncated(boolean value) {
        this.truncated = value;
    }

    public String toJsonString() throws IOException {
        return WRITER.writeValueAsString((Object)this);
    }

    public String toDBString() throws IOException {
        return JsonUtils.toJsonString((Object)this);
    }

    public void sort() {
        Collections.sort(this.keyList);
    }

    public void addKey(KeyInfo keyInfo) {
        this.keyList.add(keyInfo);
    }

    static {
        ObjectMapper mapper = new ObjectMapper();
        String[] ignorableFieldNames = new String[]{"dataFileName"};
        SimpleFilterProvider filters = new SimpleFilterProvider().addFilter(OBJECT_LIST, SimpleBeanPropertyFilter.serializeAllExcept((String[])ignorableFieldNames));
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.addMixIn(Object.class, MixIn.class);
        mapper.setFilterProvider((FilterProvider)filters);
        WRITER = mapper.writerWithDefaultPrettyPrinter();
    }

    @JsonFilter(value="OBJECT_LIST_FILTER")
    class MixIn {
        MixIn() {
        }
    }
}

