/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.response;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.ozone.web.response.BucketInfo;
import org.apache.hadoop.ozone.web.utils.JsonUtils;

public class ListBuckets {
    static final String BUCKET_LIST = "BUCKET_LIST_FILTER";
    private static final ObjectReader READER = new ObjectMapper().readerFor(ListBuckets.class);
    private static final ObjectWriter WRITER;
    private List<BucketInfo> buckets;

    public ListBuckets(List<BucketInfo> buckets) {
        this.buckets = buckets;
    }

    public ListBuckets() {
        this.buckets = new LinkedList<BucketInfo>();
    }

    public static ListBuckets parse(String data) throws IOException {
        return (ListBuckets)READER.readValue(data);
    }

    public List<BucketInfo> getBuckets() {
        return this.buckets;
    }

    public void setBuckets(List<BucketInfo> buckets) {
        this.buckets = buckets;
    }

    public String toJsonString() throws IOException {
        return WRITER.writeValueAsString((Object)this);
    }

    public String toDBString() throws IOException {
        return JsonUtils.toJsonString((Object)this);
    }

    public void sort() {
        Collections.sort(this.buckets);
    }

    public void addBucket(BucketInfo bucketInfo) {
        this.buckets.add(bucketInfo);
    }

    static {
        ObjectMapper mapper = new ObjectMapper();
        String[] ignorableFieldNames = new String[]{"dataFileName"};
        SimpleFilterProvider filters = new SimpleFilterProvider().addFilter(BUCKET_LIST, SimpleBeanPropertyFilter.serializeAllExcept((String[])ignorableFieldNames));
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.addMixIn(Object.class, MixIn.class);
        mapper.setFilterProvider((FilterProvider)filters);
        WRITER = mapper.writerWithDefaultPrettyPrinter();
    }

    @JsonFilter(value="BUCKET_LIST_FILTER")
    class MixIn {
        MixIn() {
        }
    }
}

