/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.protocolPB;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.ipc.ProtobufHelper;
import org.apache.hadoop.ipc.ProtocolTranslator;
import org.apache.hadoop.ozone.om.helpers.OmBucketArgs;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyArgs;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.helpers.OpenKeySession;
import org.apache.hadoop.ozone.om.helpers.ServiceInfo;
import org.apache.hadoop.ozone.om.protocol.OzoneManagerProtocol;
import org.apache.hadoop.ozone.om.protocolPB.OzoneManagerProtocolPB;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

@InterfaceAudience.Private
public final class OzoneManagerProtocolClientSideTranslatorPB
implements OzoneManagerProtocol,
ProtocolTranslator,
Closeable {
    private static final RpcController NULL_RPC_CONTROLLER = null;
    private final OzoneManagerProtocolPB rpcProxy;

    public OzoneManagerProtocolClientSideTranslatorPB(OzoneManagerProtocolPB rpcProxy) {
        this.rpcProxy = rpcProxy;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void createVolume(OmVolumeArgs args) throws IOException {
        OzoneManagerProtocolProtos.CreateVolumeResponse resp;
        OzoneManagerProtocolProtos.CreateVolumeRequest.Builder req = OzoneManagerProtocolProtos.CreateVolumeRequest.newBuilder();
        OzoneManagerProtocolProtos.VolumeInfo volumeInfo = args.getProtobuf();
        req.setVolumeInfo(volumeInfo);
        try {
            resp = this.rpcProxy.createVolume(NULL_RPC_CONTROLLER, req.build());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
        if (resp.getStatus() != OzoneManagerProtocolProtos.Status.OK) {
            throw new IOException("Volume creation failed, error:" + (Object)((Object)resp.getStatus()));
        }
    }

    @Override
    public void setOwner(String volume, String owner) throws IOException {
        OzoneManagerProtocolProtos.SetVolumePropertyResponse resp;
        OzoneManagerProtocolProtos.SetVolumePropertyRequest.Builder req = OzoneManagerProtocolProtos.SetVolumePropertyRequest.newBuilder();
        req.setVolumeName(volume).setOwnerName(owner);
        try {
            resp = this.rpcProxy.setVolumeProperty(NULL_RPC_CONTROLLER, req.build());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
        if (resp.getStatus() != OzoneManagerProtocolProtos.Status.OK) {
            throw new IOException("Volume owner change failed, error:" + (Object)((Object)resp.getStatus()));
        }
    }

    @Override
    public void setQuota(String volume, long quota) throws IOException {
        OzoneManagerProtocolProtos.SetVolumePropertyResponse resp;
        OzoneManagerProtocolProtos.SetVolumePropertyRequest.Builder req = OzoneManagerProtocolProtos.SetVolumePropertyRequest.newBuilder();
        req.setVolumeName(volume).setQuotaInBytes(quota);
        try {
            resp = this.rpcProxy.setVolumeProperty(NULL_RPC_CONTROLLER, req.build());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
        if (resp.getStatus() != OzoneManagerProtocolProtos.Status.OK) {
            throw new IOException("Volume quota change failed, error:" + (Object)((Object)resp.getStatus()));
        }
    }

    @Override
    public boolean checkVolumeAccess(String volume, OzoneManagerProtocolProtos.OzoneAclInfo userAcl) throws IOException {
        OzoneManagerProtocolProtos.CheckVolumeAccessResponse resp;
        OzoneManagerProtocolProtos.CheckVolumeAccessRequest.Builder req = OzoneManagerProtocolProtos.CheckVolumeAccessRequest.newBuilder();
        req.setVolumeName(volume).setUserAcl(userAcl);
        try {
            resp = this.rpcProxy.checkVolumeAccess(NULL_RPC_CONTROLLER, req.build());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
        if (resp.getStatus() == OzoneManagerProtocolProtos.Status.ACCESS_DENIED) {
            return false;
        }
        if (resp.getStatus() == OzoneManagerProtocolProtos.Status.OK) {
            return true;
        }
        throw new IOException("Check Volume Access failed, error:" + (Object)((Object)resp.getStatus()));
    }

    @Override
    public OmVolumeArgs getVolumeInfo(String volume) throws IOException {
        OzoneManagerProtocolProtos.InfoVolumeResponse resp;
        OzoneManagerProtocolProtos.InfoVolumeRequest.Builder req = OzoneManagerProtocolProtos.InfoVolumeRequest.newBuilder();
        req.setVolumeName(volume);
        try {
            resp = this.rpcProxy.infoVolume(NULL_RPC_CONTROLLER, req.build());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
        if (resp.getStatus() != OzoneManagerProtocolProtos.Status.OK) {
            throw new IOException("Info Volume failed, error:" + (Object)((Object)resp.getStatus()));
        }
        return OmVolumeArgs.getFromProtobuf(resp.getVolumeInfo());
    }

    @Override
    public void deleteVolume(String volume) throws IOException {
        OzoneManagerProtocolProtos.DeleteVolumeResponse resp;
        OzoneManagerProtocolProtos.DeleteVolumeRequest.Builder req = OzoneManagerProtocolProtos.DeleteVolumeRequest.newBuilder();
        req.setVolumeName(volume);
        try {
            resp = this.rpcProxy.deleteVolume(NULL_RPC_CONTROLLER, req.build());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
        if (resp.getStatus() != OzoneManagerProtocolProtos.Status.OK) {
            throw new IOException("Delete Volume failed, error:" + (Object)((Object)resp.getStatus()));
        }
    }

    @Override
    public List<OmVolumeArgs> listVolumeByUser(String userName, String prefix, String prevKey, int maxKeys) throws IOException {
        OzoneManagerProtocolProtos.ListVolumeRequest.Builder builder = OzoneManagerProtocolProtos.ListVolumeRequest.newBuilder();
        if (!Strings.isNullOrEmpty((String)prefix)) {
            builder.setPrefix(prefix);
        }
        if (!Strings.isNullOrEmpty((String)prevKey)) {
            builder.setPrevKey(prevKey);
        }
        builder.setMaxKeys(maxKeys);
        builder.setUserName(userName);
        builder.setScope(OzoneManagerProtocolProtos.ListVolumeRequest.Scope.VOLUMES_BY_USER);
        return this.listVolume(builder.build());
    }

    @Override
    public List<OmVolumeArgs> listAllVolumes(String prefix, String prevKey, int maxKeys) throws IOException {
        OzoneManagerProtocolProtos.ListVolumeRequest.Builder builder = OzoneManagerProtocolProtos.ListVolumeRequest.newBuilder();
        if (!Strings.isNullOrEmpty((String)prefix)) {
            builder.setPrefix(prefix);
        }
        if (!Strings.isNullOrEmpty((String)prevKey)) {
            builder.setPrevKey(prevKey);
        }
        builder.setMaxKeys(maxKeys);
        builder.setScope(OzoneManagerProtocolProtos.ListVolumeRequest.Scope.VOLUMES_BY_CLUSTER);
        return this.listVolume(builder.build());
    }

    private List<OmVolumeArgs> listVolume(OzoneManagerProtocolProtos.ListVolumeRequest request) throws IOException {
        OzoneManagerProtocolProtos.ListVolumeResponse resp;
        try {
            resp = this.rpcProxy.listVolumes(NULL_RPC_CONTROLLER, request);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
        if (resp.getStatus() != OzoneManagerProtocolProtos.Status.OK) {
            throw new IOException("List volume failed, error: " + (Object)((Object)resp.getStatus()));
        }
        ArrayList result = Lists.newArrayList();
        for (OzoneManagerProtocolProtos.VolumeInfo volInfo : resp.getVolumeInfoList()) {
            OmVolumeArgs volArgs = OmVolumeArgs.getFromProtobuf(volInfo);
            result.add(volArgs);
        }
        return resp.getVolumeInfoList().stream().map(item -> OmVolumeArgs.getFromProtobuf(item)).collect(Collectors.toList());
    }

    @Override
    public void createBucket(OmBucketInfo bucketInfo) throws IOException {
        OzoneManagerProtocolProtos.CreateBucketResponse resp;
        OzoneManagerProtocolProtos.CreateBucketRequest.Builder req = OzoneManagerProtocolProtos.CreateBucketRequest.newBuilder();
        OzoneManagerProtocolProtos.BucketInfo bucketInfoProtobuf = bucketInfo.getProtobuf();
        req.setBucketInfo(bucketInfoProtobuf);
        try {
            resp = this.rpcProxy.createBucket(NULL_RPC_CONTROLLER, req.build());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
        if (resp.getStatus() != OzoneManagerProtocolProtos.Status.OK) {
            throw new IOException("Bucket creation failed, error: " + (Object)((Object)resp.getStatus()));
        }
    }

    @Override
    public OmBucketInfo getBucketInfo(String volume, String bucket) throws IOException {
        OzoneManagerProtocolProtos.InfoBucketResponse resp;
        OzoneManagerProtocolProtos.InfoBucketRequest.Builder req = OzoneManagerProtocolProtos.InfoBucketRequest.newBuilder();
        req.setVolumeName(volume);
        req.setBucketName(bucket);
        try {
            resp = this.rpcProxy.infoBucket(NULL_RPC_CONTROLLER, req.build());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
        if (resp.getStatus() == OzoneManagerProtocolProtos.Status.OK) {
            return OmBucketInfo.getFromProtobuf(resp.getBucketInfo());
        }
        throw new IOException("Info Bucket failed, error: " + (Object)((Object)resp.getStatus()));
    }

    @Override
    public void setBucketProperty(OmBucketArgs args) throws IOException {
        OzoneManagerProtocolProtos.SetBucketPropertyResponse resp;
        OzoneManagerProtocolProtos.SetBucketPropertyRequest.Builder req = OzoneManagerProtocolProtos.SetBucketPropertyRequest.newBuilder();
        OzoneManagerProtocolProtos.BucketArgs bucketArgs = args.getProtobuf();
        req.setBucketArgs(bucketArgs);
        try {
            resp = this.rpcProxy.setBucketProperty(NULL_RPC_CONTROLLER, req.build());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
        if (resp.getStatus() != OzoneManagerProtocolProtos.Status.OK) {
            throw new IOException("Setting bucket property failed, error: " + (Object)((Object)resp.getStatus()));
        }
    }

    @Override
    public List<OmBucketInfo> listBuckets(String volumeName, String startKey, String prefix, int count) throws IOException {
        OzoneManagerProtocolProtos.ListBucketsResponse resp;
        ArrayList<OmBucketInfo> buckets = new ArrayList<OmBucketInfo>();
        OzoneManagerProtocolProtos.ListBucketsRequest.Builder reqBuilder = OzoneManagerProtocolProtos.ListBucketsRequest.newBuilder();
        reqBuilder.setVolumeName(volumeName);
        reqBuilder.setCount(count);
        if (startKey != null) {
            reqBuilder.setStartKey(startKey);
        }
        if (prefix != null) {
            reqBuilder.setPrefix(prefix);
        }
        OzoneManagerProtocolProtos.ListBucketsRequest request = reqBuilder.build();
        try {
            resp = this.rpcProxy.listBuckets(NULL_RPC_CONTROLLER, request);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
        if (resp.getStatus() == OzoneManagerProtocolProtos.Status.OK) {
            buckets.addAll(resp.getBucketInfoList().stream().map(OmBucketInfo::getFromProtobuf).collect(Collectors.toList()));
            return buckets;
        }
        throw new IOException("List Buckets failed, error: " + (Object)((Object)resp.getStatus()));
    }

    @Override
    public OpenKeySession openKey(OmKeyArgs args) throws IOException {
        OzoneManagerProtocolProtos.LocateKeyResponse resp;
        OzoneManagerProtocolProtos.LocateKeyRequest.Builder req = OzoneManagerProtocolProtos.LocateKeyRequest.newBuilder();
        OzoneManagerProtocolProtos.KeyArgs.Builder keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(args.getVolumeName()).setBucketName(args.getBucketName()).setFactor(args.getFactor()).setType(args.getType()).setKeyName(args.getKeyName());
        if (args.getDataSize() > 0L) {
            keyArgs.setDataSize(args.getDataSize());
        }
        req.setKeyArgs(keyArgs.build());
        try {
            resp = this.rpcProxy.createKey(NULL_RPC_CONTROLLER, req.build());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
        if (resp.getStatus() != OzoneManagerProtocolProtos.Status.OK) {
            throw new IOException("Create key failed, error:" + (Object)((Object)resp.getStatus()));
        }
        return new OpenKeySession(resp.getID(), OmKeyInfo.getFromProtobuf(resp.getKeyInfo()), resp.getOpenVersion());
    }

    @Override
    public OmKeyLocationInfo allocateBlock(OmKeyArgs args, long clientID) throws IOException {
        OzoneManagerProtocolProtos.AllocateBlockResponse resp;
        OzoneManagerProtocolProtos.AllocateBlockRequest.Builder req = OzoneManagerProtocolProtos.AllocateBlockRequest.newBuilder();
        OzoneManagerProtocolProtos.KeyArgs keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(args.getVolumeName()).setBucketName(args.getBucketName()).setKeyName(args.getKeyName()).setDataSize(args.getDataSize()).build();
        req.setKeyArgs(keyArgs);
        req.setClientID(clientID);
        try {
            resp = this.rpcProxy.allocateBlock(NULL_RPC_CONTROLLER, req.build());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
        if (resp.getStatus() != OzoneManagerProtocolProtos.Status.OK) {
            throw new IOException("Allocate block failed, error:" + (Object)((Object)resp.getStatus()));
        }
        return OmKeyLocationInfo.getFromProtobuf(resp.getKeyLocation());
    }

    @Override
    public void commitKey(OmKeyArgs args, long clientID) throws IOException {
        OzoneManagerProtocolProtos.CommitKeyResponse resp;
        OzoneManagerProtocolProtos.CommitKeyRequest.Builder req = OzoneManagerProtocolProtos.CommitKeyRequest.newBuilder();
        List<OmKeyLocationInfo> locationInfoList = args.getLocationInfoList();
        Preconditions.checkNotNull(locationInfoList);
        OzoneManagerProtocolProtos.KeyArgs keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(args.getVolumeName()).setBucketName(args.getBucketName()).setKeyName(args.getKeyName()).setDataSize(args.getDataSize()).addAllKeyLocations(locationInfoList.stream().map(OmKeyLocationInfo::getProtobuf).collect(Collectors.toList())).build();
        req.setKeyArgs(keyArgs);
        req.setClientID(clientID);
        try {
            resp = this.rpcProxy.commitKey(NULL_RPC_CONTROLLER, req.build());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
        if (resp.getStatus() != OzoneManagerProtocolProtos.Status.OK) {
            throw new IOException("Commit key failed, error:" + (Object)((Object)resp.getStatus()));
        }
    }

    @Override
    public OmKeyInfo lookupKey(OmKeyArgs args) throws IOException {
        OzoneManagerProtocolProtos.LocateKeyResponse resp;
        OzoneManagerProtocolProtos.LocateKeyRequest.Builder req = OzoneManagerProtocolProtos.LocateKeyRequest.newBuilder();
        OzoneManagerProtocolProtos.KeyArgs keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(args.getVolumeName()).setBucketName(args.getBucketName()).setKeyName(args.getKeyName()).setDataSize(args.getDataSize()).build();
        req.setKeyArgs(keyArgs);
        try {
            resp = this.rpcProxy.lookupKey(NULL_RPC_CONTROLLER, req.build());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
        if (resp.getStatus() != OzoneManagerProtocolProtos.Status.OK) {
            throw new IOException("Lookup key failed, error:" + (Object)((Object)resp.getStatus()));
        }
        return OmKeyInfo.getFromProtobuf(resp.getKeyInfo());
    }

    @Override
    public void renameKey(OmKeyArgs args, String toKeyName) throws IOException {
        OzoneManagerProtocolProtos.RenameKeyResponse resp;
        OzoneManagerProtocolProtos.RenameKeyRequest.Builder req = OzoneManagerProtocolProtos.RenameKeyRequest.newBuilder();
        OzoneManagerProtocolProtos.KeyArgs keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(args.getVolumeName()).setBucketName(args.getBucketName()).setKeyName(args.getKeyName()).setDataSize(args.getDataSize()).build();
        req.setKeyArgs(keyArgs);
        req.setToKeyName(toKeyName);
        try {
            resp = this.rpcProxy.renameKey(NULL_RPC_CONTROLLER, req.build());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
        if (resp.getStatus() != OzoneManagerProtocolProtos.Status.OK) {
            throw new IOException("Rename key failed, error:" + (Object)((Object)resp.getStatus()));
        }
    }

    @Override
    public void deleteKey(OmKeyArgs args) throws IOException {
        OzoneManagerProtocolProtos.LocateKeyResponse resp;
        OzoneManagerProtocolProtos.LocateKeyRequest.Builder req = OzoneManagerProtocolProtos.LocateKeyRequest.newBuilder();
        OzoneManagerProtocolProtos.KeyArgs keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(args.getVolumeName()).setBucketName(args.getBucketName()).setKeyName(args.getKeyName()).build();
        req.setKeyArgs(keyArgs);
        try {
            resp = this.rpcProxy.deleteKey(NULL_RPC_CONTROLLER, req.build());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
        if (resp.getStatus() != OzoneManagerProtocolProtos.Status.OK) {
            throw new IOException("Delete key failed, error:" + (Object)((Object)resp.getStatus()));
        }
    }

    @Override
    public void deleteBucket(String volume, String bucket) throws IOException {
        OzoneManagerProtocolProtos.DeleteBucketResponse resp;
        OzoneManagerProtocolProtos.DeleteBucketRequest.Builder req = OzoneManagerProtocolProtos.DeleteBucketRequest.newBuilder();
        req.setVolumeName(volume);
        req.setBucketName(bucket);
        try {
            resp = this.rpcProxy.deleteBucket(NULL_RPC_CONTROLLER, req.build());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
        if (resp.getStatus() != OzoneManagerProtocolProtos.Status.OK) {
            throw new IOException("Delete Bucket failed, error:" + (Object)((Object)resp.getStatus()));
        }
    }

    @Override
    public List<OmKeyInfo> listKeys(String volumeName, String bucketName, String startKey, String prefix, int maxKeys) throws IOException {
        OzoneManagerProtocolProtos.ListKeysResponse resp;
        ArrayList<OmKeyInfo> keys = new ArrayList<OmKeyInfo>();
        OzoneManagerProtocolProtos.ListKeysRequest.Builder reqBuilder = OzoneManagerProtocolProtos.ListKeysRequest.newBuilder();
        reqBuilder.setVolumeName(volumeName);
        reqBuilder.setBucketName(bucketName);
        reqBuilder.setCount(maxKeys);
        if (startKey != null) {
            reqBuilder.setStartKey(startKey);
        }
        if (prefix != null) {
            reqBuilder.setPrefix(prefix);
        }
        OzoneManagerProtocolProtos.ListKeysRequest request = reqBuilder.build();
        try {
            resp = this.rpcProxy.listKeys(NULL_RPC_CONTROLLER, request);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
        if (resp.getStatus() == OzoneManagerProtocolProtos.Status.OK) {
            keys.addAll(resp.getKeyInfoList().stream().map(OmKeyInfo::getFromProtobuf).collect(Collectors.toList()));
            return keys;
        }
        throw new IOException("List Keys failed, error: " + (Object)((Object)resp.getStatus()));
    }

    @Override
    public List<ServiceInfo> getServiceList() throws IOException {
        OzoneManagerProtocolProtos.ServiceListResponse resp;
        OzoneManagerProtocolProtos.ServiceListRequest request = OzoneManagerProtocolProtos.ServiceListRequest.newBuilder().build();
        try {
            resp = this.rpcProxy.getServiceList(NULL_RPC_CONTROLLER, request);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
        if (resp.getStatus() == OzoneManagerProtocolProtos.Status.OK) {
            return resp.getServiceInfoList().stream().map(ServiceInfo::getFromProtobuf).collect(Collectors.toList());
        }
        throw new IOException("Getting service list failed, error: " + (Object)((Object)resp.getStatus()));
    }

    @Override
    public void createS3Bucket(String userName, String s3BucketName) throws IOException {
        OzoneManagerProtocolProtos.S3BucketResponse resp;
        OzoneManagerProtocolProtos.S3BucketRequest request = OzoneManagerProtocolProtos.S3BucketRequest.newBuilder().setUserName(userName).setS3Bucketname(s3BucketName).build();
        try {
            resp = this.rpcProxy.createS3Bucket(NULL_RPC_CONTROLLER, request);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
        if (resp.getStatus() != OzoneManagerProtocolProtos.Status.OK) {
            throw new IOException("Creating S3 bucket failed, error: " + (Object)((Object)resp.getStatus()));
        }
    }

    @Override
    public void deleteS3Bucket(String s3BucketName) throws IOException {
        OzoneManagerProtocolProtos.S3DeleteBucketResponse resp;
        OzoneManagerProtocolProtos.S3DeleteBucketRequest request = OzoneManagerProtocolProtos.S3DeleteBucketRequest.newBuilder().setS3BucketName(s3BucketName).build();
        try {
            resp = this.rpcProxy.deleteS3Bucket(NULL_RPC_CONTROLLER, request);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
        if (resp.getStatus() != OzoneManagerProtocolProtos.Status.OK) {
            throw new IOException("Creating S3 bucket failed, error: " + (Object)((Object)resp.getStatus()));
        }
    }

    @Override
    public String getOzoneBucketMapping(String s3BucketName) throws IOException {
        OzoneManagerProtocolProtos.S3BucketInfoResponse resp;
        OzoneManagerProtocolProtos.S3BucketInfoRequest request = OzoneManagerProtocolProtos.S3BucketInfoRequest.newBuilder().setS3BucketName(s3BucketName).build();
        try {
            resp = this.rpcProxy.getS3Bucketinfo(NULL_RPC_CONTROLLER, request);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
        if (resp.getStatus() != OzoneManagerProtocolProtos.Status.OK) {
            throw new IOException("GetOzoneBucketMapping failed, error:" + (Object)((Object)resp.getStatus()));
        }
        return resp.getOzoneMapping();
    }

    public Object getUnderlyingProxyObject() {
        return null;
    }
}

