/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.ozone.audit.Auditable;
import org.apache.hadoop.ozone.om.helpers.OmOzoneAclMap;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public final class OmVolumeArgs
implements Auditable {
    private final String adminName;
    private final String ownerName;
    private final String volume;
    private final long creationTime;
    private final long quotaInBytes;
    private final Map<String, String> keyValueMap;
    private final OmOzoneAclMap aclMap;

    private OmVolumeArgs(String adminName, String ownerName, String volume, long quotaInBytes, Map<String, String> keyValueMap, OmOzoneAclMap aclMap, long creationTime) {
        this.adminName = adminName;
        this.ownerName = ownerName;
        this.volume = volume;
        this.quotaInBytes = quotaInBytes;
        this.keyValueMap = keyValueMap;
        this.aclMap = aclMap;
        this.creationTime = creationTime;
    }

    public String getAdminName() {
        return this.adminName;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public String getVolume() {
        return this.volume;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getQuotaInBytes() {
        return this.quotaInBytes;
    }

    public Map<String, String> getKeyValueMap() {
        return this.keyValueMap;
    }

    public OmOzoneAclMap getAclMap() {
        return this.aclMap;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Map<String, String> toAuditMap() {
        LinkedHashMap<String, String> auditMap = new LinkedHashMap<String, String>();
        auditMap.put("admin", this.adminName);
        auditMap.put("owner", this.ownerName);
        auditMap.put("volume", this.volume);
        auditMap.put("creationTime", String.valueOf(this.creationTime));
        auditMap.put("quotaInBytes", String.valueOf(this.quotaInBytes));
        return auditMap;
    }

    public OzoneManagerProtocolProtos.VolumeInfo getProtobuf() {
        LinkedList<HddsProtos.KeyValue> metadataList = new LinkedList<HddsProtos.KeyValue>();
        for (Map.Entry<String, String> entry : this.keyValueMap.entrySet()) {
            metadataList.add(HddsProtos.KeyValue.newBuilder().setKey(entry.getKey()).setValue(entry.getValue()).build());
        }
        List<OzoneManagerProtocolProtos.OzoneAclInfo> aclList = this.aclMap.ozoneAclGetProtobuf();
        return OzoneManagerProtocolProtos.VolumeInfo.newBuilder().setAdminName(this.adminName).setOwnerName(this.ownerName).setVolume(this.volume).setQuotaInBytes(this.quotaInBytes).addAllMetadata(metadataList).addAllVolumeAcls(aclList).setCreationTime(this.creationTime).build();
    }

    public static OmVolumeArgs getFromProtobuf(OzoneManagerProtocolProtos.VolumeInfo volInfo) {
        Map<String, String> kvMap = volInfo.getMetadataList().stream().collect(Collectors.toMap(HddsProtos.KeyValue::getKey, HddsProtos.KeyValue::getValue));
        OmOzoneAclMap aclMap = OmOzoneAclMap.ozoneAclGetFromProtobuf(volInfo.getVolumeAclsList());
        return new OmVolumeArgs(volInfo.getAdminName(), volInfo.getOwnerName(), volInfo.getVolume(), volInfo.getQuotaInBytes(), kvMap, aclMap, volInfo.getCreationTime());
    }

    public static class Builder {
        private String adminName;
        private String ownerName;
        private String volume;
        private long creationTime;
        private long quotaInBytes;
        private Map<String, String> keyValueMap = new HashMap<String, String>();
        private OmOzoneAclMap aclMap = new OmOzoneAclMap();

        public Builder setAdminName(String admin) {
            this.adminName = admin;
            return this;
        }

        public Builder setOwnerName(String owner) {
            this.ownerName = owner;
            return this;
        }

        public Builder setVolume(String volumeName) {
            this.volume = volumeName;
            return this;
        }

        public Builder setCreationTime(long createdOn) {
            this.creationTime = createdOn;
            return this;
        }

        public Builder setQuotaInBytes(long quota) {
            this.quotaInBytes = quota;
            return this;
        }

        public Builder addMetadata(String key, String value) {
            this.keyValueMap.put(key, value);
            return this;
        }

        public Builder addOzoneAcls(OzoneManagerProtocolProtos.OzoneAclInfo acl) throws IOException {
            this.aclMap.addAcl(acl);
            return this;
        }

        public OmVolumeArgs build() {
            Preconditions.checkNotNull((Object)this.adminName);
            Preconditions.checkNotNull((Object)this.ownerName);
            Preconditions.checkNotNull((Object)this.volume);
            return new OmVolumeArgs(this.adminName, this.ownerName, this.volume, this.quotaInBytes, this.keyValueMap, this.aclMap, this.creationTime);
        }
    }
}

