/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.util.Time;

public final class OmKeyInfo {
    private final String volumeName;
    private final String bucketName;
    private String keyName;
    private long dataSize;
    private List<OmKeyLocationInfoGroup> keyLocationVersions;
    private final long creationTime;
    private long modificationTime;
    private HddsProtos.ReplicationType type;
    private HddsProtos.ReplicationFactor factor;

    private OmKeyInfo(String volumeName, String bucketName, String keyName, List<OmKeyLocationInfoGroup> versions, long dataSize, long creationTime, long modificationTime, HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor) {
        this.volumeName = volumeName;
        this.bucketName = bucketName;
        this.keyName = keyName;
        this.dataSize = dataSize;
        long currentVersion = -1L;
        for (OmKeyLocationInfoGroup version : versions) {
            Preconditions.checkArgument((currentVersion + 1L == version.getVersion() ? 1 : 0) != 0);
            currentVersion = version.getVersion();
        }
        this.keyLocationVersions = versions;
        this.creationTime = creationTime;
        this.modificationTime = modificationTime;
        this.factor = factor;
        this.type = type;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public HddsProtos.ReplicationType getType() {
        return this.type;
    }

    public HddsProtos.ReplicationFactor getFactor() {
        return this.factor;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public long getDataSize() {
        return this.dataSize;
    }

    public void setDataSize(long size) {
        this.dataSize = size;
    }

    public synchronized OmKeyLocationInfoGroup getLatestVersionLocations() {
        return this.keyLocationVersions.size() == 0 ? null : this.keyLocationVersions.get(this.keyLocationVersions.size() - 1);
    }

    public List<OmKeyLocationInfoGroup> getKeyLocationVersions() {
        return this.keyLocationVersions;
    }

    public void updateModifcationTime() {
        this.modificationTime = Time.monotonicNow();
    }

    public void updateLocationInfoList(List<OmKeyLocationInfo> locationInfoList) {
        long latestVersion = this.getLatestVersionLocations().getVersion();
        OmKeyLocationInfoGroup keyLocationInfoGroup = this.getLatestVersionLocations();
        List<OmKeyLocationInfo> currentList = keyLocationInfoGroup.getLocationList();
        List<OmKeyLocationInfo> latestVersionList = keyLocationInfoGroup.getBlocksLatestVersionOnly();
        currentList.removeAll(latestVersionList);
        locationInfoList.stream().forEach(omKeyLocationInfo -> omKeyLocationInfo.setCreateVersion(latestVersion));
        currentList.addAll(locationInfoList);
    }

    public synchronized void appendNewBlocks(List<OmKeyLocationInfo> newLocationList) throws IOException {
        if (this.keyLocationVersions.size() == 0) {
            throw new IOException("Appending new block, but no version exist");
        }
        OmKeyLocationInfoGroup currentLatestVersion = this.keyLocationVersions.get(this.keyLocationVersions.size() - 1);
        currentLatestVersion.appendNewBlocks(newLocationList);
        this.setModificationTime(Time.now());
    }

    public synchronized long addNewVersion(List<OmKeyLocationInfo> newLocationList) throws IOException {
        long latestVersionNum;
        if (this.keyLocationVersions.size() == 0) {
            this.keyLocationVersions.add(new OmKeyLocationInfoGroup(0L, newLocationList));
            latestVersionNum = 0L;
        } else {
            OmKeyLocationInfoGroup currentLatestVersion = this.keyLocationVersions.get(this.keyLocationVersions.size() - 1);
            OmKeyLocationInfoGroup newVersion = currentLatestVersion.generateNextVersion(newLocationList);
            this.keyLocationVersions.add(newVersion);
            latestVersionNum = newVersion.getVersion();
        }
        this.setModificationTime(Time.now());
        return latestVersionNum;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    public void setModificationTime(long modificationTime) {
        this.modificationTime = modificationTime;
    }

    public OzoneManagerProtocolProtos.KeyInfo getProtobuf() {
        long latestVersion = this.keyLocationVersions.size() == 0 ? -1L : this.keyLocationVersions.get(this.keyLocationVersions.size() - 1).getVersion();
        return OzoneManagerProtocolProtos.KeyInfo.newBuilder().setVolumeName(this.volumeName).setBucketName(this.bucketName).setKeyName(this.keyName).setDataSize(this.dataSize).setFactor(this.factor).setType(this.type).addAllKeyLocationList(this.keyLocationVersions.stream().map(OmKeyLocationInfoGroup::getProtobuf).collect(Collectors.toList())).setLatestVersion(latestVersion).setCreationTime(this.creationTime).setModificationTime(this.modificationTime).build();
    }

    public static OmKeyInfo getFromProtobuf(OzoneManagerProtocolProtos.KeyInfo keyInfo) {
        return new OmKeyInfo(keyInfo.getVolumeName(), keyInfo.getBucketName(), keyInfo.getKeyName(), keyInfo.getKeyLocationListList().stream().map(OmKeyLocationInfoGroup::getFromProtobuf).collect(Collectors.toList()), keyInfo.getDataSize(), keyInfo.getCreationTime(), keyInfo.getModificationTime(), keyInfo.getType(), keyInfo.getFactor());
    }

    public static class Builder {
        private String volumeName;
        private String bucketName;
        private String keyName;
        private long dataSize;
        private List<OmKeyLocationInfoGroup> omKeyLocationInfoGroups;
        private long creationTime;
        private long modificationTime;
        private HddsProtos.ReplicationType type;
        private HddsProtos.ReplicationFactor factor;

        public Builder setVolumeName(String volume) {
            this.volumeName = volume;
            return this;
        }

        public Builder setBucketName(String bucket) {
            this.bucketName = bucket;
            return this;
        }

        public Builder setKeyName(String key) {
            this.keyName = key;
            return this;
        }

        public Builder setOmKeyLocationInfos(List<OmKeyLocationInfoGroup> omKeyLocationInfoList) {
            this.omKeyLocationInfoGroups = omKeyLocationInfoList;
            return this;
        }

        public Builder setDataSize(long size) {
            this.dataSize = size;
            return this;
        }

        public Builder setCreationTime(long crTime) {
            this.creationTime = crTime;
            return this;
        }

        public Builder setModificationTime(long mTime) {
            this.modificationTime = mTime;
            return this;
        }

        public Builder setReplicationFactor(HddsProtos.ReplicationFactor factor) {
            this.factor = factor;
            return this;
        }

        public Builder setReplicationType(HddsProtos.ReplicationType type) {
            this.type = type;
            return this;
        }

        public OmKeyInfo build() {
            return new OmKeyInfo(this.volumeName, this.bucketName, this.keyName, this.omKeyLocationInfoGroups, this.dataSize, this.creationTime, this.modificationTime, this.type, this.factor);
        }
    }
}

