/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.ozone.audit.Auditable;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;

public final class OmKeyArgs
implements Auditable {
    private final String volumeName;
    private final String bucketName;
    private final String keyName;
    private long dataSize;
    private final HddsProtos.ReplicationType type;
    private final HddsProtos.ReplicationFactor factor;
    private List<OmKeyLocationInfo> locationInfoList;

    private OmKeyArgs(String volumeName, String bucketName, String keyName, long dataSize, HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor, List<OmKeyLocationInfo> locationInfoList) {
        this.volumeName = volumeName;
        this.bucketName = bucketName;
        this.keyName = keyName;
        this.dataSize = dataSize;
        this.type = type;
        this.factor = factor;
        this.locationInfoList = locationInfoList;
    }

    public HddsProtos.ReplicationType getType() {
        return this.type;
    }

    public HddsProtos.ReplicationFactor getFactor() {
        return this.factor;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public long getDataSize() {
        return this.dataSize;
    }

    public void setDataSize(long size) {
        this.dataSize = size;
    }

    public void setLocationInfoList(List<OmKeyLocationInfo> locationInfoList) {
        this.locationInfoList = locationInfoList;
    }

    public List<OmKeyLocationInfo> getLocationInfoList() {
        return this.locationInfoList;
    }

    public Map<String, String> toAuditMap() {
        LinkedHashMap<String, String> auditMap = new LinkedHashMap<String, String>();
        auditMap.put("volume", this.volumeName);
        auditMap.put("bucket", this.bucketName);
        auditMap.put("key", this.keyName);
        auditMap.put("dataSize", String.valueOf(this.dataSize));
        auditMap.put("replicationType", this.type != null ? this.type.name() : null);
        auditMap.put("replicationFactor", this.factor != null ? this.factor.name() : null);
        auditMap.put("keyLocationInfo", this.locationInfoList != null ? this.locationInfoList.toString() : null);
        return auditMap;
    }

    @VisibleForTesting
    public void addLocationInfo(OmKeyLocationInfo locationInfo) {
        if (this.locationInfoList == null) {
            this.locationInfoList = new ArrayList<OmKeyLocationInfo>();
        }
        this.locationInfoList.add(locationInfo);
    }

    public static class Builder {
        private String volumeName;
        private String bucketName;
        private String keyName;
        private long dataSize;
        private HddsProtos.ReplicationType type;
        private HddsProtos.ReplicationFactor factor;
        private List<OmKeyLocationInfo> locationInfoList;

        public Builder setVolumeName(String volume) {
            this.volumeName = volume;
            return this;
        }

        public Builder setBucketName(String bucket) {
            this.bucketName = bucket;
            return this;
        }

        public Builder setKeyName(String key) {
            this.keyName = key;
            return this;
        }

        public Builder setDataSize(long size) {
            this.dataSize = size;
            return this;
        }

        public Builder setType(HddsProtos.ReplicationType replicationType) {
            this.type = replicationType;
            return this;
        }

        public Builder setFactor(HddsProtos.ReplicationFactor replicationFactor) {
            this.factor = replicationFactor;
            return this;
        }

        public Builder setLocationInfoList(List<OmKeyLocationInfo> locationInfos) {
            this.locationInfoList = locationInfos;
            return this;
        }

        public OmKeyArgs build() {
            return new OmKeyArgs(this.volumeName, this.bucketName, this.keyName, this.dataSize, this.type, this.factor, this.locationInfoList);
        }
    }
}

