/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class OzoneGetConf
extends Configured
implements Tool {
    private static final String DESCRIPTION = "ozone getconf is utility for getting configuration information from the config file.\n";
    static final String USAGE;
    private final PrintStream out;
    private final PrintStream err;

    protected OzoneGetConf(Configuration conf) {
        this(conf, System.out, System.err);
    }

    protected OzoneGetConf(Configuration conf, PrintStream out, PrintStream err) {
        super(conf);
        this.out = out;
        this.err = err;
    }

    void printError(String message) {
        this.err.println(message);
    }

    void printOut(String message) {
        this.out.println(message);
    }

    private void printUsage() {
        this.printError(USAGE);
    }

    private int doWork(String[] args) {
        CommandHandler handler;
        if (args.length >= 1 && (handler = Command.getHandler(args[0])) != null) {
            return handler.doWork(this, Arrays.copyOfRange(args, 1, args.length));
        }
        this.printUsage();
        return -1;
    }

    public int run(final String[] args) throws Exception {
        return (Integer)SecurityUtil.doAsCurrentUser((PrivilegedExceptionAction)new PrivilegedExceptionAction<Integer>(){

            @Override
            public Integer run() throws Exception {
                return OzoneGetConf.this.doWork(args);
            }
        });
    }

    public static void main(String[] args) throws Exception {
        if (DFSUtil.parseHelpArgument((String[])args, (String)USAGE, (PrintStream)System.out, (boolean)true)) {
            System.exit(0);
        }
        Configuration conf = new Configuration();
        conf.addResource((Configuration)new OzoneConfiguration());
        int res = ToolRunner.run((Tool)new OzoneGetConf(conf), (String[])args);
        System.exit(res);
    }

    static {
        HdfsConfiguration.init();
        StringBuilder usage = new StringBuilder(DESCRIPTION);
        usage.append("\nozone getconf \n");
        for (Command cmd : Command.values()) {
            usage.append("\t[" + cmd.getUsage() + "]\t\t\t" + cmd.getDescription() + "\n");
        }
        USAGE = usage.toString();
    }

    static class OzoneManagersCommandHandler
    extends CommandHandler {
        OzoneManagersCommandHandler() {
        }

        @Override
        public int doWorkInternal(OzoneGetConf tool, String[] args) throws IOException {
            tool.printOut(OmUtils.getOmAddress(tool.getConf()).getHostName());
            return 0;
        }
    }

    static class StorageContainerManagersCommandHandler
    extends CommandHandler {
        StorageContainerManagersCommandHandler() {
        }

        @Override
        public int doWorkInternal(OzoneGetConf tool, String[] args) throws IOException {
            Collection addresses = HddsUtils.getSCMAddresses((Configuration)tool.getConf());
            for (InetSocketAddress addr : addresses) {
                tool.printOut(addr.getHostName());
            }
            return 0;
        }
    }

    static class PrintConfKeyCommandHandler
    extends CommandHandler {
        PrintConfKeyCommandHandler() {
        }

        @Override
        protected void checkArgs(String[] args) {
            if (args.length != 1) {
                throw new HadoopIllegalArgumentException("usage: " + Command.CONFKEY.getUsage());
            }
        }

        @Override
        int doWorkInternal(OzoneGetConf tool, String[] args) throws Exception {
            this.key = args[0];
            return super.doWorkInternal(tool, args);
        }
    }

    static class CommandHandler {
        protected String key;

        CommandHandler() {
            this(null);
        }

        CommandHandler(String key) {
            this.key = key;
        }

        final int doWork(OzoneGetConf tool, String[] args) {
            try {
                this.checkArgs(args);
                return this.doWorkInternal(tool, args);
            }
            catch (Exception e) {
                tool.printError(e.getMessage());
                return -1;
            }
        }

        protected void checkArgs(String[] args) {
            if (args.length > 0) {
                throw new HadoopIllegalArgumentException("Did not expect argument: " + args[0]);
            }
        }

        int doWorkInternal(OzoneGetConf tool, String[] args) throws Exception {
            String value = tool.getConf().getTrimmed(this.key);
            if (value != null) {
                tool.printOut(value);
                return 0;
            }
            tool.printError("Configuration " + this.key + " is missing.");
            return -1;
        }
    }

    static enum Command {
        INCLUDE_FILE("-includeFile", "gets the include file path that defines the datanodes that can join the cluster."),
        EXCLUDE_FILE("-excludeFile", "gets the exclude file path that defines the datanodes that need to decommissioned."),
        OZONEMANAGER("-ozonemanagers", "gets list of Ozone Manager nodes in the cluster"),
        STORAGECONTAINERMANAGER("-storagecontainermanagers", "gets list of ozone storage container manager nodes in the cluster"),
        CONFKEY("-confKey [key]", "gets a specific key from the configuration");

        private static final Map<String, CommandHandler> HANDLERS;
        private final String cmd;
        private final String description;

        private Command(String cmd, String description) {
            this.cmd = cmd;
            this.description = description;
        }

        public String getName() {
            return this.cmd.split(" ")[0];
        }

        public String getUsage() {
            return this.cmd;
        }

        public String getDescription() {
            return this.description;
        }

        public static CommandHandler getHandler(String cmd) {
            return HANDLERS.get(StringUtils.toLowerCase((String)cmd));
        }

        static {
            HANDLERS = new HashMap<String, CommandHandler>();
            HANDLERS.put(StringUtils.toLowerCase((String)OZONEMANAGER.getName()), new OzoneManagersCommandHandler());
            HANDLERS.put(StringUtils.toLowerCase((String)STORAGECONTAINERMANAGER.getName()), new StorageContainerManagersCommandHandler());
            HANDLERS.put(StringUtils.toLowerCase((String)CONFKEY.getName()), new PrintConfKeyCommandHandler());
        }
    }
}

