/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client.rest.response;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdds.client.OzoneQuota;
import org.apache.hadoop.ozone.client.rest.response.VolumeOwner;

@InterfaceAudience.Private
public class VolumeInfo
implements Comparable<VolumeInfo> {
    private static final ObjectReader READER = new ObjectMapper().readerFor(VolumeInfo.class);
    private VolumeOwner owner;
    private OzoneQuota quota;
    private String volumeName;
    private String createdOn;
    private String createdBy;

    public VolumeInfo(String volumeName, String createdOn, String createdBy) {
        this.volumeName = volumeName;
        this.createdOn = createdOn;
        this.createdBy = createdBy;
    }

    public VolumeInfo() {
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public void setVolumeName(String volumeName) {
        this.volumeName = volumeName;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(String createdOn) {
        this.createdOn = createdOn;
    }

    public VolumeOwner getOwner() {
        return this.owner;
    }

    public void setOwner(VolumeOwner owner) {
        this.owner = owner;
    }

    public OzoneQuota getQuota() {
        return this.quota;
    }

    public void setQuota(OzoneQuota quota) {
        this.quota = quota;
    }

    @Override
    public int compareTo(VolumeInfo o) {
        return this.volumeName.compareTo(o.getVolumeName());
    }

    public static VolumeInfo parse(String data) throws IOException {
        return (VolumeInfo)READER.readValue(data);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VolumeInfo otherInfo = (VolumeInfo)obj;
        return otherInfo.getVolumeName().equals(this.getVolumeName());
    }

    public int hashCode() {
        return this.getVolumeName().hashCode();
    }
}

