/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client.rest.response;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.hdds.protocol.StorageType;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.OzoneConsts;

public class BucketInfo
implements Comparable<BucketInfo> {
    private static final ObjectReader READER = new ObjectMapper().readerFor(BucketInfo.class);
    private String volumeName;
    private String bucketName;
    private String createdOn;
    private List<OzoneAcl> acls;
    private OzoneConsts.Versioning versioning;
    private StorageType storageType;

    public BucketInfo(String volumeName, String bucketName) {
        this.volumeName = volumeName;
        this.bucketName = bucketName;
    }

    public BucketInfo() {
        this.acls = new LinkedList<OzoneAcl>();
    }

    public static BucketInfo parse(String jsonString) throws IOException {
        return (BucketInfo)READER.readValue(jsonString);
    }

    public List<OzoneAcl> getAcls() {
        return this.acls;
    }

    public void setAcls(List<OzoneAcl> acls) {
        this.acls = acls;
    }

    public StorageType getStorageType() {
        return this.storageType;
    }

    public void setStorageType(StorageType storageType) {
        this.storageType = storageType;
    }

    public OzoneConsts.Versioning getVersioning() {
        return this.versioning;
    }

    public void setVersioning(OzoneConsts.Versioning versioning) {
        this.versioning = versioning;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public void setCreatedOn(String creationTime) {
        this.createdOn = creationTime;
    }

    public String getCreatedOn() {
        return this.createdOn;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public void setVolumeName(String volumeName) {
        this.volumeName = volumeName;
    }

    @Override
    public int compareTo(BucketInfo o) {
        Preconditions.checkState((boolean)o.getVolumeName().equals(this.getVolumeName()));
        return this.bucketName.compareTo(o.getBucketName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BucketInfo)) {
            return false;
        }
        BucketInfo that = (BucketInfo)o;
        Preconditions.checkState((boolean)that.getVolumeName().equals(this.getVolumeName()));
        return this.bucketName.equals(that.bucketName);
    }

    public int hashCode() {
        return this.bucketName.hashCode();
    }
}

