/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public class OzoneException
extends Exception {
    private static final ObjectReader READER = new ObjectMapper().readerFor(OzoneException.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    @JsonProperty(value="httpCode")
    private long httpCode;
    @JsonProperty(value="shortMessage")
    private String shortMessage;
    @JsonProperty(value="resource")
    private String resource;
    @JsonProperty(value="message")
    private String message;
    @JsonProperty(value="requestID")
    private String requestId;
    @JsonProperty(value="hostName")
    private String hostID;

    public OzoneException() {
    }

    public OzoneException(long httpCode, String shortMessage, Exception ex) {
        super(ex);
        this.message = ex.getMessage();
        this.shortMessage = shortMessage;
        this.httpCode = httpCode;
    }

    public OzoneException(long httpCode, String shortMessage) {
        this.shortMessage = shortMessage;
        this.httpCode = httpCode;
    }

    public OzoneException(long httpCode, String shortMessage, String message) {
        this.shortMessage = shortMessage;
        this.message = message;
        this.httpCode = httpCode;
    }

    public OzoneException(long httpCode, String shortMessage, String message, Exception ex) {
        super(ex);
        this.shortMessage = shortMessage;
        this.message = message;
        this.httpCode = httpCode;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resourceName) {
        this.resource = resourceName;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String longMessage) {
        this.message = longMessage;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String ozoneRequestId) {
        this.requestId = ozoneRequestId;
    }

    public String getShortMessage() {
        return this.shortMessage;
    }

    public void setShortMessage(String shortError) {
        this.shortMessage = shortError;
    }

    public String getHostID() {
        return this.hostID;
    }

    public void setHostID(String hostName) {
        this.hostID = hostName;
    }

    public long getHttpCode() {
        return this.httpCode;
    }

    public void setHttpCode(long httpStatus) {
        this.httpCode = httpStatus;
    }

    public String toJsonString() {
        try {
            return MAPPER.writeValueAsString((Object)this);
        }
        catch (IOException iOException) {
            return "500 Internal Server Error";
        }
    }

    public static OzoneException parse(String jsonString) throws IOException {
        return (OzoneException)READER.readValue(jsonString);
    }

    static {
        MAPPER.setVisibility(MAPPER.getSerializationConfig().getDefaultVisibilityChecker().withCreatorVisibility(JsonAutoDetect.Visibility.NONE).withFieldVisibility(JsonAutoDetect.Visibility.NONE).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withIsGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE));
    }
}

