/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone;

import com.google.common.base.Optional;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.net.NetUtils;

public final class OmUtils {
    private OmUtils() {
    }

    public static InetSocketAddress getOmAddress(Configuration conf) {
        Optional host = HddsUtils.getHostNameFromConfigKeys((Configuration)conf, (String[])new String[]{"ozone.om.address"});
        return NetUtils.createSocketAddr((String)((String)host.or((Object)"0.0.0.0") + ":" + OmUtils.getOmRpcPort(conf)));
    }

    public static InetSocketAddress getOmAddressForClients(Configuration conf) {
        Optional host = HddsUtils.getHostNameFromConfigKeys((Configuration)conf, (String[])new String[]{"ozone.om.address"});
        if (!host.isPresent()) {
            throw new IllegalArgumentException("ozone.om.address must be defined. See https://wiki.apache.org/hadoop/Ozone#Configuration for details on configuring Ozone.");
        }
        return NetUtils.createSocketAddr((String)((String)host.get() + ":" + OmUtils.getOmRpcPort(conf)));
    }

    public static int getOmRpcPort(Configuration conf) {
        Optional port = HddsUtils.getPortNumberFromConfigKeys((Configuration)conf, (String[])new String[]{"ozone.om.address"});
        return (Integer)port.or((Object)9862);
    }

    public static int getOmRestPort(Configuration conf) {
        Optional port = HddsUtils.getPortNumberFromConfigKeys((Configuration)conf, (String[])new String[]{"ozone.om.http-address"});
        return (Integer)port.or((Object)9874);
    }
}

