/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.storage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.impl.RaftConfiguration;
import org.apache.ratis.server.impl.ServerProtoUtils;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.storage.RaftLog;
import org.apache.ratis.util.AutoCloseableLock;
import org.apache.ratis.util.Preconditions;

public class MemoryRaftLog
extends RaftLog {
    private final EntryList entries = new EntryList();
    private final AtomicReference<RaftLog.Metadata> metadata = new AtomicReference<RaftLog.Metadata>(new RaftLog.Metadata(null, 0L));

    public MemoryRaftLog(RaftPeerId selfId, int maxBufferSize) {
        super(selfId, maxBufferSize);
    }

    @Override
    public RaftProtos.LogEntryProto get(long index) {
        this.checkLogState();
        try (AutoCloseableLock readLock = this.readLock();){
            RaftProtos.LogEntryProto logEntryProto = this.entries.get(Math.toIntExact(index));
            return logEntryProto;
        }
    }

    @Override
    public RaftLog.EntryWithData getEntryWithData(long index) {
        return new RaftLog.EntryWithData(this, this.get(index), null);
    }

    @Override
    public TermIndex getTermIndex(long index) {
        this.checkLogState();
        try (AutoCloseableLock readLock = this.readLock();){
            TermIndex termIndex = this.entries.getTermIndex(Math.toIntExact(index));
            return termIndex;
        }
    }

    @Override
    public TermIndex[] getEntries(long startIndex, long endIndex) {
        this.checkLogState();
        try (AutoCloseableLock readLock = this.readLock();){
            if (startIndex >= (long)this.entries.size()) {
                TermIndex[] termIndexArray = null;
                return termIndexArray;
            }
            int from = Math.toIntExact(startIndex);
            int to = Math.toIntExact(Math.min((long)this.entries.size(), endIndex));
            TermIndex[] ti = new TermIndex[to - from];
            for (int i = 0; i < ti.length; ++i) {
                ti[i] = this.entries.getTermIndex(i);
            }
            TermIndex[] termIndexArray = ti;
            return termIndexArray;
        }
    }

    @Override
    CompletableFuture<Long> truncate(long index) {
        this.checkLogState();
        try (AutoCloseableLock writeLock = this.writeLock();){
            Preconditions.assertTrue((index >= 0L ? 1 : 0) != 0);
            this.entries.truncate(Math.toIntExact(index));
        }
        return CompletableFuture.completedFuture(index);
    }

    @Override
    public TermIndex getLastEntryTermIndex() {
        this.checkLogState();
        try (AutoCloseableLock readLock = this.readLock();){
            TermIndex termIndex = this.entries.getTermIndex(this.entries.size() - 1);
            return termIndex;
        }
    }

    @Override
    CompletableFuture<Long> appendEntry(RaftProtos.LogEntryProto entry) {
        this.checkLogState();
        try (AutoCloseableLock writeLock = this.writeLock();){
            this.validateLogEntry(entry);
            this.entries.add(entry);
        }
        return CompletableFuture.completedFuture(entry.getIndex());
    }

    @Override
    public long append(long term, RaftConfiguration newConf) {
        this.checkLogState();
        try (AutoCloseableLock writeLock = this.writeLock();){
            long nextIndex = this.getNextIndex();
            RaftProtos.LogEntryProto e = ServerProtoUtils.toLogEntryProto(newConf, term, nextIndex);
            this.entries.add(e);
            long l = nextIndex;
            return l;
        }
    }

    @Override
    public long getStartIndex() {
        return this.entries.size() == 0 ? -1L : this.entries.getTermIndex(0).getIndex();
    }

    @Override
    public List<CompletableFuture<Long>> append(RaftProtos.LogEntryProto ... entries) {
        this.checkLogState();
        if (entries == null || entries.length == 0) {
            return Collections.emptyList();
        }
        try (AutoCloseableLock writeLock = this.writeLock();){
            ArrayList<CompletableFuture<Long>> futures;
            boolean toTruncate = false;
            int truncateIndex = (int)entries[0].getIndex();
            int index = 0;
            while ((long)truncateIndex < this.getNextIndex() && index < entries.length) {
                if (this.entries.get(truncateIndex).getTerm() != entries[index].getTerm()) {
                    toTruncate = true;
                    break;
                }
                ++index;
                ++truncateIndex;
            }
            if (toTruncate) {
                futures = new ArrayList(entries.length - index + 1);
                futures.add(this.truncate(truncateIndex));
            } else {
                futures = new ArrayList<CompletableFuture<Long>>(entries.length - index);
            }
            for (int i = index; i < entries.length; ++i) {
                this.entries.add(entries[i]);
                futures.add(CompletableFuture.completedFuture(entries[i].getIndex()));
            }
            ArrayList<CompletableFuture<Long>> arrayList = futures;
            return arrayList;
        }
    }

    @Override
    public String toString() {
        return "last=" + this.getLastEntryTermIndex() + ", committed=" + ServerProtoUtils.toString(this.get(this.getLastCommittedIndex()));
    }

    public String getEntryString() {
        return "entries=" + this.entries;
    }

    @Override
    public long getLatestFlushedIndex() {
        return this.getNextIndex() - 1L;
    }

    @Override
    public void writeMetadata(long term, RaftPeerId votedFor) {
        this.metadata.set(new RaftLog.Metadata(votedFor, term));
    }

    @Override
    public RaftLog.Metadata loadMetadata() {
        return this.metadata.get();
    }

    @Override
    public void syncWithSnapshot(long lastSnapshotIndex) {
    }

    @Override
    public boolean isConfigEntry(TermIndex ti) {
        return this.get(ti.getIndex()).hasConfigurationEntry();
    }

    static class EntryList {
        private final List<RaftProtos.LogEntryProto> entries = new ArrayList<RaftProtos.LogEntryProto>();

        EntryList() {
        }

        RaftProtos.LogEntryProto get(int i) {
            return i >= 0 && i < this.entries.size() ? this.entries.get(i) : null;
        }

        TermIndex getTermIndex(int i) {
            return ServerProtoUtils.toTermIndex(this.get(i));
        }

        int size() {
            return this.entries.size();
        }

        void truncate(int index) {
            if (this.entries.size() > index) {
                this.entries.subList(index, this.entries.size()).clear();
            }
        }

        void add(RaftProtos.LogEntryProto entry) {
            this.entries.add(entry);
        }
    }
}

