/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.CompletableFuture;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WatchRequests {
    public static final Logger LOG = LoggerFactory.getLogger(WatchRequests.class);
    private final String name;
    private final Map<RaftProtos.ReplicationLevel, WatchQueue> queues = new EnumMap<RaftProtos.ReplicationLevel, WatchQueue>(RaftProtos.ReplicationLevel.class);

    WatchRequests(Object name) {
        this.name = name + "-" + this.getClass().getSimpleName();
        Arrays.stream(RaftProtos.ReplicationLevel.values()).forEach(r -> this.queues.put((RaftProtos.ReplicationLevel)r, new WatchQueue((RaftProtos.ReplicationLevel)r)));
    }

    CompletableFuture<Void> add(RaftProtos.WatchRequestTypeProto watch) {
        PendingWatch pending;
        WatchQueue queue = this.queues.get(watch.getReplication());
        if (watch.getIndex() > queue.getIndex() && queue.offer(pending = new PendingWatch(watch))) {
            return pending.getFuture();
        }
        return CompletableFuture.completedFuture(null);
    }

    void update(RaftProtos.ReplicationLevel replication, long newIndex) {
        WatchQueue queue = this.queues.get(replication);
        if (newIndex > queue.getIndex()) {
            queue.updateIndex(newIndex);
        }
    }

    void failWatches(Exception e) {
        this.queues.values().forEach(q -> q.failAll(e));
    }

    private class WatchQueue {
        private final RaftProtos.ReplicationLevel replication;
        private final PriorityQueue<PendingWatch> q = new PriorityQueue<PendingWatch>(Comparator.comparing(PendingWatch::getIndex));
        private volatile long index;

        WatchQueue(RaftProtos.ReplicationLevel replication) {
            this.replication = replication;
        }

        long getIndex() {
            return this.index;
        }

        synchronized boolean offer(PendingWatch pending) {
            if (pending.getIndex() > this.getIndex()) {
                boolean offered = this.q.offer(pending);
                Preconditions.assertTrue((boolean)offered);
                return true;
            }
            return false;
        }

        synchronized void updateIndex(long newIndex) {
            if (newIndex <= this.getIndex()) {
                return;
            }
            LOG.debug("{}: update {} index from {} to {}", new Object[]{WatchRequests.this.name, this.replication, this.index, newIndex});
            this.index = newIndex;
            PendingWatch peeked;
            while ((peeked = this.q.peek()) != null && peeked.getIndex() <= newIndex) {
                PendingWatch polled = this.q.poll();
                Preconditions.assertTrue((polled == peeked ? 1 : 0) != 0);
                LOG.debug("{}: complete {}", (Object)WatchRequests.this.name, (Object)polled);
                polled.getFuture().complete(null);
            }
            return;
        }

        synchronized void failAll(Exception e) {
            while (!this.q.isEmpty()) {
                this.q.poll().getFuture().completeExceptionally(e);
            }
        }
    }

    static class PendingWatch {
        private final RaftProtos.WatchRequestTypeProto watch;
        private final CompletableFuture<Void> future = new CompletableFuture();

        PendingWatch(RaftProtos.WatchRequestTypeProto watch) {
            this.watch = watch;
        }

        CompletableFuture<Void> getFuture() {
            return this.future;
        }

        long getIndex() {
            return this.watch.getIndex();
        }

        public String toString() {
            return RaftClientRequest.Type.toString((RaftProtos.WatchRequestTypeProto)this.watch);
        }
    }
}

