/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.NotLeaderException;
import org.apache.ratis.protocol.NotReplicatedException;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftException;
import org.apache.ratis.protocol.SetConfigurationRequest;
import org.apache.ratis.server.impl.RetryCache;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.util.Preconditions;

public class PendingRequest
implements Comparable<PendingRequest> {
    private final long index;
    private final RaftClientRequest request;
    private final TransactionContext entry;
    private final CompletableFuture<RaftClientReply> future;
    private volatile DelayedReply delayed;

    PendingRequest(long index, RaftClientRequest request, TransactionContext entry) {
        this.index = index;
        this.request = request;
        this.entry = entry;
        this.future = new CompletableFuture();
    }

    PendingRequest(SetConfigurationRequest request) {
        this(-1L, (RaftClientRequest)request, null);
    }

    long getIndex() {
        return this.index;
    }

    RaftClientRequest getRequest() {
        return this.request;
    }

    public CompletableFuture<RaftClientReply> getFuture() {
        return this.future;
    }

    TransactionContext getEntry() {
        return this.entry;
    }

    synchronized void setException(Throwable e) {
        Preconditions.assertTrue((e != null ? 1 : 0) != 0);
        this.future.completeExceptionally(e);
    }

    synchronized void setReply(RaftClientReply r) {
        Preconditions.assertTrue((r != null ? 1 : 0) != 0);
        this.future.complete(r);
    }

    synchronized void setDelayedReply(RaftClientReply r, RetryCache.CacheEntry c) {
        Objects.requireNonNull(r);
        Preconditions.assertTrue((this.delayed == null ? 1 : 0) != 0);
        this.delayed = new DelayedReply(r, c);
    }

    synchronized void completeDelayedReply() {
        this.setReply(this.delayed.getReply());
    }

    synchronized void failDelayedReply() {
        RaftProtos.ReplicationLevel replication = this.request.getType().getWrite().getReplication();
        NotReplicatedException e = new NotReplicatedException(this.request.getCallId(), replication, this.index);
        this.setReply(this.delayed.fail(e));
    }

    TransactionContext setNotLeaderException(NotLeaderException nle, Collection<RaftProtos.CommitInfoProto> commitInfos) {
        this.setReply(new RaftClientReply(this.getRequest(), (RaftException)nle, commitInfos));
        return this.getEntry();
    }

    @Override
    public int compareTo(PendingRequest that) {
        return Long.compare(this.index, that.index);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(index=" + this.index + ", request=" + this.request;
    }

    private static class DelayedReply {
        private final RaftClientReply reply;
        private final RetryCache.CacheEntry cacheEntry;

        DelayedReply(RaftClientReply reply, RetryCache.CacheEntry cacheEntry) {
            this.reply = reply;
            this.cacheEntry = cacheEntry;
        }

        RaftClientReply getReply() {
            this.cacheEntry.updateResult(this.reply);
            return this.reply;
        }

        RaftClientReply fail(NotReplicatedException e) {
            RaftClientReply failed = new RaftClientReply(this.reply, e);
            this.cacheEntry.updateResult(failed);
            return failed;
        }
    }
}

