/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.server.events;

import com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableRate;

public class EventWatcherMetrics {
    @Metric
    private MutableCounterLong trackedEvents;
    @Metric
    private MutableCounterLong timedOutEvents;
    @Metric
    private MutableCounterLong completedEvents;
    @Metric
    private MutableRate completionTime;

    public void incrementTrackedEvents() {
        this.trackedEvents.incr();
    }

    public void incrementTimedOutEvents() {
        this.timedOutEvents.incr();
    }

    public void incrementCompletedEvents() {
        this.completedEvents.incr();
    }

    @VisibleForTesting
    public void updateFinishingTime(long duration) {
        this.completionTime.add(duration);
    }

    @VisibleForTesting
    public MutableCounterLong getTrackedEvents() {
        return this.trackedEvents;
    }

    @VisibleForTesting
    public MutableCounterLong getTimedOutEvents() {
        return this.timedOutEvents;
    }

    @VisibleForTesting
    public MutableCounterLong getCompletedEvents() {
        return this.completedEvents;
    }

    @VisibleForTesting
    public MutableRate getCompletionTime() {
        return this.completionTime;
    }
}

