/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.genesis;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.common.helpers.Pipeline;
import org.apache.hadoop.hdds.scm.container.common.helpers.PipelineID;
import org.apache.hadoop.hdds.scm.container.states.ContainerStateMap;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.ozone.genesis.GenesisUtil;
import org.apache.hadoop.util.Time;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.infra.Blackhole;

@State(value=Scope.Thread)
public class BenchMarkContainerStateMap {
    private ContainerStateMap stateMap;
    private AtomicInteger containerID;
    private AtomicInteger runCount;
    private static int errorFrequency = 100;

    @Setup(value=Level.Trial)
    public void initialize() throws IOException {
        ContainerInfo containerInfo;
        this.stateMap = new ContainerStateMap();
        this.runCount = new AtomicInteger(0);
        Pipeline pipeline = BenchMarkContainerStateMap.createSingleNodePipeline(UUID.randomUUID().toString());
        Preconditions.checkNotNull((Object)pipeline, (Object)"Pipeline cannot be null.");
        int currentCount = 1;
        for (int x = 1; x < 1000; ++x) {
            try {
                containerInfo = new ContainerInfo.Builder().setState(HddsProtos.LifeCycleState.CLOSED).setPipelineID(pipeline.getId()).setReplicationType(pipeline.getType()).setReplicationFactor(pipeline.getFactor()).setAllocatedBytes(0L).setUsedBytes(0L).setNumberOfKeys(0L).setStateEnterTime(Time.monotonicNow()).setOwner("OZONE").setContainerID((long)x).setDeleteTransactionId(0L).build();
                this.stateMap.addContainer(containerInfo);
                ++currentCount;
                continue;
            }
            catch (SCMException e) {
                e.printStackTrace();
            }
        }
        for (int y = currentCount; y < 50000; ++y) {
            try {
                containerInfo = new ContainerInfo.Builder().setState(HddsProtos.LifeCycleState.OPEN).setPipelineID(pipeline.getId()).setReplicationType(pipeline.getType()).setReplicationFactor(pipeline.getFactor()).setAllocatedBytes(0L).setUsedBytes(0L).setNumberOfKeys(0L).setStateEnterTime(Time.monotonicNow()).setOwner("OZONE").setContainerID((long)y).setDeleteTransactionId(0L).build();
                this.stateMap.addContainer(containerInfo);
                ++currentCount;
                continue;
            }
            catch (SCMException e) {
                e.printStackTrace();
            }
        }
        try {
            ContainerInfo containerInfo2 = new ContainerInfo.Builder().setState(HddsProtos.LifeCycleState.OPEN).setPipelineID(pipeline.getId()).setReplicationType(pipeline.getType()).setReplicationFactor(pipeline.getFactor()).setAllocatedBytes(0L).setUsedBytes(0L).setNumberOfKeys(0L).setStateEnterTime(Time.monotonicNow()).setOwner("OZONE").setContainerID((long)currentCount++).setDeleteTransactionId(0L).build();
            this.stateMap.addContainer(containerInfo2);
        }
        catch (SCMException e) {
            e.printStackTrace();
        }
        this.containerID = new AtomicInteger(currentCount++);
    }

    public static Pipeline createSingleNodePipeline(String containerName) throws IOException {
        return BenchMarkContainerStateMap.createPipeline(containerName, 1);
    }

    public static Pipeline createPipeline(String containerName, int numNodes) throws IOException {
        Preconditions.checkArgument((numNodes >= 1 ? 1 : 0) != 0);
        ArrayList<DatanodeDetails> ids = new ArrayList<DatanodeDetails>(numNodes);
        for (int i = 0; i < numNodes; ++i) {
            ids.add(GenesisUtil.createDatanodeDetails(UUID.randomUUID().toString()));
        }
        return BenchMarkContainerStateMap.createPipeline(containerName, ids);
    }

    public static Pipeline createPipeline(String containerName, Iterable<DatanodeDetails> ids) throws IOException {
        Objects.requireNonNull(ids, "ids == null");
        Iterator<DatanodeDetails> i = ids.iterator();
        Preconditions.checkArgument((boolean)i.hasNext());
        DatanodeDetails leader = i.next();
        Pipeline pipeline = new Pipeline(leader.getUuidString(), HddsProtos.LifeCycleState.OPEN, HddsProtos.ReplicationType.STAND_ALONE, HddsProtos.ReplicationFactor.ONE, PipelineID.randomId());
        pipeline.addMember(leader);
        while (i.hasNext()) {
            pipeline.addMember(i.next());
        }
        return pipeline;
    }

    @Benchmark
    public void createContainerBenchMark(BenchMarkContainerStateMap state, Blackhole bh) throws IOException {
        ContainerInfo containerInfo = this.getContainerInfo(state);
        state.stateMap.addContainer(containerInfo);
    }

    private ContainerInfo getContainerInfo(BenchMarkContainerStateMap state) throws IOException {
        Pipeline pipeline = BenchMarkContainerStateMap.createSingleNodePipeline(UUID.randomUUID().toString());
        int cid = state.containerID.incrementAndGet();
        return new ContainerInfo.Builder().setState(HddsProtos.LifeCycleState.CLOSED).setPipelineID(pipeline.getId()).setReplicationType(pipeline.getType()).setReplicationFactor(pipeline.getFactor()).setAllocatedBytes(0L).setUsedBytes(0L).setNumberOfKeys(0L).setStateEnterTime(Time.monotonicNow()).setOwner("OZONE").setContainerID((long)cid).setDeleteTransactionId(0L).build();
    }

    @Benchmark
    public void getMatchingContainerBenchMark(BenchMarkContainerStateMap state, Blackhole bh) throws IOException {
        if (this.runCount.incrementAndGet() % errorFrequency == 0) {
            state.stateMap.addContainer(this.getContainerInfo(state));
        }
        bh.consume((Object)state.stateMap.getMatchingContainerIDs(HddsProtos.LifeCycleState.OPEN, "OZONE", HddsProtos.ReplicationFactor.ONE, HddsProtos.ReplicationType.STAND_ALONE));
    }
}

