/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import java.io.PrintStream;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Supplier;

public class ProgressBar {
    private static final long REFRESH_INTERVAL = 1000L;
    private PrintStream stream;
    private AtomicLong currentValue;
    private long maxValue;
    private Thread progressBar;
    private volatile boolean exception = false;
    private long startTime;

    ProgressBar(PrintStream stream, long maxValue) {
        this.stream = stream;
        this.maxValue = maxValue;
        this.currentValue = new AtomicLong(0L);
        this.progressBar = new Thread(new ProgressBarThread());
    }

    public void start(Runnable task) {
        this.startTime = System.nanoTime();
        try {
            this.progressBar.start();
            task.run();
        }
        catch (Exception e) {
            this.exception = true;
        }
        finally {
            try {
                this.progressBar.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T start(Supplier<T> task) {
        this.startTime = System.nanoTime();
        T result = null;
        try {
            this.progressBar.start();
            result = task.get();
            return result;
        }
        catch (Exception e) {
            this.exception = true;
            return this.exception;
        }
        finally {
            try {
                this.progressBar.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return result;
        }
    }

    public <T, R> R start(T input, Function<T, R> task) {
        this.startTime = System.nanoTime();
        R result = null;
        try {
            this.progressBar.start();
            result = task.apply(input);
            return result;
        }
        catch (Exception e) {
            this.exception = true;
            throw e;
        }
        finally {
            try {
                this.progressBar.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return result;
        }
    }

    public void incrementProgress() {
        this.currentValue.incrementAndGet();
    }

    private class ProgressBarThread
    implements Runnable {
        private ProgressBarThread() {
        }

        @Override
        public void run() {
            try {
                long value;
                ProgressBar.this.stream.println();
                while ((value = ProgressBar.this.currentValue.get()) < ProgressBar.this.maxValue) {
                    this.print(value);
                    if (ProgressBar.this.exception) break;
                    Thread.sleep(1000L);
                }
                if (ProgressBar.this.exception) {
                    ProgressBar.this.stream.println();
                    ProgressBar.this.stream.println("Incomplete termination, check log for exception.");
                } else {
                    this.print(ProgressBar.this.maxValue);
                }
                ProgressBar.this.stream.println();
            }
            catch (InterruptedException e) {
                ProgressBar.this.stream.println(e);
            }
        }

        private void print(long value) {
            ProgressBar.this.stream.print('\r');
            double percent = 100.0 * (double)value / (double)ProgressBar.this.maxValue;
            StringBuilder sb = new StringBuilder();
            sb.append(" " + String.format("%.2f", percent) + "% |");
            int i = 0;
            while ((double)i <= percent) {
                sb.append('\u2588');
                ++i;
            }
            int j = 0;
            while ((double)j < 100.0 - percent) {
                sb.append(' ');
                ++j;
            }
            sb.append("|  ");
            sb.append(value + "/" + ProgressBar.this.maxValue);
            long timeInSec = TimeUnit.SECONDS.convert(System.nanoTime() - ProgressBar.this.startTime, TimeUnit.NANOSECONDS);
            String timeToPrint = String.format("%d:%02d:%02d", timeInSec / 3600L, timeInSec % 3600L / 60L, timeInSec % 60L);
            sb.append(" Time: " + timeToPrint);
            ProgressBar.this.stream.print(sb.toString());
        }
    }
}

