/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.hadoop.hdds.scm.pipeline;

import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos.ReplicationFactor;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos.ReplicationType;
import org.apache.hadoop.hdds.scm.container.ContainerID;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Set;

/**
 * Interface which exposes the api for pipeline management.
 */
public interface PipelineManager extends Closeable {

  Pipeline createPipeline(ReplicationType type, ReplicationFactor factor)
      throws IOException;

  Pipeline createPipeline(ReplicationType type, List<DatanodeDetails> nodes)
      throws IOException;

  Pipeline getPipeline(PipelineID pipelineID) throws IOException;

  void addContainerToPipeline(PipelineID pipelineID, ContainerID containerID)
      throws IOException;

  void removeContainerFromPipeline(PipelineID pipelineID, ContainerID containerID)
      throws IOException;

  Set<ContainerID> getContainersInPipeline(PipelineID pipelineID)
      throws IOException;

  void finalizePipeline(PipelineID pipelineID) throws IOException;

  void closePipeline(PipelineID pipelineId) throws IOException;

  void removePipeline(PipelineID pipelineID) throws IOException;
}
