/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli.container;

import com.google.common.base.Preconditions;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.cli.SCMCLI;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerWithPipeline;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="info", description={"Show information about a specific container"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class InfoSubcommand
implements Callable<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(InfoSubcommand.class);
    @CommandLine.ParentCommand
    private SCMCLI parent;
    @CommandLine.Parameters(description={"Decimal id of the container."})
    private long containerID;

    @Override
    public Void call() throws Exception {
        try (ScmClient scmClient = this.parent.createScmClient();){
            ContainerWithPipeline container = scmClient.getContainerWithPipeline(this.containerID);
            Preconditions.checkNotNull((Object)container, (Object)"Container cannot be null");
            ContainerProtos.ContainerData containerData = scmClient.readContainer(container.getContainerInfo().getContainerID(), container.getPipeline());
            LOG.info("Container id: {}", (Object)this.containerID);
            String openStatus = containerData.getState() == ContainerProtos.ContainerLifeCycleState.OPEN ? "OPEN" : "CLOSED";
            LOG.info("Container State: {}", (Object)openStatus);
            LOG.info("Container Path: {}", (Object)containerData.getContainerPath());
            String metadataStr = containerData.getMetadataList().stream().map(p -> p.getKey() + ":" + p.getValue()).collect(Collectors.joining(", "));
            LOG.info("Container Metadata: {}", (Object)metadataStr);
            LOG.info("LeaderID: {}", (Object)container.getPipeline().getLeader().getHostName());
            String machinesStr = container.getPipeline().getMachines().stream().map(DatanodeDetails::getHostName).collect(Collectors.joining(","));
            LOG.info("Datanodes: [{}]", (Object)machinesStr);
            Void void_ = null;
            return void_;
        }
    }
}

