/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli;

import java.io.IOException;
import java.net.InetSocketAddress;
import javax.net.SocketFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.StorageUnit;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.cli.GenericCli;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.scm.XceiverClientManager;
import org.apache.hadoop.hdds.scm.cli.container.CloseSubcommand;
import org.apache.hadoop.hdds.scm.cli.container.CreateSubcommand;
import org.apache.hadoop.hdds.scm.cli.container.DeleteSubcommand;
import org.apache.hadoop.hdds.scm.cli.container.InfoSubcommand;
import org.apache.hadoop.hdds.scm.cli.container.ListSubcommand;
import org.apache.hadoop.hdds.scm.client.ContainerOperationClient;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerInfo;
import org.apache.hadoop.hdds.scm.protocolPB.StorageContainerLocationProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdds.scm.protocolPB.StorageContainerLocationProtocolPB;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.NativeCodeLoader;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import picocli.CommandLine;

@CommandLine.Command(name="ozone scmcli", hidden=true, description={"Developer tools to handle SCM specific operations."}, versionProvider=HddsVersionProvider.class, subcommands={ListSubcommand.class, InfoSubcommand.class, DeleteSubcommand.class, CreateSubcommand.class, CloseSubcommand.class}, mixinStandardHelpOptions=true)
public class SCMCLI
extends GenericCli {
    @CommandLine.Option(names={"--scm"}, description={"The destination scm (host:port)"})
    private String scm = "";

    public static void main(String[] argv) throws Exception {
        LogManager.resetConfiguration();
        Logger.getRootLogger().setLevel(Level.INFO);
        Logger.getRootLogger().addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout("%m%n")));
        Logger.getLogger(NativeCodeLoader.class).setLevel(Level.ERROR);
        new SCMCLI().run(argv);
    }

    public ScmClient createScmClient() throws IOException {
        OzoneConfiguration ozoneConf = this.createOzoneConfiguration();
        if (StringUtils.isNotEmpty((CharSequence)this.scm)) {
            ozoneConf.set("ozone.scm.client.address", this.scm);
        }
        if (!HddsUtils.getHostNameFromConfigKeys((Configuration)ozoneConf, (String[])new String[]{"ozone.scm.client.address"}).isPresent()) {
            throw new IllegalArgumentException("ozone.scm.client.address should be set in ozone-site.xml or with the --scm option");
        }
        long version = RPC.getProtocolVersion(StorageContainerLocationProtocolPB.class);
        InetSocketAddress scmAddress = HddsUtils.getScmAddressForClients((Configuration)ozoneConf);
        int containerSizeGB = (int)ozoneConf.getStorageSize("ozone.scm.container.size", "5GB", StorageUnit.GB);
        ContainerOperationClient.setContainerSizeB((long)((long)containerSizeGB * 0x40000000L));
        RPC.setProtocolEngine((Configuration)ozoneConf, StorageContainerLocationProtocolPB.class, ProtobufRpcEngine.class);
        StorageContainerLocationProtocolClientSideTranslatorPB client = new StorageContainerLocationProtocolClientSideTranslatorPB((StorageContainerLocationProtocolPB)RPC.getProxy(StorageContainerLocationProtocolPB.class, (long)version, (InetSocketAddress)scmAddress, (UserGroupInformation)UserGroupInformation.getCurrentUser(), (Configuration)ozoneConf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)ozoneConf), (int)Client.getRpcTimeout((Configuration)ozoneConf)));
        return new ContainerOperationClient(client, new XceiverClientManager((Configuration)ozoneConf));
    }

    public void checkContainerExists(ScmClient scmClient, long containerId) throws IOException {
        ContainerInfo container = scmClient.getContainer(containerId);
        if (container == null) {
            throw new IllegalArgumentException("No such container " + containerId);
        }
    }
}

