/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.genesis;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.Random;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.StorageUnit;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.utils.MetadataStore;
import org.apache.hadoop.utils.MetadataStoreBuilder;

public final class GenesisUtil {
    public static final String DEFAULT_TYPE = "default";
    public static final String CACHE_10MB_TYPE = "Cache10MB";
    public static final String CACHE_1GB_TYPE = "Cache1GB";
    public static final String CLOSED_TYPE = "ClosedContainer";
    private static final int DB_FILE_LEN = 7;
    private static final String TMP_DIR = "java.io.tmpdir";

    private GenesisUtil() {
    }

    public static MetadataStore getMetadataStore(String dbType) throws IOException {
        Configuration conf = new Configuration();
        MetadataStoreBuilder builder = MetadataStoreBuilder.newBuilder();
        builder.setConf(conf);
        builder.setCreateIfMissing(true);
        builder.setDbFile(Paths.get(System.getProperty(TMP_DIR), new String[0]).resolve(RandomStringUtils.randomNumeric((int)7)).toFile());
        switch (dbType) {
            case "default": {
                break;
            }
            case "ClosedContainer": {
                break;
            }
            case "Cache10MB": {
                builder.setCacheSize((long)StorageUnit.MB.toBytes(10.0));
                break;
            }
            case "Cache1GB": {
                builder.setCacheSize((long)StorageUnit.GB.toBytes(1.0));
                break;
            }
            default: {
                throw new IllegalStateException("Unknown type: " + dbType);
            }
        }
        return builder.build();
    }

    public static DatanodeDetails createDatanodeDetails(String uuid) {
        Random random = new Random();
        String ipAddress = random.nextInt(256) + "." + random.nextInt(256) + "." + random.nextInt(256) + "." + random.nextInt(256);
        DatanodeDetails.Port containerPort = DatanodeDetails.newPort((DatanodeDetails.Port.Name)DatanodeDetails.Port.Name.STANDALONE, (Integer)0);
        DatanodeDetails.Port ratisPort = DatanodeDetails.newPort((DatanodeDetails.Port.Name)DatanodeDetails.Port.Name.RATIS, (Integer)0);
        DatanodeDetails.Port restPort = DatanodeDetails.newPort((DatanodeDetails.Port.Name)DatanodeDetails.Port.Name.REST, (Integer)0);
        DatanodeDetails.Builder builder = DatanodeDetails.newBuilder();
        builder.setUuid(uuid).setHostName("localhost").setIpAddress(ipAddress).addPort(containerPort).addPort(ratisPort).addPort(restPort);
        return builder.build();
    }
}

