/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.genesis;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.hadoop.conf.StorageUnit;
import org.apache.hadoop.utils.MetadataStore;
import org.apache.hadoop.utils.RocksDBStore;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.infra.Blackhole;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.BloomFilter;
import org.rocksdb.CompactionStyle;
import org.rocksdb.Filter;
import org.rocksdb.IndexType;
import org.rocksdb.Options;
import org.rocksdb.TableFormatConfig;

@State(value=Scope.Thread)
public class BenchMarkRocksDbStore {
    private static final int DATA_LEN = 1024;
    private static final long MAX_KEYS = 10240L;
    private static final int DB_FILE_LEN = 7;
    private static final String TMP_DIR = "java.io.tmpdir";
    private MetadataStore store;
    private byte[] data;
    @Param(value={"8"})
    private String blockSize;
    @Param(value={"64"})
    private String writeBufferSize;
    @Param(value={"16"})
    private String maxWriteBufferNumber;
    @Param(value={"4"})
    private String maxBackgroundFlushes;
    @Param(value={"512"})
    private String maxBytesForLevelBase;
    @Param(value={"4"})
    private String backgroundThreads;
    @Param(value={"5000"})
    private String maxOpenFiles;

    @Setup(value=Level.Trial)
    public void initialize() throws IOException {
        this.data = RandomStringUtils.randomAlphanumeric((int)1024).getBytes(Charset.forName("UTF-8"));
        Options opts = new Options();
        File dbFile = Paths.get(System.getProperty(TMP_DIR), new String[0]).resolve(RandomStringUtils.randomNumeric((int)7)).toFile();
        opts.setCreateIfMissing(true);
        opts.setWriteBufferSize((long)StorageUnit.MB.toBytes((double)Long.parseLong(this.writeBufferSize)));
        opts.setMaxWriteBufferNumber(Integer.parseInt(this.maxWriteBufferNumber));
        opts.setMaxBackgroundFlushes(Integer.parseInt(this.maxBackgroundFlushes));
        BlockBasedTableConfig tableConfig = new BlockBasedTableConfig();
        tableConfig.setBlockSize((long)StorageUnit.KB.toBytes((double)Long.parseLong(this.blockSize)));
        opts.setMaxOpenFiles(Integer.parseInt(this.maxOpenFiles));
        opts.setMaxBytesForLevelBase((long)StorageUnit.MB.toBytes((double)Long.parseLong(this.maxBytesForLevelBase)));
        opts.setCompactionStyle(CompactionStyle.UNIVERSAL);
        opts.setLevel0FileNumCompactionTrigger(10);
        opts.setLevel0SlowdownWritesTrigger(20);
        opts.setLevel0StopWritesTrigger(40);
        opts.setTargetFileSizeBase((long)StorageUnit.MB.toBytes((double)Long.parseLong(this.maxBytesForLevelBase)) / 10L);
        opts.setMaxBackgroundCompactions(8);
        opts.setUseFsync(false);
        opts.setBytesPerSync(0x800000L);
        BloomFilter bloomFilter = new BloomFilter(20);
        tableConfig.setCacheIndexAndFilterBlocks(true);
        tableConfig.setIndexType(IndexType.kHashSearch);
        tableConfig.setFilter((Filter)bloomFilter);
        opts.setTableFormatConfig((TableFormatConfig)tableConfig);
        opts.useCappedPrefixExtractor(4);
        this.store = new RocksDBStore(dbFile, opts);
    }

    @TearDown(value=Level.Trial)
    public void cleanup() throws IOException {
        this.store.destroy();
        FileUtils.deleteDirectory((File)new File(TMP_DIR));
    }

    @Benchmark
    public void test(Blackhole bh) throws IOException {
        long x = RandomUtils.nextLong((long)0L, (long)10240L);
        this.store.put(Long.toHexString(x).getBytes(Charset.forName("UTF-8")), this.data);
        bh.consume((Object)this.store.get(Long.toHexString(x).getBytes(Charset.forName("UTF-8"))));
    }
}

