/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.genconf;

import java.io.File;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;

public final class GenerateOzoneRequiredConfigurations {
    private static final String OUTPUT = "-output";
    private static final String HELP = "-help";
    private static final String USAGE = "Usage: \nozone genconf -output <Path to output file> \nozone genconf -help";
    private static final int SUCCESS = 0;
    private static final int FAILURE = 1;

    private GenerateOzoneRequiredConfigurations() {
    }

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                System.out.println(USAGE);
                System.exit(1);
            }
            switch (args[0]) {
                case "-output": {
                    if (args.length > 1) {
                        int n = GenerateOzoneRequiredConfigurations.generateConfigurations(args[1]);
                        break;
                    }
                    System.out.println("Path to output file is mandatory");
                    System.out.println(USAGE);
                    System.exit(1);
                    break;
                }
                case "-help": {
                    System.out.println(USAGE);
                    System.exit(0);
                    break;
                }
                default: {
                    System.out.println(USAGE);
                    System.exit(1);
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isValidPath(String path) {
        try {
            return Files.isDirectory(Paths.get(path, new String[0]), new LinkOption[0]);
        }
        catch (NullPointerException | InvalidPathException ex) {
            return false;
        }
    }

    public static boolean canWrite(String path) {
        File file = new File(path);
        return file.canWrite();
    }

    public static int generateConfigurations(String path) throws JAXBException {
        if (!GenerateOzoneRequiredConfigurations.isValidPath(path)) {
            System.out.println("Invalid directory path.");
            return 1;
        }
        if (!GenerateOzoneRequiredConfigurations.canWrite(path)) {
            System.out.println("Insufficient permission.");
            return 1;
        }
        OzoneConfiguration oc = new OzoneConfiguration();
        ClassLoader cL = Thread.currentThread().getContextClassLoader();
        if (cL == null) {
            cL = OzoneConfiguration.class.getClassLoader();
        }
        URL url = cL.getResource("ozone-default.xml");
        List allProperties = oc.readPropertyFromXml(url);
        ArrayList<OzoneConfiguration.Property> requiredProperties = new ArrayList<OzoneConfiguration.Property>();
        for (OzoneConfiguration.Property p : allProperties) {
            if (p.getTag() == null || !p.getTag().contains("REQUIRED")) continue;
            requiredProperties.add(p);
        }
        OzoneConfiguration.XMLConfiguration requiredConfig = new OzoneConfiguration.XMLConfiguration();
        requiredConfig.setProperties(requiredProperties);
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{OzoneConfiguration.XMLConfiguration.class});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        m.marshal((Object)requiredConfig, new File(path, "ozone-site.xml"));
        System.out.println("ozone-site.xml has been generated at " + path);
        return 0;
    }
}

